/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDependencyPlatformIdFilter
extends AbstractDependencyFilter {
    private Set<NutsId> accepted = new HashSet<NutsId>();

    public NutsDependencyPlatformIdFilter(NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyPlatformIdFilter(NutsSession session, Collection<NutsId> accepted) {
        super(session, NutsFilterOp.CUSTOM);
        this.accepted = new LinkedHashSet<NutsId>(accepted);
    }

    public NutsDependencyPlatformIdFilter add(Collection<NutsId> os) {
        LinkedHashSet<NutsId> s2 = new LinkedHashSet<NutsId>(this.accepted);
        s2.addAll(os);
        return new NutsDependencyPlatformIdFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String[] current = (String[])NutsStream.of((Object[])dependency.getCondition().getPlatform(), (NutsSession)session).filterNonBlank().toArray(String[]::new);
        if (current.length == 0 || this.accepted.isEmpty()) {
            return true;
        }
        for (NutsId nutsId : this.accepted) {
            if (!CoreFilterUtils.matchesPlatform(nutsId.toString(), current, session)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.accepted.isEmpty() ? "true" : "os in (" + this.accepted.stream().map(Object::toString).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.accepted.isEmpty() ? (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)this.getSession()).always() : this;
    }
}

