/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;

public class NutsDependencyPlatformFamilyFilter
extends AbstractDependencyFilter {
    private Set<NutsPlatformFamily> accepted = EnumSet.noneOf(NutsPlatformFamily.class);

    public NutsDependencyPlatformFamilyFilter(NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyPlatformFamilyFilter(NutsSession session, Collection<NutsPlatformFamily> accepted) {
        super(session, NutsFilterOp.CUSTOM);
        this.accepted = EnumSet.copyOf(accepted);
    }

    public NutsDependencyPlatformFamilyFilter(NutsSession session, String accepted) {
        super(session, NutsFilterOp.CUSTOM);
        this.accepted = EnumSet.noneOf(NutsPlatformFamily.class);
        for (String e : accepted.split("[,; ]")) {
            if (e.isEmpty()) continue;
            this.accepted.add(NutsPlatformFamily.parseLenient((String)e));
        }
    }

    public NutsDependencyPlatformFamilyFilter add(Collection<NutsPlatformFamily> os) {
        EnumSet<NutsPlatformFamily> s2 = EnumSet.copyOf(this.accepted);
        s2.addAll(os);
        return new NutsDependencyPlatformFamilyFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String[] current = dependency.getCondition().getPlatform();
        boolean empty = true;
        if (current != null) {
            for (String e : current) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.accepted.contains(NutsPlatformFamily.parseLenient((String)e))) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return this.accepted.isEmpty() ? "true" : "os in (" + this.accepted.stream().map(NutsPlatformFamily::id).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.accepted.isEmpty() ? (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)this.getSession()).always() : this;
    }
}

