/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDependencyFilterOr
extends AbstractDependencyFilter {
    private final NutsDependencyFilter[] all;

    public NutsDependencyFilterOr(NutsSession session, NutsDependencyFilter ... all) {
        super(session, NutsFilterOp.OR);
        this.all = all;
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        boolean one = false;
        for (NutsDependencyFilter nutsDependencyFilter : this.all) {
            if (nutsDependencyFilter == null) continue;
            one = true;
            if (!nutsDependencyFilter.acceptDependency(from, dependency, session)) continue;
            return true;
        }
        return !one;
    }

    @Override
    public NutsDependencyFilter simplify() {
        return CoreFilterUtils.simplifyFilterOr(this.getSession(), NutsDependencyFilter.class, this, (NutsFilter[])this.all);
    }

    public String toString() {
        return String.join((CharSequence)" Or ", Arrays.asList(this.all).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList()));
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDependencyFilterOr other = (NutsDependencyFilterOr)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.all;
    }
}

