/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;

public class NutsDependencyDEFilter
extends AbstractDependencyFilter {
    private Set<NutsDesktopEnvironmentFamily> accepted = EnumSet.noneOf(NutsDesktopEnvironmentFamily.class);

    public NutsDependencyDEFilter(NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyDEFilter(NutsSession session, Collection<NutsDesktopEnvironmentFamily> accepted) {
        super(session, NutsFilterOp.CUSTOM);
        this.accepted = EnumSet.copyOf(accepted);
    }

    public NutsDependencyDEFilter(NutsSession session, String accepted) {
        super(session, NutsFilterOp.CUSTOM);
        this.accepted = EnumSet.noneOf(NutsDesktopEnvironmentFamily.class);
        for (String e : accepted.split("[,; ]")) {
            if (e.isEmpty()) continue;
            this.accepted.add(NutsDesktopEnvironmentFamily.parseLenient((String)e));
        }
    }

    public NutsDependencyDEFilter add(Collection<NutsDesktopEnvironmentFamily> os) {
        EnumSet<NutsDesktopEnvironmentFamily> s2 = EnumSet.copyOf(this.accepted);
        s2.addAll(os);
        return new NutsDependencyDEFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String[] current = dependency.getCondition().getDesktopEnvironment();
        boolean empty = true;
        if (current != null) {
            for (String e : current) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.accepted.contains(NutsDesktopEnvironmentFamily.parseLenient((String)e))) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return this.accepted.isEmpty() ? "true" : "desktopEnvironment in (" + this.accepted.stream().map(NutsDesktopEnvironmentFamily::id).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.accepted.isEmpty() ? (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)this.getSession()).always() : this;
    }
}

