/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;

public class NutsDependencyArchFamilyFilter
extends AbstractDependencyFilter {
    private Set<NutsArchFamily> archs = EnumSet.noneOf(NutsArchFamily.class);

    public NutsDependencyArchFamilyFilter(NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyArchFamilyFilter(NutsSession session, Collection<NutsArchFamily> os) {
        super(session, NutsFilterOp.CUSTOM);
        this.archs = EnumSet.copyOf(os);
    }

    public NutsDependencyArchFamilyFilter(NutsSession session, String os) {
        super(session, NutsFilterOp.CUSTOM);
        this.archs = EnumSet.noneOf(NutsArchFamily.class);
        for (String e : os.split("[,; ]")) {
            if (e.isEmpty()) continue;
            this.archs.add(NutsArchFamily.parseLenient((String)e, (NutsArchFamily)NutsArchFamily.UNKNOWN));
        }
    }

    public NutsDependencyArchFamilyFilter add(Collection<NutsArchFamily> os) {
        EnumSet<NutsArchFamily> s2 = EnumSet.copyOf(this.archs);
        s2.addAll(os);
        return new NutsDependencyArchFamilyFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String[] current = dependency.getCondition().getArch();
        boolean empty = true;
        if (current != null) {
            for (String e : current) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.archs.contains(NutsArchFamily.parseLenient((String)e, (NutsArchFamily)NutsArchFamily.UNKNOWN))) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return this.archs.isEmpty() ? "true" : "arch in (" + this.archs.stream().map(x -> x.id()).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.archs.isEmpty() ? (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)this.getSession()).always() : this;
    }
}

