/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyArchFamilyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyDEFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyFilterAnd;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyFilterFalse;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyFilterNone;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyFilterOr;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyFilterParser;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyFilterTrue;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyOptionFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyOsDistIdFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyOsFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyPlatformFamilyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyPlatformIdFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyScopeFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsDependencyTypeFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NutsExclusionDependencyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.ScopeNutsDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class InternalNutsDependencyFilters
extends InternalNutsTypedFilters<NutsDependencyFilter>
implements NutsDependencyFilters {
    public InternalNutsDependencyFilters(NutsSession session) {
        super(session, NutsDependencyFilter.class);
    }

    public NutsDependencyFilter always() {
        this.checkSession();
        return new NutsDependencyFilterTrue(this.getSession());
    }

    public NutsDependencyFilter never() {
        this.checkSession();
        return new NutsDependencyFilterFalse(this.getSession());
    }

    public NutsDependencyFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDependencyFilter)all.get(0);
        }
        return new NutsDependencyFilterAnd(this.getSession(), all.toArray(new NutsDependencyFilter[0]));
    }

    public NutsDependencyFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDependencyFilter)all.get(0);
        }
        return new NutsDependencyFilterOr(this.getSession(), all.toArray(new NutsDependencyFilter[0]));
    }

    public NutsDependencyFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsDependencyFilterNone(this.getSession(), (NutsDependencyFilter)other);
    }

    public NutsDependencyFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsDependencyFilterNone(this.getSession(), all.toArray(new NutsDependencyFilter[0]));
    }

    public NutsDependencyFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsDependencyFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a NutsDependencyFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsDependencyFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsDependencyFilter) {
            return (NutsDependencyFilter)a;
        }
        return null;
    }

    public NutsDependencyFilter parse(String expression) {
        this.checkSession();
        return (NutsDependencyFilter)new NutsDependencyFilterParser(expression, this.getSession()).parse();
    }

    @Override
    public NutsDependencyFilter nonnull(NutsFilter filter) {
        this.checkSession();
        return (NutsDependencyFilter)super.nonnull(filter);
    }

    public NutsDependencyFilter byScope(NutsDependencyScopePattern scope) {
        this.checkSession();
        if (scope == null) {
            return this.always();
        }
        return new ScopeNutsDependencyFilter(this.getSession(), scope);
    }

    public NutsDependencyFilter byScope(NutsDependencyScope scope) {
        this.checkSession();
        if (scope == null) {
            return this.always();
        }
        return new NutsDependencyScopeFilter(this.getSession()).add(Arrays.asList(scope));
    }

    public NutsDependencyFilter byScope(NutsDependencyScope ... scopes) {
        this.checkSession();
        if (scopes == null) {
            return this.always();
        }
        return new NutsDependencyScopeFilter(this.getSession()).add(Arrays.asList(scopes));
    }

    public NutsDependencyFilter byScope(Collection<NutsDependencyScope> scopes) {
        this.checkSession();
        if (scopes == null) {
            return this.always();
        }
        return new NutsDependencyScopeFilter(this.getSession()).add(scopes);
    }

    public NutsDependencyFilter byOptional(Boolean optional) {
        this.checkSession();
        if (optional == null) {
            return this.always();
        }
        return new NutsDependencyOptionFilter(this.getSession(), optional);
    }

    public NutsDependencyFilter byExclude(NutsDependencyFilter filter, String[] exclusions) {
        this.checkSession();
        return new NutsExclusionDependencyFilter(this.getSession(), filter, (NutsId[])Arrays.stream(exclusions).map(x -> NutsId.of((String)x, (NutsSession)this.getSession())).toArray(NutsId[]::new));
    }

    public NutsDependencyFilter byArch(Collection<NutsArchFamily> archs) {
        this.checkSession();
        if (archs == null) {
            return this.always();
        }
        return new NutsDependencyArchFamilyFilter(this.getSession()).add(archs);
    }

    public NutsDependencyFilter byArch(NutsArchFamily arch) {
        this.checkSession();
        if (arch == null) {
            return this.always();
        }
        return new NutsDependencyArchFamilyFilter(this.getSession()).add(Arrays.asList(arch));
    }

    public NutsDependencyFilter byArch(NutsArchFamily ... archs) {
        this.checkSession();
        if (archs == null) {
            return this.always();
        }
        return new NutsDependencyArchFamilyFilter(this.getSession()).add(Arrays.asList(archs));
    }

    public NutsDependencyFilter byArch(String arch) {
        this.checkSession();
        if (arch == null) {
            return this.always();
        }
        return new NutsDependencyArchFamilyFilter(this.getSession(), arch);
    }

    public NutsDependencyFilter byOs(Collection<NutsOsFamily> os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession()).add(os);
    }

    public NutsDependencyFilter byCurrentDesktop() {
        this.checkSession();
        return this.byDesktop(this.getSession().env().getDesktopEnvironmentFamilies());
    }

    public NutsDependencyFilter byCurrentArch() {
        this.checkSession();
        return this.byArch(this.getSession().env().getArchFamily());
    }

    public NutsDependencyFilter byCurrentOs() {
        this.checkSession();
        return this.byOs(this.getSession().env().getOsFamily());
    }

    public NutsDependencyFilter byRegularType() {
        return this.byType(null).or(this.byType("jar"));
    }

    public NutsDependencyFilter byCurrentEnv() {
        return this.byCurrentOs().and(this.byCurrentArch()).and(this.byCurrentDesktop());
    }

    public NutsDependencyFilter byRunnable(boolean optional) {
        return this.byScope(NutsDependencyScopePattern.RUN).and(this.byOptional(optional ? null : Boolean.valueOf(false))).and(this.byRegularType()).and(this.byCurrentEnv());
    }

    public NutsDependencyFilter byRunnable() {
        return this.byRunnable(false);
    }

    public NutsDependencyFilter byOs(NutsOsFamily os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession()).add(Arrays.asList(os));
    }

    public NutsDependencyFilter byOs(NutsOsFamily ... os) {
        this.checkSession();
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession()).add(Arrays.asList(os));
    }

    public NutsDependencyFilter byDesktop(NutsDesktopEnvironmentFamily de) {
        this.checkSession();
        if (de == null) {
            return this.always();
        }
        return new NutsDependencyDEFilter(this.getSession()).add(Arrays.asList(de));
    }

    public NutsDependencyFilter byDesktop(NutsDesktopEnvironmentFamily ... de) {
        this.checkSession();
        this.checkSession();
        if (de == null) {
            return this.always();
        }
        return new NutsDependencyDEFilter(this.getSession()).add(Arrays.asList(de));
    }

    public NutsDependencyFilter byType(String type) {
        return new NutsDependencyTypeFilter(this.getSession(), type);
    }

    public NutsDependencyFilter byOs(String os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession(), os);
    }

    public NutsDependencyFilter byOsDist(String osDist) {
        this.checkSession();
        if (osDist == null) {
            return this.always();
        }
        return new NutsDependencyOsDistIdFilter(this.getSession()).add(Collections.singletonList(NutsId.of((String)osDist, (NutsSession)this.getSession())));
    }

    public NutsDependencyFilter byOsDist(String ... osDists) {
        this.checkSession();
        if (osDists == null || osDists.length == 0) {
            return this.always();
        }
        return new NutsDependencyOsDistIdFilter(this.getSession()).add(Arrays.stream(osDists).map(x -> NutsId.of((String)x, (NutsSession)this.getSession())).collect(Collectors.toList()));
    }

    public NutsDependencyFilter byOsDist(Collection<String> osDists) {
        this.checkSession();
        if (osDists == null || osDists.isEmpty()) {
            return this.always();
        }
        return new NutsDependencyOsDistIdFilter(this.getSession()).add(osDists.stream().map(x -> NutsId.of((String)x, (NutsSession)this.getSession())).collect(Collectors.toList()));
    }

    public NutsDependencyFilter byPlatform(NutsPlatformFamily ... pf) {
        this.checkSession();
        if (pf == null || pf.length == 0) {
            return this.always();
        }
        return new NutsDependencyPlatformFamilyFilter(this.getSession()).add(Arrays.asList(pf));
    }

    public NutsDependencyFilter byPlatform(String ... pf) {
        this.checkSession();
        if (pf == null || pf.length == 0) {
            return this.always();
        }
        return new NutsDependencyPlatformIdFilter(this.getSession()).add(Arrays.stream(pf).map(x -> NutsId.of((String)x, (NutsSession)this.getSession())).collect(Collectors.toList()));
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

