/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;

public class NutsDependencyScopes {
    public static boolean isDefaultScope(String s1) {
        return NutsDependencyScope.parseLenient((String)s1, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API) == NutsDependencyScope.API;
    }

    public static boolean isCompileScope(String scope) {
        if (scope == null) {
            return true;
        }
        NutsDependencyScope r = NutsDependencyScope.parseLenient((String)scope, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API);
        return r != null && r.isCompile();
    }

    public static int getScopesPriority(String s1) {
        NutsDependencyScope r = NutsDependencyScope.parseLenient((String)s1, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API);
        if (r == null) {
            return -1;
        }
        switch (r) {
            case IMPLEMENTATION: {
                return 26;
            }
            case API: {
                return 25;
            }
            case RUNTIME: {
                return 24;
            }
            case PROVIDED: {
                return 23;
            }
            case SYSTEM: {
                return 22;
            }
            case OTHER: {
                return 21;
            }
            case TEST_IMPLEMENTATION: {
                return 16;
            }
            case TEST_API: {
                return 15;
            }
            case TEST_RUNTIME: {
                return 14;
            }
            case TEST_PROVIDED: {
                return 13;
            }
            case TEST_SYSTEM: {
                return 12;
            }
            case TEST_OTHER: {
                return 11;
            }
            case IMPORT: {
                return 1;
            }
        }
        return -1;
    }

    public static EnumSet<NutsDependencyScope> add(Collection<NutsDependencyScope> a, NutsDependencyScopePattern ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NutsDependencyScope> bb = NutsDependencyScopes.expand(b == null ? null : Arrays.asList(b));
        aa.addAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> add(Collection<NutsDependencyScope> a, NutsDependencyScope ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        List<Object> bb = b == null ? Collections.emptyList() : Arrays.asList(b);
        aa.addAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> removeScopes(Collection<NutsDependencyScope> a, Collection<NutsDependencyScope> b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        Collection<Object> bb = b == null ? Collections.emptyList() : b;
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> removeScopePatterns(Collection<NutsDependencyScope> a, Collection<NutsDependencyScopePattern> b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NutsDependencyScope> bb = NutsDependencyScopes.expand(b);
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> remove(Collection<NutsDependencyScope> a, NutsDependencyScopePattern ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NutsDependencyScope> bb = NutsDependencyScopes.expand(b == null ? null : Arrays.asList(b));
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> remove(Collection<NutsDependencyScope> a, NutsDependencyScope ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        Collection<Object> bb = b == null ? Collections.emptySet() : Arrays.asList(b);
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> expand(Collection<NutsDependencyScopePattern> other) {
        EnumSet<NutsDependencyScope> a = EnumSet.noneOf(NutsDependencyScope.class);
        if (other != null) {
            for (NutsDependencyScopePattern s : other) {
                if (s == null) continue;
                a.addAll(s.toScopes());
            }
        }
        return a;
    }
}

