/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyParser;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringMapParser;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsDependencyParser
implements NutsDependencyParser {
    public static final Pattern DEPENDENCY_NUTS_DESCRIPTOR_PATTERN = Pattern.compile("^(?<group>[a-zA-Z0-9_.${}-]+)(:(?<artifact>[a-zA-Z0-9_.${}-]+))?(#(?<version>[^?]+))?(\\?(?<face>.+))?$");
    private static final StringMapParser QPARSER = new StringMapParser("=", "&");
    private final NutsSession session;
    private boolean lenient = false;

    public DefaultNutsDependencyParser(NutsSession session) {
        this.session = session;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsDependencyParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public NutsDependency parse(String dependency) {
        if (dependency == null) {
            return null;
        }
        Matcher m = DEPENDENCY_NUTS_DESCRIPTOR_PATTERN.matcher(dependency);
        if (m.find()) {
            String group = m.group("group");
            String name = m.group("artifact");
            String version = m.group("version");
            String face = NutsUtilStrings.trim((String)m.group("face"));
            Map<String, String> queryMap = QPARSER.parseMap(face, this.session);
            if (name == null) {
                name = group;
                group = null;
            }
            return NutsDependencyBuilder.of((NutsSession)this.session).setGroupId(group).setArtifactId(name).setVersion(version).setProperties(queryMap).build();
        }
        if (!this.isLenient()) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid dependency format : %s", (Object[])new Object[]{dependency}));
        }
        return null;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

