/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.dependency.DefaultNutsDependency;
import net.thevpc.nuts.runtime.standalone.dependency.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.dependency.util.NutsDependencyUtils;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.xtra.expr.QueryStringParser;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsDependencyBuilder
implements NutsDependencyBuilder {
    private String repo;
    private String groupId;
    private String artifactId;
    private NutsVersion version;
    private String scope;
    private String optional;
    private String type;
    private NutsEnvConditionBuilder condition;
    private String classifier;
    private NutsId[] exclusions = new NutsId[0];
    private transient NutsSession session;
    private final transient QueryStringParser propertiesQuery = new QueryStringParser(true, (name, value) -> {
        if (name != null) {
            switch (name) {
                case "scope": {
                    this.setScope(value);
                    return true;
                }
                case "version": {
                    this.setVersion(value);
                    return true;
                }
                case "optional": {
                    this.setOptional(value);
                    return true;
                }
                case "classifier": {
                    this.setClassifier(value);
                    return true;
                }
                case "repo": {
                    this.setRepository(value);
                    return true;
                }
                case "exclusions": {
                    this.setExclusions(value);
                    return true;
                }
                case "os": {
                    this.condition.setOs(new String[]{value});
                    return true;
                }
                case "arch": {
                    this.condition.setArch(new String[]{value});
                    return true;
                }
                case "platform": {
                    this.condition.setPlatform(new String[]{value});
                    return true;
                }
                case "osdist": {
                    this.condition.setOsDist(new String[]{value});
                    return true;
                }
                case "desktop": {
                    this.condition.setDesktopEnvironment(new String[]{value});
                    return true;
                }
                case "type": {
                    this.setType(value);
                    return true;
                }
            }
        }
        return false;
    });

    public DefaultNutsDependencyBuilder() {
    }

    public DefaultNutsDependencyBuilder(NutsSession session) {
        this.session = session;
        this.condition = new DefaultNutsEnvConditionBuilder(session);
    }

    public NutsDependencyBuilder setId(NutsId id) {
        if (id == null) {
            this.setRepository(null);
            this.setGroupId(null);
            this.setArtifactId(null);
            this.setVersion((String)null);
        } else {
            this.setRepository(id.getRepository());
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.addProperties(id.getProperties());
        }
        return this;
    }

    public NutsDependencyBuilder setDependency(NutsDependencyBuilder value) {
        return this.set(value);
    }

    public NutsDependencyBuilder set(NutsDependencyBuilder value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.getCondition().setAll(value.getCondition());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDependencyBuilder set(NutsDependency value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.getCondition().setAll(value.getCondition());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDependencyBuilder setDependency(NutsDependency value) {
        return this.set(value);
    }

    public NutsDependencyBuilder clear() {
        this.setRepository(null);
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion((NutsVersion)null);
        this.setScope((String)null);
        this.setOptional(null);
        this.setExclusions((NutsId[])null);
        this.setClassifier(null);
        this.getCondition().clear();
        this.setType(null);
        this.setProperties((Map<String, String>)null);
        return this;
    }

    public boolean isOptional() {
        return this.optional != null && Boolean.parseBoolean(this.optional);
    }

    public String getType() {
        return this.type;
    }

    public NutsDependencyBuilder setType(String type) {
        this.type = NutsDependencyUtils.normalizeDependencyType(type);
        return this;
    }

    public String getOptional() {
        return this.optional;
    }

    public NutsDependencyBuilder setOptional(String optional) {
        String o = NutsUtilStrings.trimToNull((String)optional);
        if ("false".equals(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public NutsDependencyBuilder setScope(NutsDependencyScope scope) {
        this.scope = scope == null ? "" : scope.toString();
        return this;
    }

    public NutsDependencyBuilder setScope(String scope) {
        this.scope = NutsDependencyScope.parseLenient((String)scope, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.OTHER).id();
        return this;
    }

    public NutsId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NutsDependencyScopes.isDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NutsBlankable.isBlank((String)this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            m.put("classifier", this.classifier);
        }
        if (!NutsBlankable.isBlank((String)this.type)) {
            m.put("type", this.type);
        }
        if (this.exclusions.length > 0) {
            TreeSet<String> ex = new TreeSet<String>();
            for (NutsId exclusion : this.exclusions) {
                ex.add(exclusion.getShortName());
            }
            m.put("exclusions", String.join((CharSequence)",", ex));
        }
        return NutsIdBuilder.of((NutsSession)this.session).setRepository(this.getRepository()).setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setVersion(this.getVersion()).setCondition(this.getCondition()).setProperties(m).build();
    }

    public String getRepository() {
        return this.repo;
    }

    public NutsDependencyBuilder setRepository(String repository) {
        this.repo = NutsUtilStrings.trimToNull((String)repository);
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public NutsDependencyBuilder setGroupId(String groupId) {
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public NutsDependencyBuilder setArtifactId(String artifactId) {
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public NutsDependencyBuilder setClassifier(String classifier) {
        this.classifier = NutsUtilStrings.trimToNull((String)classifier);
        return this;
    }

    public String getFullName() {
        if (NutsBlankable.isBlank((String)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public NutsDependencyBuilder setVersion(NutsVersion version) {
        this.version = version == null ? NutsVersion.of((String)"", (NutsSession)this.session) : version;
        return this;
    }

    public NutsDependencyBuilder setVersion(String version) {
        this.version = NutsVersion.of((String)version, (NutsSession)this.session);
        return this;
    }

    public NutsId[] getExclusions() {
        return this.exclusions == null ? new NutsId[]{} : Arrays.copyOf(this.exclusions, this.exclusions.length);
    }

    public NutsDependencyBuilder setExclusions(NutsId[] exclusions) {
        if (exclusions != null) {
            exclusions = Arrays.copyOf(exclusions, exclusions.length);
        }
        this.exclusions = exclusions;
        return this;
    }

    public NutsDependency build() {
        return new DefaultNutsDependency(this.getRepository(), this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getVersion(), this.getScope(), this.getOptional(), this.getExclusions(), this.getCondition().build(), this.getType(), this.getPropertiesQuery(), this.session);
    }

    public NutsDependencyBuilder setProperty(String property, String value) {
        this.propertiesQuery.setProperty(property, value);
        return this;
    }

    public NutsDependencyBuilder addProperties(Map<String, String> queryMap) {
        this.propertiesQuery.addProperties(queryMap);
        return this;
    }

    public NutsDependencyBuilder addProperties(String propertiesQuery) {
        this.propertiesQuery.addProperties(propertiesQuery, this.session);
        return this;
    }

    public String getPropertiesQuery() {
        return this.propertiesQuery.getPropertiesQuery();
    }

    public Map<String, String> getProperties() {
        return this.propertiesQuery.getProperties();
    }

    public NutsDependencyBuilder setProperties(Map<String, String> queryMap) {
        this.propertiesQuery.setProperties(queryMap);
        return this;
    }

    public NutsDependencyBuilder setProperties(String propertiesQuery) {
        this.propertiesQuery.setProperties(propertiesQuery, this.session);
        return this;
    }

    public NutsEnvConditionBuilder getCondition() {
        return this.condition;
    }

    public NutsDependencyBuilder setCondition(NutsEnvCondition condition) {
        this.condition.setAll(condition);
        return this;
    }

    public NutsDependencyBuilder setCondition(NutsEnvConditionBuilder condition) {
        this.condition.setAll(condition);
        return this;
    }

    public NutsDependencyBuilder setExclusions(String exclusions) {
        if (exclusions == null) {
            exclusions = "";
        }
        ArrayList<NutsId> ids = new ArrayList<NutsId>();
        NutsIdParser parser = NutsIdParser.of((NutsSession)this.session);
        for (String s : exclusions.split("[;,]")) {
            NutsId ii = parser.parse(s.trim());
            if (ii == null) continue;
            ids.add(ii);
        }
        this.setExclusions(ids.toArray(new NutsId[0]));
        return this;
    }

    public String toString() {
        return this.build().toString();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

