/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyFormat;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.dependency.DefaultNutsDependencyBuilder;
import net.thevpc.nuts.runtime.standalone.dependency.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.QueryStringParser;

public class DefaultNutsDependency
implements NutsDependency {
    public static final long serialVersionUID = 1L;
    private final String repository;
    private final String groupId;
    private final String artifactId;
    private final NutsVersion version;
    private final String scope;
    private final String classifier;
    private final String optional;
    private final String type;
    private final NutsId[] exclusions;
    private final String properties;
    private final NutsEnvCondition condition;
    private final transient NutsSession session;

    public DefaultNutsDependency(String repository, String groupId, String artifactId, String classifier, NutsVersion version, String scope, String optional, NutsId[] exclusions, NutsEnvCondition condition, String type, Map<String, String> properties, NutsSession session) {
        this(repository, groupId, artifactId, classifier, version, scope, optional, exclusions, condition, type, QueryStringParser.formatSortedPropertiesQuery(properties, session), session);
    }

    public DefaultNutsDependency(String repository, String groupId, String artifactId, String classifier, NutsVersion version, String scope, String optional, NutsId[] exclusions, NutsEnvCondition condition, String type, String properties, NutsSession session) {
        this.repository = NutsUtilStrings.trimToNull((String)repository);
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? NutsVersion.of((String)"", (NutsSession)session) : version;
        this.classifier = NutsUtilStrings.trimToNull((String)classifier);
        this.scope = NutsDependencyScope.parseLenient((String)scope, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.OTHER).id();
        String o = NutsUtilStrings.trimToNull((String)optional);
        if ("false".equalsIgnoreCase(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        this.exclusions = exclusions == null ? new NutsId[]{} : Arrays.copyOf(exclusions, exclusions.length);
        for (NutsId exclusion : exclusions) {
            if (exclusion != null) continue;
            throw new NullPointerException();
        }
        this.condition = CoreFilterUtils.trimToBlank(condition, session);
        this.type = NutsUtilStrings.trimToNull((String)type);
        this.properties = QueryStringParser.formatSortedPropertiesQuery(properties, session);
        this.session = session;
    }

    public boolean isBlank() {
        return this.toId().isBlank();
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isOptional() {
        String o = this.getOptional();
        return o != null && Boolean.parseBoolean(o);
    }

    public String getOptional() {
        return this.optional;
    }

    public String getScope() {
        return this.scope;
    }

    public String getType() {
        return this.type;
    }

    public NutsId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NutsDependencyScopes.isDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NutsBlankable.isBlank((String)this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            m.put("classifier", this.classifier);
        }
        if (!NutsBlankable.isBlank((String)this.type)) {
            m.put("type", this.type);
        }
        if (!NutsBlankable.isBlank((String)this.repository)) {
            m.put("repo", this.repository);
        }
        if (this.exclusions.length > 0) {
            TreeSet<String> ex = new TreeSet<String>();
            for (NutsId exclusion : this.exclusions) {
                ex.add(exclusion.getShortName());
            }
            m.put("exclusions", String.join((CharSequence)",", ex));
        }
        NutsId ii = NutsIdBuilder.of((NutsSession)this.session).setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setVersion(this.getVersion()).setCondition(this.getCondition()).setProperties(m).build();
        String ss = ii.toString();
        return ii;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getSimpleName() {
        if (NutsBlankable.isBlank((String)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getLongName() {
        StringBuilder sb = new StringBuilder();
        if (!NutsBlankable.isBlank((String)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(NutsUtilStrings.trim((String)this.artifactId));
        NutsVersion v = this.getVersion();
        if (!v.isBlank()) {
            sb.append("#");
            sb.append(v);
        }
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            sb.append("?");
            sb.append("classifier=");
            sb.append(this.classifier);
        }
        return sb.toString();
    }

    public String getFullName() {
        return this.toString();
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NutsBlankable.isBlank((String)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(this.artifactId);
        if (!NutsBlankable.isBlank((String)this.version.getValue())) {
            sb.append("#").append(this.version);
        }
        HashMap<String, String> p = new HashMap<String, String>();
        if (!NutsBlankable.isBlank((String)this.repository)) {
            p.put("repo", this.repository);
        }
        if (!NutsBlankable.isBlank((String)this.scope) && !this.scope.equals(NutsDependencyScope.API.id())) {
            p.put("scope", this.scope);
        }
        if (!NutsBlankable.isBlank((String)this.optional) && !this.optional.equals("false")) {
            p.put("optional", this.optional);
        }
        if (!NutsBlankable.isBlank((String)this.type)) {
            p.put("type", this.type);
        }
        if (this.condition != null && !this.condition.isBlank()) {
            if (this.condition.getOs().length > 0) {
                p.put("os", String.join((CharSequence)",", this.condition.getOs()));
            }
            if (this.condition.getOsDist().length > 0) {
                p.put("osdist", String.join((CharSequence)",", this.condition.getOsDist()));
            }
            if (this.condition.getDesktopEnvironment().length > 0) {
                p.put("desktop", String.join((CharSequence)",", this.condition.getDesktopEnvironment()));
            }
            if (this.condition.getArch().length > 0) {
                p.put("arch", String.join((CharSequence)",", this.condition.getArch()));
            }
            if (this.condition.getPlatform().length > 0) {
                p.put("platform", String.join((CharSequence)",", this.condition.getPlatform()));
            }
            if (this.condition.getProfile().length > 0) {
                p.put("profile", String.join((CharSequence)",", this.condition.getProfile()));
            }
        }
        if (this.exclusions.length > 0) {
            p.put("exclusions", Arrays.stream(this.exclusions).map(NutsId::getShortName).collect(Collectors.joining(",")));
        }
        if (!p.isEmpty()) {
            sb.append("?");
            sb.append(QueryStringParser.formatPropertiesQuery(p));
        }
        return sb.toString();
    }

    public NutsId[] getExclusions() {
        return Arrays.copyOf(this.exclusions, this.exclusions.length);
    }

    public NutsDependencyBuilder builder() {
        return new DefaultNutsDependencyBuilder(this.session).set(this);
    }

    public String getPropertiesQuery() {
        return this.properties;
    }

    public Map<String, String> getProperties() {
        return QueryStringParser.parseMap(this.properties, this.session);
    }

    public NutsDependencyFormat formatter() {
        return NutsDependencyFormat.of((NutsSession)this.session).setValue((NutsDependency)this);
    }

    public NutsEnvCondition getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsDependency that = (DefaultNutsDependency)o;
        return Objects.equals(this.repository, that.repository) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.scope, that.scope) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.optional, that.optional) && Objects.equals(this.type, that.type) && Arrays.equals(this.exclusions, that.exclusions) && Objects.equals(this.properties, that.properties) && Objects.equals(this.condition, that.condition) && Objects.equals(this.session, that.session);
    }

    public int hashCode() {
        int result = Objects.hash(this.repository, this.groupId, this.artifactId, this.version, this.scope, this.classifier, this.optional, this.type, this.properties, this.condition, this.session);
        result = 31 * result + Arrays.hashCode(this.exclusions);
        return result;
    }
}

