/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.Arrays;
import java.util.function.Function;
import net.thevpc.nuts.NutsDependencies;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;

public class DefaultNutsDependencies
implements NutsDependencies {
    private String solver;
    private NutsId[] sourceIds;
    private NutsDependencyFilter filter;
    private NutsDependency[] immediateDependencies;
    private NutsDependency[] nonMergedDependencies;
    private NutsDependencyTreeNode[] nonMergedNodes;
    private NutsDependency[] mergedDependencies;
    private NutsDependencyTreeNode[] mergedNodes;
    private transient NutsSession session;
    private transient Function<NutsElements, NutsElement> descr;

    public DefaultNutsDependencies(String solver, NutsId[] ids, NutsDependencyFilter filter, NutsDependency[] immediateDependencies, NutsDependency[] nonMergedDependencies, NutsDependencyTreeNode[] nonMergedNodes, NutsDependency[] mergedDependencies, NutsDependencyTreeNode[] mergedNodes, Function<NutsElements, NutsElement> descr, NutsSession session) {
        this.sourceIds = ids;
        this.solver = solver;
        this.filter = filter;
        this.immediateDependencies = immediateDependencies;
        this.nonMergedDependencies = nonMergedDependencies;
        this.nonMergedNodes = nonMergedNodes;
        this.mergedNodes = mergedNodes;
        this.mergedDependencies = mergedDependencies;
        this.session = session;
        this.descr = descr;
    }

    public String solver() {
        return this.solver;
    }

    public NutsStream<NutsId> sourceIds() {
        return NutsStream.of((NutsIterator)NutsIterator.of(Arrays.asList(this.sourceIds).iterator(), this.descr), (NutsSession)this.session);
    }

    public NutsDependencyFilter filter() {
        return this.filter;
    }

    public NutsStream<NutsDependency> immediate() {
        return NutsStream.of((NutsIterator)NutsIterator.of(Arrays.asList(this.immediateDependencies).iterator(), this.descr), (NutsSession)this.session);
    }

    public NutsStream<NutsDependency> transitive() {
        return NutsStream.of((NutsIterator)NutsIterator.of(Arrays.asList(this.nonMergedDependencies).iterator(), this.descr), (NutsSession)this.session);
    }

    public NutsStream<NutsDependencyTreeNode> transitiveNodes() {
        return NutsStream.of((NutsIterator)NutsIterator.of(Arrays.asList(this.nonMergedNodes).iterator(), this.descr), (NutsSession)this.session);
    }

    public NutsStream<NutsDependency> transitiveWithSource() {
        return NutsStream.of((NutsIterator)NutsIterator.of(Arrays.asList(this.mergedDependencies).iterator(), this.descr), (NutsSession)this.session);
    }

    public NutsStream<NutsDependencyTreeNode> sourceNodes() {
        return NutsStream.of((NutsIterator)NutsIterator.of(Arrays.asList(this.mergedNodes).iterator(), this.descr), (NutsSession)this.session);
    }

    public NutsIterator<NutsDependency> iterator() {
        return this.transitive().iterator();
    }

    public NutsElement describe(NutsElements elems) {
        return this.descr.apply(elems);
    }
}

