/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.installstatus.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.definition.installstatus.filter.AbstractInstallStatusFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsInstallStatusFilterOr
extends AbstractInstallStatusFilter {
    private NutsInstallStatusFilter[] all;

    public NutsInstallStatusFilterOr(NutsSession session, NutsInstallStatusFilter ... all) {
        super(session, NutsFilterOp.OR);
        ArrayList<NutsInstallStatusFilter> valid = new ArrayList<NutsInstallStatusFilter>();
        if (all != null) {
            for (NutsInstallStatusFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NutsInstallStatusFilter[0]);
    }

    public boolean acceptInstallStatus(NutsInstallStatus id, NutsSession session) {
        if (this.all.length == 0) {
            return true;
        }
        for (NutsInstallStatusFilter filter : this.all) {
            if (!filter.acceptInstallStatus(id, session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NutsInstallStatusFilter simplify() {
        return CoreFilterUtils.simplifyFilterOr(this.getSession(), NutsInstallStatusFilter.class, this, (NutsFilter[])this.all);
    }

    public String toString() {
        return String.join((CharSequence)" Or ", Arrays.asList(this.all).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList()));
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.all;
    }
}

