/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.installstatus.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.definition.installstatus.filter.AbstractInstallStatusFilter;

public class NutsInstallStatusFilter2
extends AbstractInstallStatusFilter {
    private final int installed;
    private final int required;
    private final int obsolete;
    private final int defaultVersion;

    public NutsInstallStatusFilter2(NutsSession session, int installed, int required, int obsolete, int defaultVersion) {
        super(session, NutsFilterOp.CUSTOM);
        this.installed = installed;
        this.required = required;
        this.obsolete = obsolete;
        this.defaultVersion = defaultVersion;
    }

    public boolean isInstalled() {
        return this.installed == 1;
    }

    public boolean isRequired() {
        return this.required == 1;
    }

    public boolean isObsolete() {
        return this.obsolete == 1;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion == 1;
    }

    public boolean isNotInstalled() {
        return this.installed == -1;
    }

    public boolean isNotRequired() {
        return this.required == -1;
    }

    public boolean isNotObsolete() {
        return this.obsolete == -1;
    }

    public boolean isNotDefaultVersion() {
        return this.defaultVersion == -1;
    }

    public Boolean getInstalled() {
        return this.installed == 1 ? Boolean.TRUE : (this.installed == -1 ? Boolean.FALSE : null);
    }

    public Boolean getRequired() {
        return this.required == 1 ? Boolean.TRUE : (this.required == -1 ? Boolean.FALSE : null);
    }

    public Boolean getObsolete() {
        return this.obsolete == 1 ? Boolean.TRUE : (this.obsolete == -1 ? Boolean.FALSE : null);
    }

    public Boolean getDefaultVersion() {
        return this.defaultVersion == 1 ? Boolean.TRUE : (this.defaultVersion == -1 ? Boolean.FALSE : null);
    }

    public boolean acceptInstallStatus(NutsInstallStatus status, NutsSession session) {
        if (status == null) {
            return false;
        }
        Boolean i = this.getInstalled();
        if (i != null && i.booleanValue() != status.isInstalled()) {
            return false;
        }
        i = this.getRequired();
        if (i != null && i.booleanValue() != status.isRequired()) {
            return false;
        }
        i = this.getObsolete();
        if (i != null && i.booleanValue() != status.isObsolete()) {
            return false;
        }
        i = this.getDefaultVersion();
        return i == null || i.booleanValue() == status.isDefaultVersion();
    }

    @Override
    public NutsInstallStatusFilter simplify() {
        return this;
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return new NutsFilter[0];
    }

    public int hashCode() {
        return Objects.hash(this.installed, this.required, this.obsolete, this.defaultVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsInstallStatusFilter2 that = (NutsInstallStatusFilter2)o;
        return this.installed == that.installed && this.required == that.required && this.obsolete == that.obsolete && this.defaultVersion == that.defaultVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean addPars = false;
        if (this.installed > 0) {
            sb.append("installed");
        } else if (this.installed < 0) {
            sb.append("!installed");
        }
        if (this.required > 0) {
            if (sb.length() > 0) {
                sb.append("&");
                addPars = true;
            }
            sb.append("required");
        } else if (this.required < 0) {
            addPars = true;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("!required");
        }
        if (this.defaultVersion > 0) {
            if (sb.length() > 0) {
                addPars = true;
                sb.append("&");
            }
            sb.append("defaultVersion");
        } else if (this.defaultVersion < 0) {
            addPars = true;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("!defaultVersion");
        }
        if (this.obsolete > 0) {
            if (sb.length() > 0) {
                addPars = true;
                sb.append("&");
            }
            sb.append("obsolete");
        } else if (this.obsolete < 0) {
            addPars = true;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("!obsolete");
        }
        if (sb.length() == 0) {
            addPars = true;
            sb.append("!deployed");
        }
        if (addPars) {
            sb.insert(0, '(');
            sb.append(')');
        }
        return sb.toString();
    }
}

