/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsPath;

public class DefaultNutsInstallInfo
implements NutsInstallInformation {
    private NutsId id;
    private NutsInstallStatus installStatus;
    private boolean wasInstalled;
    private boolean wasRequired;
    private Instant lasModifiedDate;
    private Instant createdDate;
    private String installUser;
    private NutsPath installFolder;
    private String sourceRepositoryName;
    private String sourceRepositoryUUID;
    private boolean justInstalled;
    private boolean justRequired;

    public DefaultNutsInstallInfo(NutsId id, NutsInstallStatus installStatus, NutsPath installFolder, Instant createdDate, Instant lasModifiedDate, String installUser, String sourceRepositoryName, String sourceRepositoryUUID, boolean justInstalled, boolean justRequired) {
        this.id = id;
        this.installStatus = installStatus;
        this.installFolder = installFolder;
        this.createdDate = createdDate;
        this.lasModifiedDate = lasModifiedDate;
        this.installUser = installUser;
        this.sourceRepositoryName = sourceRepositoryName;
        this.sourceRepositoryUUID = sourceRepositoryUUID;
        this.justInstalled = justInstalled;
        this.justRequired = justRequired;
    }

    public DefaultNutsInstallInfo(NutsInstallInformation other) {
        this.id = other.getId();
        this.installStatus = other.getInstallStatus();
        this.installFolder = other.getInstallFolder();
        this.createdDate = other.getCreatedInstant();
        this.lasModifiedDate = other.getLastModifiedInstant();
        this.installUser = other.getInstallUser();
        this.sourceRepositoryName = other.getSourceRepositoryName();
        this.sourceRepositoryUUID = other.getSourceRepositoryUUID();
        this.justInstalled = other.isJustInstalled();
        this.justRequired = other.isJustRequired();
    }

    public static DefaultNutsInstallInfo notInstalled(NutsId id) {
        return new DefaultNutsInstallInfo(null, NutsInstallStatus.NONE, null, null, null, null, null, null, false, false);
    }

    public NutsId getId() {
        return this.id;
    }

    public Instant getCreatedInstant() {
        return this.createdDate;
    }

    public Instant getLastModifiedInstant() {
        return this.lasModifiedDate;
    }

    public boolean isDefaultVersion() {
        return this.getInstallStatus().isDefaultVersion();
    }

    public NutsPath getInstallFolder() {
        return this.installFolder;
    }

    public boolean isWasInstalled() {
        return this.wasInstalled;
    }

    public DefaultNutsInstallInfo setWasInstalled(boolean wasInstalled) {
        this.wasInstalled = wasInstalled;
        return this;
    }

    public boolean isWasRequired() {
        return this.wasRequired;
    }

    public String getInstallUser() {
        return this.installUser;
    }

    public NutsInstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public boolean isInstalledOrRequired() {
        return this.installStatus.isRequired() || this.installStatus.isInstalled();
    }

    public String getSourceRepositoryName() {
        return this.sourceRepositoryName;
    }

    public String getSourceRepositoryUUID() {
        return this.sourceRepositoryUUID;
    }

    public DefaultNutsInstallInfo setSourceRepositoryUUID(String sourceRepositoryUUID) {
        this.sourceRepositoryUUID = sourceRepositoryUUID;
        return this;
    }

    public DefaultNutsInstallInfo setSourceRepositoryName(String sourceRepositoryName) {
        this.sourceRepositoryName = sourceRepositoryName;
        return this;
    }

    public DefaultNutsInstallInfo setInstallStatus(NutsInstallStatus installStatus) {
        this.installStatus = installStatus;
        return this;
    }

    public DefaultNutsInstallInfo setInstallUser(String installUser) {
        this.installUser = installUser;
        return this;
    }

    public DefaultNutsInstallInfo setWasRequired(boolean wasRequired) {
        this.wasRequired = wasRequired;
        return this;
    }

    public DefaultNutsInstallInfo setInstallFolder(NutsPath installFolder) {
        this.installFolder = installFolder;
        return this;
    }

    public DefaultNutsInstallInfo setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public DefaultNutsInstallInfo setId(NutsId id) {
        this.id = id;
        return this;
    }

    public boolean isJustReInstalled() {
        return this.isWasInstalled() && this.isJustInstalled();
    }

    public boolean isJustInstalled() {
        return this.justInstalled;
    }

    public boolean isJustReRequired() {
        return this.isWasRequired() && this.isJustRequired();
    }

    public boolean isJustRequired() {
        return this.justRequired;
    }

    public DefaultNutsInstallInfo setLasModifiedDate(Instant lasModifiedDate) {
        this.lasModifiedDate = lasModifiedDate;
        return this;
    }

    public DefaultNutsInstallInfo setJustInstalled(boolean justInstalled) {
        this.justInstalled = justInstalled;
        return this;
    }

    public DefaultNutsInstallInfo setJustRequired(boolean justRequired) {
        this.justRequired = justRequired;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsInstallInfo that = (DefaultNutsInstallInfo)o;
        return this.wasInstalled == that.wasInstalled && this.wasRequired == that.wasRequired && this.justInstalled == that.justInstalled && this.justRequired == that.justRequired && Objects.equals(this.id, that.id) && Objects.equals(this.installStatus, that.installStatus) && Objects.equals(this.lasModifiedDate, that.lasModifiedDate) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.installUser, that.installUser) && Objects.equals(this.installFolder, that.installFolder) && Objects.equals(this.sourceRepositoryName, that.sourceRepositoryName) && Objects.equals(this.sourceRepositoryUUID, that.sourceRepositoryUUID);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.installStatus, this.wasInstalled, this.wasRequired, this.lasModifiedDate, this.createdDate, this.installUser, this.installFolder, this.sourceRepositoryName, this.sourceRepositoryUUID, this.justInstalled, this.justRequired);
    }
}

