/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceCurrentConfig;
import net.thevpc.nuts.spi.NutsBootDescriptor;

public final class NutsBootConfig
implements Cloneable,
Serializable {
    private String name;
    private String workspace;
    private String apiVersion;
    private String runtimeId;
    private NutsBootDescriptor runtimeBootDescriptor;
    private NutsBootDescriptor[] extensionBootDescriptors;
    private String bootRepositories;
    private String javaCommand;
    private String javaOptions;
    private NutsStoreLocationStrategy storeLocationStrategy;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy;
    private NutsOsFamily storeLocationLayout;
    private boolean global;
    private Map<NutsStoreLocation, String> storeLocations;
    private Map<NutsHomeLocation, String> homeLocations;

    public NutsBootConfig() {
    }

    public NutsBootConfig(NutsWorkspaceOptions options) {
        if (options != null) {
            this.setWorkspace(options.getWorkspace());
            this.setName(options.getName());
            this.setStoreLocationStrategy(options.getStoreLocationStrategy());
            this.setRepositoryStoreLocationStrategy(options.getRepositoryStoreLocationStrategy());
            this.setStoreLocationLayout(options.getStoreLocationLayout());
            this.storeLocations = new LinkedHashMap<NutsStoreLocation, String>(options.getStoreLocations());
            this.homeLocations = new LinkedHashMap<NutsHomeLocation, String>(options.getHomeLocations());
            this.setRuntimeId(options.getRuntimeId());
            this.global = options.isGlobal();
            this.runtimeId = options.getRuntimeId();
        }
    }

    public NutsBootConfig(DefaultNutsWorkspaceCurrentConfig context) {
        if (context != null) {
            this.name = context.getName();
            this.apiVersion = context.getApiVersion();
            this.runtimeId = context.getRuntimeId().getLongName();
            this.runtimeBootDescriptor = context.getRuntimeBootDescriptor();
            this.extensionBootDescriptors = context.getExtensionBootDescriptors();
            this.bootRepositories = context.getBootRepositories();
            this.javaCommand = context.getJavaCommand();
            this.javaOptions = context.getJavaOptions();
            this.storeLocations = new LinkedHashMap<NutsStoreLocation, String>(context.getStoreLocations());
            this.homeLocations = new LinkedHashMap<NutsHomeLocation, String>(context.getHomeLocations());
            this.storeLocationStrategy = context.getStoreLocationStrategy();
            this.repositoryStoreLocationStrategy = context.getRepositoryStoreLocationStrategy();
            this.storeLocationLayout = context.getStoreLocationLayout();
            this.global = context.isGlobal();
        }
    }

    public NutsBootConfig(NutsBootConfig other) {
        if (other != null) {
            this.name = other.getName();
            this.apiVersion = other.getApiVersion();
            this.runtimeId = other.getRuntimeId();
            this.runtimeBootDescriptor = other.getRuntimeBootDescriptor();
            this.extensionBootDescriptors = other.getExtensionBootDescriptors();
            this.bootRepositories = other.getBootRepositories();
            this.javaCommand = other.getJavaCommand();
            this.javaOptions = other.getJavaOptions();
            this.storeLocations = other.storeLocations == null ? null : new LinkedHashMap<NutsStoreLocation, String>(other.storeLocations);
            this.homeLocations = other.homeLocations == null ? null : new LinkedHashMap<NutsHomeLocation, String>(other.homeLocations);
            this.storeLocationStrategy = other.getStoreLocationStrategy();
            this.storeLocationLayout = other.getStoreLocationLayout();
            this.global = other.isGlobal();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getApiId() {
        return "net.thevpc.nuts:nuts#" + this.apiVersion;
    }

    public NutsBootConfig setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public NutsBootConfig setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public NutsBootDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public NutsBootConfig setRuntimeBootDescriptor(NutsBootDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public NutsBootDescriptor[] getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public NutsBootConfig setExtensionBootDescriptors(NutsBootDescriptor[] extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public NutsBootConfig setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public NutsBootConfig setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public NutsBootConfig setRepositories(String repositories) {
        this.bootRepositories = repositories;
        return this;
    }

    public NutsBootConfig copy() {
        try {
            NutsBootConfig p = (NutsBootConfig)this.clone();
            p.storeLocations = p.storeLocations == null ? null : new LinkedHashMap<NutsStoreLocation, String>(p.storeLocations);
            p.homeLocations = p.homeLocations == null ? null : new LinkedHashMap<NutsHomeLocation, String>(p.homeLocations);
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public NutsBootConfig setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public NutsBootConfig setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public void setStoreLocations(Map<NutsStoreLocation, String> storeLocations) {
        this.storeLocations = storeLocations;
    }

    public void setHomeLocations(Map<NutsHomeLocation, String> homeLocations) {
        this.homeLocations = homeLocations;
    }

    public NutsBootConfig setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public NutsBootConfig setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public Map<NutsStoreLocation, String> getStoreLocations() {
        return this.storeLocations;
    }

    public Map<NutsHomeLocation, String> getHomeLocations() {
        return this.homeLocations;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("NutsBootConfig{");
        if (!NutsBlankable.isBlank((String)this.apiVersion)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("apiVersion='").append(this.apiVersion).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.runtimeId)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("runtimeId='").append(this.runtimeId).append('\'');
        }
        if (this.runtimeBootDescriptor != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("runtimeDependencies=").append(this.runtimeBootDescriptor);
        }
        if (!NutsBlankable.isBlank((String)this.bootRepositories)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("repositories='").append(this.bootRepositories).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.javaCommand)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaCommand='").append(this.javaCommand).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.javaOptions)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaOptions='").append(this.javaOptions).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.workspace)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("workspace='").append(this.workspace).append('\'');
        }
        if (this.storeLocations != null && !this.storeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocations=").append(this.storeLocations);
        }
        if (this.homeLocations != null && !this.homeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("homeLocations=").append(this.homeLocations);
        }
        if (this.storeLocationStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocationStrategy=").append(this.storeLocationStrategy);
        }
        if (this.repositoryStoreLocationStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("repositoryStoreLocationStrategy=").append(this.repositoryStoreLocationStrategy);
        }
        if (this.storeLocationLayout != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocationLayout=").append(this.storeLocationLayout);
        }
        if (this.global) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("global");
        }
        sb.append('}');
        return sb.toString();
    }
}

