/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceExtensionManager;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.optional.jansi.OptionalJansi;
import net.thevpc.nuts.runtime.standalone.app.cmdline.DefaultNutsArgument;
import net.thevpc.nuts.runtime.standalone.boot.NutsBootModel;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamNull;
import net.thevpc.nuts.runtime.standalone.io.terminal.CoreAnsiTermHelper;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNutsSessionTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNutsSystemTerminalBase;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNutsSystemTerminalBaseBoot;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultSystemTerminal;
import net.thevpc.nuts.runtime.standalone.session.DefaultNutsSession;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsBootOptions;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceModel;
import net.thevpc.nuts.spi.NutsDefaultTerminalSpec;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsTerminalSpec;

public class DefaultNutsBootModel
implements NutsBootModel {
    public final NutsPrintStream nullOut;
    protected NutsWorkspace workspace;
    protected boolean firstBoot;
    protected boolean initializing;
    protected CoreNutsBootOptions bOptions;
    protected NutsSession bootSession;
    private Map<String, NutsArgument> customBootOptions;
    private NutsBootTerminal bootTerminal;
    private NutsLogger LOG;
    private NutsSystemTerminal systemTerminal;

    public DefaultNutsBootModel(NutsWorkspace workspace, NutsBootOptions bOption0) {
        this.workspace = workspace;
        this.initializing = true;
        NutsWorkspaceModel _model = NutsWorkspaceExt.of(workspace).getModel();
        this.bootSession = new DefaultNutsSession(workspace, bOption0);
        this.bOptions = new CoreNutsBootOptions(bOption0, workspace, this.bootSession);
        this.bootTerminal = DefaultNutsBootModel.detectAnsiTerminalSupport(NutsOsFamily.getCurrent(), this.bOptions.getOptions(), true, this.bootSession);
        _model.uuid = this.bOptions.getUuid();
        _model.name = Paths.get(this.bOptions.getWorkspaceLocation(), new String[0]).getFileName().toString();
        DefaultSystemTerminal sys = new DefaultSystemTerminal((NutsSystemTerminalBase)new DefaultNutsSystemTerminalBaseBoot(this));
        this.systemTerminal = this.NutsSystemTerminal_of_NutsSystemTerminalBase((NutsSystemTerminalBase)sys, this.bootSession);
        this.bootSession.setTerminal((NutsSessionTerminal)new DefaultNutsSessionTerminalFromSystem(this.bootSession, (NutsSystemTerminalBase)this.systemTerminal));
        this.nullOut = new NutsPrintStreamNull(this.bootSession);
    }

    public static NutsBootTerminal detectAnsiTerminalSupport(NutsOsFamily os, NutsWorkspaceOptions bOption, boolean boot, NutsSession session) {
        NutsBootTerminal t;
        ArrayList<String> flags = new ArrayList<String>();
        boolean tty = false;
        boolean customOut = false;
        boolean customErr = false;
        boolean customIn = false;
        if (!boot && CoreAnsiTermHelper.isXTerm(session)) {
            flags.add("tty");
            tty = true;
        }
        InputStream stdIn = System.in;
        PrintStream stdOut = System.out;
        PrintStream stdErr = System.err;
        if (bOption.getStdin() != null && bOption.getStdin() != System.in) {
            stdIn = bOption.getStdin();
            flags.add("customIn");
            customIn = true;
        }
        if (bOption.getStdout() != null && bOption.getStdout() != System.out) {
            stdOut = bOption.getStdout();
            flags.add("customOut");
            customOut = true;
        }
        if (bOption.getStderr() != null && bOption.getStderr() != System.err) {
            stdErr = bOption.getStderr();
            flags.add("customErr");
            customErr = true;
        }
        if (System.console() != null) {
            flags.add("console");
        }
        switch (os) {
            case LINUX: 
            case MACOS: 
            case UNIX: {
                flags.add(DefaultNutsBootModel.ansiFlag(tty, bOption));
                return new NutsBootTerminal(stdIn, stdOut, stdErr, flags.toArray(flags.toArray(new String[0])));
            }
            case WINDOWS: {
                NutsBootTerminal t2;
                if (CorePlatformUtils.IS_CYGWIN || CorePlatformUtils.IS_MINGW_XTERM) {
                    if (CorePlatformUtils.IS_CYGWIN) {
                        flags.add("cygwin");
                    }
                    if (CorePlatformUtils.IS_MINGW_XTERM) {
                        flags.add("mingw");
                    }
                    flags.add(DefaultNutsBootModel.ansiFlag(!customOut && !customErr, bOption));
                    return new NutsBootTerminal(stdIn, stdOut, stdErr, flags.toArray(new String[0]));
                }
                if (OptionalJansi.isAvailable() && (t2 = OptionalJansi.resolveStdFd(session, flags)) != null) {
                    return t2;
                }
                flags.add(DefaultNutsBootModel.ansiFlag(tty, bOption));
                return new NutsBootTerminal(stdIn, stdOut, stdErr, flags.toArray(new String[0]));
            }
        }
        if (OptionalJansi.isAvailable() && (t = OptionalJansi.resolveStdFd(session, flags)) != null) {
            return t;
        }
        flags.add(DefaultNutsBootModel.ansiFlag(tty, bOption));
        return new NutsBootTerminal(stdIn, stdOut, stdErr, flags.toArray(new String[0]));
    }

    private static String ansiFlag(boolean defaultValue, NutsWorkspaceOptions bOption) {
        if (bOption.getTerminalMode() != null) {
            switch (bOption.getTerminalMode()) {
                case FORMATTED: 
                case ANSI: {
                    return "ansi";
                }
                case FILTERED: {
                    return "raw";
                }
                case INHERITED: {
                    return defaultValue ? "ansi" : "raw";
                }
            }
        }
        return defaultValue ? "ansi" : "raw";
    }

    public void onInitializeWorkspace() {
        this.bootTerminal = DefaultNutsBootModel.detectAnsiTerminalSupport(NutsOsFamily.getCurrent(), this.bOptions.getOptions(), false, this.bootSession);
    }

    public void setSystemTerminal(NutsSystemTerminalBase terminal, NutsSession session) {
        if (terminal == null) {
            throw new NutsExtensionNotFoundException(session, NutsSystemTerminalBase.class, null);
        }
        NutsSystemTerminal syst = this.NutsSystemTerminal_of_NutsSystemTerminalBase(terminal, session);
        NutsSystemTerminal old = this.systemTerminal;
        this.systemTerminal = syst;
        if (old != this.systemTerminal) {
            DefaultNutsWorkspaceEvent event = null;
            if (session != null) {
                for (NutsWorkspaceListener workspaceListener : session.events().getWorkspaceListeners()) {
                    if (event == null) {
                        event = new DefaultNutsWorkspaceEvent(session, null, "systemTerminal", old, this.systemTerminal);
                    }
                    workspaceListener.onUpdateProperty(event);
                }
            }
        }
    }

    public NutsSystemTerminal createSystemTerminal(NutsTerminalSpec spec, NutsSession session) {
        NutsSystemTerminalBase termb = (NutsSystemTerminalBase)session.extensions().setSession(session).createSupported(NutsSystemTerminalBase.class, true, (Object)spec);
        return this.NutsSystemTerminal_of_NutsSystemTerminalBase(termb, session);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsBootModel.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public void enableRichTerm(NutsSession session) {
        NutsSystemTerminal st = this.getSystemTerminal();
        if (!st.isAutoCompleteSupported()) {
            NutsId extId = NutsId.of((String)("net.thevpc.nuts.ext:next-term#" + session.getWorkspace().getApiVersion()), (NutsSession)session);
            if (!session.config().isExcludedExtension(extId.toString(), session.boot().getBootOptions())) {
                NutsWorkspaceExtensionManager extensions = session.extensions();
                extensions.setSession(session).loadExtension(extId);
                NutsSystemTerminal systemTerminal = this.createSystemTerminal(new NutsDefaultTerminalSpec().setAutoComplete(Boolean.valueOf(true)), session);
                this.setSystemTerminal((NutsSystemTerminalBase)systemTerminal, session);
                if (this.getSystemTerminal().isAutoCompleteSupported()) {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"enable rich terminal", (Object[])new Object[0]));
                } else {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to enable rich terminal", (Object[])new Object[0]));
                }
            } else {
                this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"enableRichTerm discarded; next-term is excluded.", (Object[])new Object[0]));
            }
        }
    }

    private NutsSystemTerminal NutsSystemTerminal_of_NutsSystemTerminalBase(NutsSystemTerminalBase terminal, NutsSession session) {
        NutsSystemTerminal syst;
        if (terminal == null) {
            throw new NutsExtensionNotFoundException(session, NutsSystemTerminalBase.class, (Object)"SystemTerminalBase");
        }
        if (terminal instanceof NutsSystemTerminal) {
            syst = (NutsSystemTerminal)terminal;
        } else {
            try {
                syst = new DefaultSystemTerminal(terminal);
                NutsWorkspaceUtils.setSession(syst, session);
            }
            catch (Exception ex) {
                this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"unable to create system terminal : {0}", (Object[])new Object[]{ex}));
                DefaultNutsSystemTerminalBase b = new DefaultNutsSystemTerminalBase();
                NutsWorkspaceUtils.setSession((Object)b, session);
                syst = new DefaultSystemTerminal((NutsSystemTerminalBase)b);
                NutsWorkspaceUtils.setSession(syst, session);
            }
        }
        return syst;
    }

    public CoreNutsBootOptions getCoreBootOptions() {
        return this.bOptions;
    }

    public NutsWorkspaceOptions getBootOptions() {
        return this.bOptions.getOptions();
    }

    public NutsBootTerminal getBootTerminal() {
        return this.bootTerminal;
    }

    @Override
    public boolean isInitializing() {
        return this.initializing;
    }

    public DefaultNutsBootModel setInitializing(boolean initializing) {
        this.initializing = initializing;
        return this;
    }

    @Override
    public boolean isFirstBoot() {
        return this.firstBoot;
    }

    public DefaultNutsBootModel setFirstBoot(boolean firstBoot) {
        this.firstBoot = firstBoot;
        return this;
    }

    @Override
    public NutsPrintStream nullPrintStream() {
        return this.nullOut;
    }

    @Override
    public NutsSystemTerminal getSystemTerminal() {
        return this.systemTerminal;
    }

    public NutsSession bootSession() {
        return this.bootSession;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsSession getBootSession() {
        return this.bootSession;
    }

    public Map<String, NutsArgument> getCustomBootOptions() {
        if (this.customBootOptions == null) {
            this.customBootOptions = new LinkedHashMap<String, NutsArgument>();
            String[] properties = this.bOptions.getOptions().getCustomOptions();
            NutsElements elems = NutsElements.of((NutsSession)this.bootSession);
            if (properties != null) {
                for (String property : properties) {
                    DefaultNutsArgument a;
                    if (property == null || !(a = new DefaultNutsArgument(property, elems)).isActive()) continue;
                    String key = a.getKey().getString();
                    this.customBootOptions.put(key, a);
                }
            }
        }
        return this.customBootOptions;
    }
}

