/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.net.URL;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.boot.NutsBootModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;

public class DefaultNutsBootManager
implements NutsBootManager {
    private DefaultNutsBootModel model;
    private NutsSession session;

    public DefaultNutsBootManager(DefaultNutsBootModel model) {
        this.model = model;
    }

    public NutsBootModel getModel() {
        return this.model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsBootManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public boolean isFirstBoot() {
        return this.model.isFirstBoot();
    }

    public Boolean getBootCustomBoolArgument(Boolean undefinedValue, Boolean emptyValue, Boolean errValue, String ... names) {
        this.checkSession();
        for (String name : names) {
            NutsArgument q = this.model.getCustomBootOptions().get(name);
            if (q == null) continue;
            return q.getBooleanValue(emptyValue, errValue);
        }
        return undefinedValue;
    }

    public NutsArgument getBootCustomArgument(String ... names) {
        this.checkSession();
        for (String name : names) {
            NutsArgument q = this.model.getCustomBootOptions().get(name);
            if (q == null) continue;
            return q;
        }
        return null;
    }

    public NutsWorkspaceOptions getBootOptions() {
        this.checkSession();
        return this._configModel().getOptions(this.getSession());
    }

    public ClassLoader getBootClassLoader() {
        this.checkSession();
        return this._configModel().getBootClassLoader();
    }

    public URL[] getBootClassWorldURLs() {
        this.checkSession();
        return this._configModel().getBootClassWorldURLs();
    }

    public String getBootRepositories() {
        this.checkSession();
        return this._configModel().getBootRepositories();
    }

    public long getCreationStartTimeMillis() {
        this.checkSession();
        return this._configModel().getCreationStartTimeMillis();
    }

    public long getCreationFinishTimeMillis() {
        this.checkSession();
        return this._configModel().getCreationFinishTimeMillis();
    }

    public long getCreationTimeMillis() {
        this.checkSession();
        return this._configModel().getCreationTimeMillis();
    }

    public NutsClassLoaderNode getBootRuntimeClassLoaderNode() {
        return this.model.bOptions.getRuntimeBootDependencyNode();
    }

    public NutsClassLoaderNode[] getBootExtensionClassLoaderNode() {
        return this.model.bOptions.getExtensionBootDependencyNodes();
    }

    public NutsBootTerminal getBootTerminal() {
        return this.model.getBootTerminal();
    }

    private DefaultNutsWorkspaceConfigModel _configModel() {
        DefaultNutsWorkspaceConfigManager config = (DefaultNutsWorkspaceConfigManager)this.session.config();
        DefaultNutsWorkspaceConfigModel configModel = config.getModel();
        return configModel;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }
}

