/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.gui;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTexts;

public final class CoreNutsUtilGui {
    public static boolean isGraphicalDesktopEnvironment() {
        try {
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            try {
                GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (screenDevices == null || screenDevices.length == 0) {
                    return false;
                }
            }
            catch (HeadlessException e) {
                return false;
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String inputString(NutsMessage message, NutsMessage title, NutsSession session) {
        try {
            String line;
            NutsTexts text = NutsTexts.of((NutsSession)session);
            if (title == null) {
                title = NutsMessage.cstyle((String)"Nuts Package Manager - %s", (Object[])new Object[]{Nuts.getVersion()});
            }
            if ((line = JOptionPane.showInputDialog(null, text.toText((Object)message).filteredText(), text.toText((Object)title).filteredText(), 3)) == null) {
                line = "";
            }
            return line;
        }
        catch (UnsatisfiedLinkError e) {
            session.err().printf("[Graphical Environment Unsupported] %s%n", new Object[]{title});
            return session.getTerminal().readLine(message.toString(), new Object[0]);
        }
    }

    public static String inputPassword(NutsMessage message, NutsMessage title, NutsSession session) {
        if (title == null) {
            title = NutsMessage.cstyle((String)"Nuts Package Manager - %s", (Object[])new Object[]{Nuts.getVersion()});
        }
        if (message == null) {
            message = NutsMessage.plain((String)"");
        }
        NutsTexts text = NutsTexts.of((NutsSession)session);
        String messageString = text.toText((Object)message).filteredText();
        String titleString = text.toText((Object)title).filteredText();
        try {
            JPanel panel = new JPanel();
            JLabel label = new JLabel(messageString);
            JPasswordField pass = new JPasswordField(10);
            panel.add(label);
            panel.add(pass);
            Object[] options = new String[]{"OK", "Cancel"};
            int option = JOptionPane.showOptionDialog(null, panel, titleString, 0, -1, null, options, options[1]);
            if (option == 0) {
                return new String(pass.getPassword());
            }
            return "";
        }
        catch (UnsatisfiedLinkError e) {
            session.err().printf("[Graphical Environment Unsupported] %s%n", new Object[]{title});
            return session.getTerminal().readLine(message.toString(), new Object[0]);
        }
    }

    public static void showMessage(NutsMessage message, NutsMessage title, NutsSession session) {
        if (title == null) {
            title = NutsMessage.cstyle((String)"Nuts Package Manager - %s", (Object[])new Object[]{Nuts.getVersion()});
        }
        NutsTexts text = NutsTexts.of((NutsSession)session);
        String messageString = text.toText((Object)(message == null ? "" : message)).filteredText();
        String titleString = text.toText((Object)title).filteredText();
        try {
            JOptionPane.showMessageDialog(null, messageString, titleString, 3);
        }
        catch (UnsatisfiedLinkError e) {
            session.err().printf("[Graphical Environment Unsupported] %s%n", new Object[]{title});
        }
    }
}

