/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import java.util.ArrayList;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;

public class NutsCommandLineUtils {
    public static String escapeArguments(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(NutsCommandLineUtils.escapeArgument(arg));
        }
        return sb.toString();
    }

    public static String escapeArgument(String arg) {
        StringBuilder sb = new StringBuilder();
        if (arg != null) {
            block9: for (char c : arg.toCharArray()) {
                switch (c) {
                    case '\\': {
                        sb.append('\\');
                        continue block9;
                    }
                    case '\'': {
                        sb.append("\\'");
                        continue block9;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String[] parseCommandLine(String commandLineString, NutsSession session) {
        if (commandLineString == null) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block30: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case ' ': {
                            continue block30;
                        }
                        case '\'': {
                            status = 2;
                            continue block30;
                        }
                        case '\"': {
                            status = 3;
                            continue block30;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block30;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\'': {
                            throw new NutsParseException(session, NutsMessage.cstyle((String)"illegal char %s", (Object[])new Object[]{Character.valueOf(c)}));
                        }
                        case '\"': {
                            throw new NutsParseException(session, NutsMessage.cstyle((String)"illegal char %s", (Object[])new Object[]{Character.valueOf(c)}));
                        }
                        case '\\': {
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\\': {
                            i = NutsCommandLineUtils.readEscaped(charArray, i + 1, sb);
                            continue block30;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                throw new NutsParseException(session, NutsMessage.cstyle((String)"expected '", (Object[])new Object[0]));
            }
        }
        return args.toArray(new String[0]);
    }

    public static int readEscaped(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            default: {
                sb.append(c);
            }
        }
        return i;
    }
}

