/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLines;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.app.cmdline.DefaultNutsArgument;
import net.thevpc.nuts.runtime.standalone.app.cmdline.DefaultNutsCommandLine;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.ArchitectureNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.DefaultNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.ExtensionNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.FileNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.GroupNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.PackagingNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.PermissionNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.RepositoryNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.RepositoryTypeNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.UserNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.ValueNonOption;
import net.thevpc.nuts.runtime.standalone.shell.NutsShellHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsCommandLines
implements NutsCommandLines {
    private NutsWorkspace ws;
    private NutsSession session;
    private NutsShellFamily family = NutsShellFamily.getCurrent();

    public DefaultNutsCommandLines(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsCommandLines setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsShellFamily getShellFamily() {
        return this.family;
    }

    public NutsCommandLines setShellFamily(NutsShellFamily family) {
        this.family = family == null ? NutsShellFamily.getCurrent() : family;
        return this;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public NutsCommandLine parseCommandline(String line) {
        this.checkSession();
        return new DefaultNutsCommandLine(this.getSession(), this.parseCommandLineArr(line));
    }

    private String[] parseCommandLineArr(String line) {
        NutsShellFamily f = this.getShellFamily();
        if (f == null) {
            f = NutsShellFamily.getCurrent();
        }
        return NutsShellHelper.of(f).parseCommandLineArr(line, this.session);
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public NutsCommandLine createCommandline(String ... args) {
        this.checkSession();
        return new DefaultNutsCommandLine(this.getSession(), args);
    }

    public NutsCommandLine createCommandline(List<String> args) {
        this.checkSession();
        return new DefaultNutsCommandLine(this.getSession(), args, null);
    }

    public NutsArgument createArgument(String argument) {
        this.checkSession();
        return Factory.createArgument0(this.getSession(), argument, '=');
    }

    public NutsArgumentName createName(String type, String label) {
        this.checkSession();
        return Factory.createName0(this.getSession(), type, label);
    }

    public NutsArgumentName createName(String type) {
        this.checkSession();
        return this.createName(type, type);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public static class Factory {
        public static NutsArgument createArgument0(NutsSession ws, String argument, char eq) {
            return new DefaultNutsArgument(argument, eq, NutsElements.of((NutsSession)ws));
        }

        public static NutsArgumentName createName0(NutsSession session, String type, String label) {
            if (type == null) {
                type = "";
            }
            if (label == null) {
                label = type;
            }
            switch (type) {
                case "arch": {
                    return new ArchitectureNonOption(label);
                }
                case "packaging": {
                    return new PackagingNonOption(label);
                }
                case "extension": {
                    return new ExtensionNonOption(type, session);
                }
                case "file": {
                    return new FileNonOption(type);
                }
                case "boolean": {
                    return new ValueNonOption(type, "true", "false");
                }
                case "repository": {
                    return new RepositoryNonOption(label);
                }
                case "repository-type": {
                    return new RepositoryTypeNonOption(label);
                }
                case "right": {
                    return new PermissionNonOption(label, null, false);
                }
                case "user": {
                    return new UserNonOption(label);
                }
                case "group": {
                    return new GroupNonOption(label);
                }
            }
            return new DefaultNonOption(label);
        }
    }
}

