/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineFormat;
import net.thevpc.nuts.NutsCommandLineFormatStrategy;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NutsCommandLineShellOptions;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.shell.NutsShellHelper;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsCommandLineFormat
extends DefaultFormatBase<NutsCommandLineFormat>
implements NutsCommandLineFormat {
    private NutsCommandLine value;
    private NutsShellFamily formatFamily = NutsShellFamily.getCurrent();
    private NutsCommandLineFormatStrategy formatStrategy = NutsCommandLineFormatStrategy.DEFAULT;

    public DefaultNutsCommandLineFormat(NutsSession session) {
        super(session, "commandline");
    }

    @Override
    public NutsCommandLineFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    public NutsCommandLineFormat setValue(NutsCommandLine value) {
        this.value = value;
        return this;
    }

    public NutsCommandLineFormat setValue(String[] args) {
        this.checkSession();
        return this.setValue(args == null ? null : NutsCommandLine.of((String[])args, (NutsSession)this.getSession()));
    }

    public NutsCommandLineFormat setValue(String args) {
        return this.setValue(args == null ? null : NutsCommandLine.of((String)args, (NutsSession)this.getSession()));
    }

    public NutsShellFamily getShellFamily() {
        return this.formatFamily;
    }

    public NutsCommandLineFormat setShellFamily(NutsShellFamily family) {
        this.formatFamily = family == null ? NutsShellFamily.getCurrent() : family;
        return this;
    }

    public NutsCommandLineFormatStrategy getFormatStrategy() {
        return this.formatStrategy;
    }

    public void setFormatStrategy(NutsCommandLineFormatStrategy formatStrategy) {
        this.formatStrategy = formatStrategy == null ? NutsCommandLineFormatStrategy.DEFAULT : formatStrategy;
    }

    public NutsCommandLine getValue() {
        return this.value;
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        return false;
    }

    @Override
    public void print(NutsPrintStream out) {
        this.checkSession();
        if (this.value != null) {
            String cmd = NutsShellHelper.of(this.getShellFamily()).escapeArguments(this.value.toStringArray(), new NutsCommandLineShellOptions().setSession(this.getSession()).setFormatStrategy(this.getFormatStrategy()).setExpectEnv(true));
            if (this.isNtf()) {
                out.print("```system " + cmd + " ```");
            } else {
                out.print(cmd);
            }
        }
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

