/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsUtilStrings;

public class DefaultNutsArgument
implements NutsArgument {
    public static final Pattern PATTERN_OPTION_EQ = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z][a-zA-Z0-9_.-]*)?(?<opts>[=](?<optv>.*))?(?<optr>.*)$");
    public static final Pattern PATTERN_OPTION_COL = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z][a-zA-Z0-9_.-]*)?(?<opts>[:](?<optv>.*))?(?<optr>.*)$");
    private final char eq;
    private final String key;
    private final String value;
    private final String optionPrefix;
    private final String optionName;
    private final boolean enabled;
    private final boolean active;
    private final boolean option;
    private final String expression;
    private final transient NutsElements elems;

    public DefaultNutsArgument(String expression, NutsElements elems) {
        this(expression, '=', elems);
    }

    public DefaultNutsArgument(String expression, char eq, NutsElements elems) {
        Pattern currOptionsPattern;
        this.elems = elems;
        this.eq = (char)(eq == '\u0000' ? 61 : (int)eq);
        this.expression = expression;
        switch (this.eq) {
            case '=': {
                currOptionsPattern = PATTERN_OPTION_EQ;
                break;
            }
            case ':': {
                currOptionsPattern = PATTERN_OPTION_COL;
                break;
            }
            default: {
                currOptionsPattern = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z][a-zA-Z0-9_.-]*)?(?<opts>[" + eq + "](?<optv>.*))?(?<optr>.*)$");
            }
        }
        Matcher matcher = currOptionsPattern.matcher(expression == null ? "" : expression);
        if (matcher.find()) {
            String optp = matcher.group("optp");
            String cmt = matcher.group("cmt");
            String flg = matcher.group("flg");
            String optk = matcher.group("optk");
            String opts = matcher.group("opts");
            String optv = matcher.group("optv");
            String optr = matcher.group("optr");
            if (optp != null && optp.length() > 0) {
                this.option = true;
                this.active = cmt == null || cmt.length() <= 0;
                this.enabled = flg == null || flg.length() <= 0;
                this.optionPrefix = optp;
                if (optr != null && optr.length() > 0) {
                    this.optionName = (optk == null ? "" : optk) + optr;
                    this.key = optp + this.optionName;
                    this.value = null;
                } else {
                    String string = this.optionName = optk == null ? "" : optk;
                    if (opts != null && opts.length() > 0) {
                        this.key = optp + this.optionName;
                        this.value = optv + optr;
                    } else {
                        this.key = optp + this.optionName;
                        this.value = null;
                    }
                }
            } else {
                this.option = false;
                this.active = true;
                this.enabled = true;
                this.optionPrefix = null;
                this.optionName = null;
                if (opts != null && opts.length() > 0) {
                    this.key = expression == null ? null : (optk == null ? "" : optk);
                    this.value = optv;
                } else {
                    this.key = expression == null ? null : (optk == null ? "" : optk) + optr;
                    this.value = null;
                }
            }
        } else {
            this.active = true;
            this.enabled = true;
            this.option = false;
            this.optionName = null;
            this.key = null;
            this.value = null;
            this.optionPrefix = null;
        }
    }

    public boolean isOption() {
        return this.option;
    }

    public boolean isNonOption() {
        return !this.isOption();
    }

    public String getString() {
        return this.expression;
    }

    public String getStringValue() {
        return this.getStringValue(null);
    }

    public String getStringKey() {
        return this.getKey().getString();
    }

    public String getStringValue(String defValue) {
        NutsPrimitiveElement v = this.getValue();
        if (v != null) {
            return v.getString(defValue);
        }
        return defValue;
    }

    public boolean isNegated() {
        return !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInactive() {
        return !this.active;
    }

    public NutsArgument required() {
        if (this.expression == null) {
            throw new NoSuchElementException("missing value");
        }
        return this;
    }

    public boolean isKeyValue() {
        return this.value != null;
    }

    public NutsPrimitiveElement getOptionPrefix() {
        return this.elems.ofString(this.optionPrefix);
    }

    public String getSeparator() {
        return String.valueOf(this.eq);
    }

    public NutsPrimitiveElement getOptionName() {
        return this.elems.ofString(this.optionName);
    }

    public NutsPrimitiveElement getValue() {
        return this.elems.ofString(this.value);
    }

    public boolean getBooleanValue() {
        return this.getBooleanValue(true, false);
    }

    public Boolean getBooleanValue(Boolean emptyValue, Boolean errValue) {
        Boolean a = NutsUtilStrings.parseBoolean((String)this.value, (Boolean)emptyValue, (Boolean)errValue);
        return this.isNegated() != a.booleanValue();
    }

    public Boolean getBooleanValue(Boolean emptyOrValue) {
        return this.getBooleanValue(emptyOrValue, emptyOrValue);
    }

    public NutsPrimitiveElement getKey() {
        return this.elems.ofString(this.key == null ? this.expression : this.key);
    }

    public NutsPrimitiveElement toElement() {
        return this.elems.ofString(this.expression);
    }

    public String toString() {
        return String.valueOf(this.expression);
    }
}

