/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.boot.NutsApiUtils;
import net.thevpc.nuts.runtime.standalone.app.cmdline.DefaultNutsCommandLine;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;

public final class CoreNutsArgumentsParser {
    private CoreNutsArgumentsParser() {
    }

    public static void parseNutsArguments(NutsSession session, String[] bootArguments, NutsWorkspaceOptionsBuilder options) {
        ArrayList<NutsMessage> showError = new ArrayList<NutsMessage>();
        HashSet<String> excludedExtensions = new HashSet<String>();
        HashSet<String> repositories = new HashSet<String>();
        LinkedHashSet<String> customOptions = new LinkedHashSet<String>();
        ArrayList<String> executorOptions = new ArrayList<String>();
        NutsLogConfig logConfig = null;
        ArrayList<String> applicationArguments = new ArrayList<String>();
        NutsCommandLine cmdLine = new DefaultNutsCommandLine(session, bootArguments).setCommandName("nuts").setExpandSimpleOptions(true).registerSpecialSimpleOption("-version");
        boolean explicitConfirm = false;
        block345: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            if (a.isOption()) {
                String k;
                boolean active = a.isActive();
                block236 : switch (k = a.getKey().getString()) {
                    case "-w": 
                    case "--workspace": {
                        a = cmdLine.nextString(new String[0]);
                        String file = a.getValue().getString("");
                        if (!active) continue block345;
                        options.setWorkspace(file);
                        break;
                    }
                    case "--user": 
                    case "-u": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString("");
                        if (!active) continue block345;
                        options.setUsername(v);
                        break;
                    }
                    case "--password": 
                    case "-p": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString("");
                        if (!active) continue block345;
                        options.setCredentials(v.toCharArray());
                        break;
                    }
                    case "-V": 
                    case "--boot-version": 
                    case "--boot-api-version": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setApiVersion(v);
                        break;
                    }
                    case "--boot-runtime": {
                        a = cmdLine.nextString(new String[0]);
                        String br = a.getValue().getString("");
                        if (!active) continue block345;
                        if (br.indexOf("#") <= 0) {
                            br = "net.thevpc.nuts:nuts-runtime#" + br;
                        }
                        options.setRuntimeId(br);
                        break;
                    }
                    case "--java": 
                    case "--boot-java": 
                    case "-j": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString("");
                        if (!active) continue block345;
                        options.setJavaCommand(v);
                        break;
                    }
                    case "--java-home": 
                    case "--boot-java-home": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setJavaCommand(NutsJavaSdkUtils.of(session).resolveJavaCommandByHome(v, session));
                        break;
                    }
                    case "--java-options": 
                    case "--boot-java-options": 
                    case "-J": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString("");
                        if (!active) continue block345;
                        options.setJavaOptions(v);
                        break;
                    }
                    case "--name": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setName(v);
                        break;
                    }
                    case "--archetype": 
                    case "-A": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setArchetype(v);
                        break;
                    }
                    case "--store-strategy": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString("");
                        if (!active) continue block345;
                        options.setStoreLocationStrategy(CoreNutsArgumentsParser.parseNutsStoreLocationStrategy(v, session));
                        break;
                    }
                    case "-S": 
                    case "--standalone": 
                    case "--standalone-workspace": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationStrategy(NutsStoreLocationStrategy.STANDALONE);
                        break;
                    }
                    case "-E": 
                    case "--exploded": 
                    case "--exploded-workspace": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationStrategy(NutsStoreLocationStrategy.EXPLODED);
                        break;
                    }
                    case "--repo-store-strategy": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setRepositoryStoreLocationStrategy(CoreNutsArgumentsParser.parseNutsStoreLocationStrategy(v, session));
                        break;
                    }
                    case "--exploded-repositories": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy.EXPLODED);
                        break;
                    }
                    case "--standalone-repositories": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy.STANDALONE);
                        break;
                    }
                    case "--store-layout": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setStoreLocationLayout(CoreNutsArgumentsParser.parseNutsOsFamily(v, session));
                        break;
                    }
                    case "--system-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(null);
                        break;
                    }
                    case "--windows-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.WINDOWS);
                        break;
                    }
                    case "--macos-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.MACOS);
                        break;
                    }
                    case "--linux-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.LINUX);
                        break;
                    }
                    case "--unix-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.UNIX);
                        break;
                    }
                    case "--apps-location": 
                    case "--config-location": 
                    case "--var-location": 
                    case "--log-location": 
                    case "--temp-location": 
                    case "--cache-location": 
                    case "--lib-location": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        NutsStoreLocation m = NutsStoreLocation.valueOf((String)k.substring(2, k.indexOf(45, 2)).toUpperCase());
                        options.setStoreLocation(m, v);
                        break;
                    }
                    case "--system-apps-home": 
                    case "--system-config-home": 
                    case "--system-var-home": 
                    case "--system-log-home": 
                    case "--system-temp-home": 
                    case "--system-cache-home": 
                    case "--system-lib-home": 
                    case "--system-run-home": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        NutsStoreLocation folder = NutsStoreLocation.valueOf((String)k.substring(3 + "system".length(), k.indexOf(45, 3 + "system".length())).toUpperCase());
                        if (!active) continue block345;
                        options.setHomeLocation(NutsHomeLocation.of(null, (NutsStoreLocation)folder), v);
                        break;
                    }
                    case "--windows-apps-home": 
                    case "--windows-config-home": 
                    case "--windows-var-home": 
                    case "--windows-log-home": 
                    case "--windows-temp-home": 
                    case "--windows-cache-home": 
                    case "--windows-lib-home": 
                    case "--windows-run-home": 
                    case "--macos-apps-home": 
                    case "--macos-config-home": 
                    case "--macos-var-home": 
                    case "--macos-log-home": 
                    case "--macos-temp-home": 
                    case "--macos-cache-home": 
                    case "--macos-lib-home": 
                    case "--macos-run-home": 
                    case "--linux-apps-home": 
                    case "--linux-config-home": 
                    case "--linux-var-home": 
                    case "--linux-log-home": 
                    case "--linux-temp-home": 
                    case "--linux-cache-home": 
                    case "--linux-lib-home": 
                    case "--linux-run-home": 
                    case "--unix-apps-home": 
                    case "--unix-config-home": 
                    case "--unix-var-home": 
                    case "--unix-log-home": 
                    case "--unix-temp-home": 
                    case "--unix-cache-home": 
                    case "--unix-lib-home": 
                    case "--unix-run-home": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        NutsOsFamily layout = NutsOsFamily.valueOf((String)k.substring(2, k.indexOf(45, 2)).toUpperCase());
                        NutsStoreLocation folder = NutsStoreLocation.valueOf((String)k.substring(3 + layout.toString().length(), k.indexOf(45, 3 + layout.toString().length())).toUpperCase());
                        if (!active) continue block345;
                        options.setHomeLocation(NutsHomeLocation.of((NutsOsFamily)layout, (NutsStoreLocation)folder), v);
                        break;
                    }
                    case "--skip-companions": 
                    case "-k": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setSkipCompanions(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--skip-welcome": 
                    case "-K": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setSkipWelcome(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--skip-boot": 
                    case "-Q": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setSkipBoot(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--switch": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setSwitchWorkspace(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-g": 
                    case "--global": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setGlobal(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--gui": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setGui(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--color": 
                    case "-c": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        String v = a.getValue().getString("");
                        if (a.isNegated()) {
                            v = v.isEmpty() ? "false" : "" + (NutsUtilStrings.parseBoolean((String)v, (Boolean)true, (Boolean)true) == false);
                        }
                        if (v.isEmpty()) {
                            options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED);
                            break;
                        }
                        Boolean b = NutsUtilStrings.parseBoolean((String)v, null, null);
                        if (b != null) {
                            if (b.booleanValue()) {
                                options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED);
                                break;
                            }
                            options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FORMATTED : NutsTerminalMode.FILTERED);
                            break;
                        }
                        switch (v.toLowerCase()) {
                            case "formatted": {
                                options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED);
                                break block236;
                            }
                            case "filtered": {
                                options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FORMATTED : NutsTerminalMode.FILTERED);
                                break block236;
                            }
                            case "h": 
                            case "inherited": {
                                options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FORMATTED : NutsTerminalMode.INHERITED);
                                break block236;
                            }
                            case "a": 
                            case "ansi": {
                                options.setTerminalMode(a.isNegated() ? NutsTerminalMode.FORMATTED : NutsTerminalMode.ANSI);
                                break block236;
                            }
                            case "s": 
                            case "auto": 
                            case "system": {
                                options.setTerminalMode((NutsTerminalMode)(a.isNegated() ? NutsTerminalMode.FORMATTED : null));
                                break block236;
                            }
                        }
                        cmdLine.pushBack(a);
                        cmdLine.unexpectedArgument();
                        break;
                    }
                    case "-B": 
                    case "--bot": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setBot(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-R": 
                    case "--read-only": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setReadOnly(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-t": 
                    case "--trace": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setTrace(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-P": 
                    case "--progress": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        String s = a.getValue().getString();
                        if (a.isNegated()) {
                            Boolean q = NutsUtilStrings.parseBoolean((String)s, (Boolean)true, null);
                            if (q == null) {
                                s = NutsBlankable.isBlank((String)s) ? "false" : "false," + s;
                            }
                            options.setProgressOptions(s);
                            break;
                        }
                        options.setProgressOptions(s);
                        break;
                    }
                    case "--solver": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        String s = a.getValue().getString();
                        options.setDependencySolver(s);
                        break;
                    }
                    case "--dry": 
                    case "-D": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setDry(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--debug": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        if (NutsBlankable.isBlank((String)a.getValue().getString())) {
                            options.setDebug(String.valueOf(a.isEnabled()));
                            break;
                        }
                        if (a.isNegated()) {
                            options.setDebug(String.valueOf(NutsUtilStrings.parseBoolean((String)a.getValue().getString(), (Boolean)true, (Boolean)false) == false));
                            break;
                        }
                        options.setDebug(a.getValue().getString());
                        break;
                    }
                    case "--verbose": 
                    case "--log-verbose": 
                    case "--log-finest": 
                    case "--log-finer": 
                    case "--log-fine": 
                    case "--log-info": 
                    case "--log-warning": 
                    case "--log-severe": 
                    case "--log-config": 
                    case "--log-all": 
                    case "--log-off": 
                    case "--log-term-verbose": 
                    case "--log-term-finest": 
                    case "--log-term-finer": 
                    case "--log-term-fine": 
                    case "--log-term-info": 
                    case "--log-term-warning": 
                    case "--log-term-severe": 
                    case "--log-term-config": 
                    case "--log-term-all": 
                    case "--log-term-off": 
                    case "--log-file-verbose": 
                    case "--log-file-finest": 
                    case "--log-file-finer": 
                    case "--log-file-fine": 
                    case "--log-file-info": 
                    case "--log-file-warning": 
                    case "--log-file-severe": 
                    case "--log-file-config": 
                    case "--log-file-all": 
                    case "--log-file-off": 
                    case "--log-file-size": 
                    case "--log-file-name": 
                    case "--log-file-base": 
                    case "--log-file-count": {
                        if (active && logConfig == null) {
                            logConfig = new NutsLogConfig();
                        }
                        CoreNutsArgumentsParser.parseLogLevel(logConfig, cmdLine, active, session);
                        break;
                    }
                    case "-X": 
                    case "--exclude-extension": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        excludedExtensions.add(v);
                        break;
                    }
                    case "--repository": 
                    case "--repositories": 
                    case "--repo": 
                    case "--repos": 
                    case "-r": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        repositories.add(v);
                        break;
                    }
                    case "--output-format-option": 
                    case "-T": {
                        if (active) {
                            options.addOutputFormatOptions(new String[]{cmdLine.nextString(new String[0]).getValue().getString()});
                            break;
                        }
                        cmdLine.skip();
                        break;
                    }
                    case "-O": 
                    case "--output-format": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        String t = a.getValue().getString("");
                        int i = CoreStringUtils.firstIndexOf(t, new char[]{' ', ';', ':', '='});
                        if (i > 0) {
                            options.setOutputFormat(NutsContentType.valueOf((String)t.substring(0, i).toUpperCase()));
                            options.addOutputFormatOptions(new String[]{t.substring(i + 1).toUpperCase()});
                            break;
                        }
                        options.setOutputFormat(NutsContentType.valueOf((String)t.toUpperCase()));
                        options.addOutputFormatOptions(new String[]{""});
                        break;
                    }
                    case "--tson": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.TSON);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--yaml": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.YAML);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--json": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.JSON);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--plain": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.PLAIN);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--xml": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.XML);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--table": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.TABLE);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--tree": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.TREE);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--props": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        options.setOutputFormat(NutsContentType.PROPS);
                        options.addOutputFormatOptions(new String[]{a.getValue().getString("")});
                        break;
                    }
                    case "--yes": 
                    case "-y": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.YES);
                        break;
                    }
                    case "--no": 
                    case "-n": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.NO);
                        break;
                    }
                    case "--error": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.ERROR);
                        break;
                    }
                    case "--ask": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.ASK);
                        break;
                    }
                    case "--cached": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setCached(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--indexed": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setIndexed(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--transitive": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setTransitive(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-f": 
                    case "--fetch": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.valueOf((String)a.getValue().getString().toUpperCase().replace("-", "_")));
                        break;
                    }
                    case "-a": 
                    case "--anywhere": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.ANYWHERE);
                        break;
                    }
                    case "-F": 
                    case "--offline": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.OFFLINE);
                        break;
                    }
                    case "--online": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.ONLINE);
                        break;
                    }
                    case "--remote": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.REMOTE);
                        break;
                    }
                    case "--embedded": 
                    case "-b": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.EMBEDDED);
                        break;
                    }
                    case "--open-file": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.OPEN);
                        break;
                    }
                    case "--external": 
                    case "--spawn": 
                    case "-x": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.SPAWN);
                        break;
                    }
                    case "--user-cmd": 
                    case "--system": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.SYSTEM);
                        break;
                    }
                    case "--root-cmd": 
                    case "--as-root": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setRunAs(NutsRunAs.root());
                        break;
                    }
                    case "--current-user": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setRunAs(NutsRunAs.currentUser());
                        break;
                    }
                    case "--run-as": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        if (NutsBlankable.isBlank((String)a.getValue().getString())) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing user name", (Object[])new Object[0]));
                        }
                        options.setRunAs(NutsRunAs.user((String)a.getValue().getString()));
                        break;
                    }
                    case "-o": 
                    case "--open-mode": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getValue().getString();
                        if (!active) continue block345;
                        options.setOpenMode(CoreNutsArgumentsParser.parseNutsOpenMode(v, session));
                        break;
                    }
                    case "--open-or-error": 
                    case "--open": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.OPEN_OR_ERROR);
                        break;
                    }
                    case "--create-or-error": 
                    case "--create": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.CREATE_OR_ERROR);
                        break;
                    }
                    case "--open-or-create": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.OPEN_OR_CREATE);
                        break;
                    }
                    case "--open-or-null": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.OPEN_OR_NULL);
                        break;
                    }
                    case "-": {
                        cmdLine.skip();
                        if (active) {
                            if (!a.getValue().isNull()) {
                                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid argument for workspace: %s", (Object[])new Object[]{a.getString()}));
                            }
                            applicationArguments.add("net.thevpc.nuts.toolbox:nsh");
                            if (!cmdLine.isEmpty()) {
                                applicationArguments.add("-c");
                                applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
                            }
                            cmdLine.skipAll();
                            break;
                        }
                        applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
                        cmdLine.skipAll();
                        break;
                    }
                    case "-version": 
                    case "-v": 
                    case "--version": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setCommandVersion(Boolean.valueOf(a.isActive()));
                        break;
                    }
                    case "-Z": 
                    case "--reset": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (active) {
                            if (!a.getBooleanValue()) continue block345;
                            options.setReset(Boolean.valueOf(true));
                            options.setRecover(Boolean.valueOf(false));
                            break;
                        }
                        cmdLine.skipAll();
                        break;
                    }
                    case "-z": 
                    case "--recover": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setReset(Boolean.valueOf(false));
                        options.setRecover(Boolean.valueOf(true));
                        break;
                    }
                    case "-N": 
                    case "--expire": {
                        a = cmdLine.next();
                        if (!active) continue block345;
                        if (!NutsBlankable.isBlank((String)a.getValue().getString())) {
                            options.setExpireTime(Instant.parse(a.getValue().getString()));
                            break;
                        }
                        options.setExpireTime(Instant.now());
                        break;
                    }
                    case "--out-line-prefix": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        options.setOutLinePrefix(a.getValue().getString());
                        break;
                    }
                    case "--err-line-prefix": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        options.setErrLinePrefix(a.getValue().getString());
                        break;
                    }
                    case "--line-prefix": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        options.setOutLinePrefix(a.getValue().getString());
                        options.setErrLinePrefix(a.getValue().getString());
                        break;
                    }
                    case "-e": 
                    case "--exec": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (active && a.getBooleanValue()) {
                            while ((a = cmdLine.next()) != null) {
                                if (a.isOption()) {
                                    executorOptions.add(a.getString());
                                    continue;
                                }
                                applicationArguments.add(a.getString());
                                applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
                                cmdLine.skipAll();
                            }
                            continue block345;
                        }
                        cmdLine.skipAll();
                        break;
                    }
                    case "-?": 
                    case "--help": 
                    case "-h": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active || !a.getBooleanValue()) continue block345;
                        options.setCommandHelp(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--skip-errors": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!active) continue block345;
                        options.setSkipErrors(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-L": 
                    case "--locale": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        options.setLocale(a.getValue().getString());
                        break;
                    }
                    case "--theme": {
                        a = cmdLine.nextString(new String[0]);
                        if (!active) continue block345;
                        options.setTheme(a.getValue().getString());
                        break;
                    }
                    default: {
                        if (k.startsWith("---") && k.length() > 3 && k.charAt(3) != '-') {
                            a = cmdLine.next();
                            customOptions.add(a.toString());
                            break;
                        }
                        cmdLine.skip();
                        if (!a.isActive()) continue block345;
                        showError.add(NutsMessage.cstyle((String)"nuts: invalid option %s", (Object[])new Object[]{a.getString()}));
                    }
                }
                continue;
            }
            applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
            cmdLine.skipAll();
        }
        options.setCustomOptions(customOptions.toArray(new String[0]));
        options.setLogConfig(logConfig);
        options.setExcludedExtensions(excludedExtensions.toArray(new String[0]));
        options.setRepositories(repositories.toArray(new String[0]));
        options.setApplicationArguments(applicationArguments.toArray(new String[0]));
        options.setExecutorOptions(executorOptions.toArray(new String[0]));
        options.setErrors(showError.toArray(new NutsMessage[0]));
        if (!(applicationArguments.size() > 0 && (((String)applicationArguments.get(0)).equals("help") || options.isCommandHelp() || ((String)applicationArguments.get(0)).equals("version") || options.isCommandVersion()) || showError.isEmpty())) {
            NutsTextBuilder errorMessage = NutsTexts.of((NutsSession)session).builder();
            for (NutsMessage s : showError) {
                errorMessage.append((Object)s).append((Object)"\n");
            }
            errorMessage.append((Object)"Try 'nuts --help' for more information.");
            if (!options.isSkipErrors()) {
                throw new NutsIllegalArgumentException(session, NutsMessage.formatted((String)errorMessage.toString()));
            }
            session.err().println(errorMessage.toString());
        }
    }

    private static void parseLogLevel(NutsLogConfig logConfig, NutsCommandLine cmdLine, boolean enabled, NutsSession session) {
        NutsArgument a = cmdLine.peek();
        switch (a.getKey().getString()) {
            case "--log-file-size": {
                a = cmdLine.nextString(new String[0]);
                String v = a.getValue().getString();
                if (!enabled) break;
                Integer fileSize = NutsApiUtils.parseFileSizeInBytes((String)v, (Integer)0x100000, null, null);
                if (fileSize == null) {
                    if (NutsBlankable.isBlank((String)v)) {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid file size : %s", (Object[])new Object[]{v}));
                    }
                } else if ((fileSize = Integer.valueOf(fileSize / 0x100000)) <= 0) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid file size : %s < 1Mb", (Object[])new Object[]{v}));
                }
                if (fileSize == null) break;
                logConfig.setLogFileSize(fileSize.intValue());
                break;
            }
            case "--log-file-count": {
                a = cmdLine.nextString(new String[0]);
                if (!enabled) break;
                logConfig.setLogFileCount(a.getValue().getInt());
                break;
            }
            case "--log-file-name": {
                a = cmdLine.nextString(new String[0]);
                String v = a.getValue().getString();
                if (!enabled) break;
                logConfig.setLogFileName(v);
                break;
            }
            case "--log-file-base": {
                a = cmdLine.nextString(new String[0]);
                String v = a.getValue().getString();
                if (!enabled) break;
                logConfig.setLogFileBase(v);
                break;
            }
            case "--log-file-verbose": 
            case "--log-file-finest": 
            case "--log-file-finer": 
            case "--log-file-fine": 
            case "--log-file-info": 
            case "--log-file-warning": 
            case "--log-file-config": 
            case "--log-file-severe": 
            case "--log-file-all": 
            case "--log-file-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getKey().getString();
                logConfig.setLogFileLevel(CoreNutsArgumentsParser.parseLevel(id.substring("--log-file-".length()), session));
                break;
            }
            case "--log-term-verbose": 
            case "--log-term-finest": 
            case "--log-term-finer": 
            case "--log-term-fine": 
            case "--log-term-info": 
            case "--log-term-warning": 
            case "--log-term-config": 
            case "--log-term-severe": 
            case "--log-term-all": 
            case "--log-term-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getKey().getString();
                logConfig.setLogTermLevel(CoreNutsArgumentsParser.parseLevel(id.substring("--log-term-".length()), session));
                break;
            }
            case "--verbose": {
                cmdLine.skip();
                if (!enabled || !a.getBooleanValue()) break;
                logConfig.setLogTermLevel(Level.FINEST);
                logConfig.setLogFileLevel(Level.FINEST);
                break;
            }
            case "--log-verbose": 
            case "--log-finest": 
            case "--log-finer": 
            case "--log-fine": 
            case "--log-info": 
            case "--log-warning": 
            case "--log-config": 
            case "--log-severe": 
            case "--log-all": 
            case "--log-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getKey().getString();
                Level lvl = CoreNutsArgumentsParser.parseLevel(id.substring("--log-".length()), session);
                logConfig.setLogTermLevel(lvl);
                logConfig.setLogFileLevel(lvl);
            }
        }
    }

    private static NutsStoreLocationStrategy parseNutsStoreLocationStrategy(String s, NutsSession session) {
        NutsStoreLocationStrategy m = NutsStoreLocationStrategy.parseLenient((String)s, null, null);
        if (m == null && !NutsBlankable.isBlank((String)s)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to parse value for NutsStoreLocationStrategy : %s", (Object[])new Object[]{s}));
        }
        return m;
    }

    private static NutsOsFamily parseNutsOsFamily(String s, NutsSession session) {
        NutsOsFamily m = NutsOsFamily.parseLenient((String)s, null, null);
        if (m == null && !NutsBlankable.isBlank((String)s)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to parse value for NutsStoreLocationLayout : %s", (Object[])new Object[]{s}));
        }
        return m;
    }

    private static NutsOpenMode parseNutsOpenMode(String s, NutsSession session) {
        NutsOpenMode m = NutsOpenMode.parseLenient((String)s, null, null);
        if (m == null && !NutsBlankable.isBlank((String)s)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to parse value for NutsOpenMode : %s", (Object[])new Object[]{s}));
        }
        return m;
    }

    public static Level parseLevel(String s, NutsSession session) {
        Level m = NutsApiUtils.parseLenientLogLevel((String)s, null, null);
        if (m == null && !NutsBlankable.isBlank((String)s)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to parse value for Level : %s", (Object[])new Object[]{s}));
        }
        return m;
    }
}

