/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsAppCmdProcessor;
import net.thevpc.nuts.NutsAppStoreLocationResolver;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsApplicationMode;
import net.thevpc.nuts.NutsApplications;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsCommandAutoCompleteBase;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.standalone.app.cmdline.DefaultNutsCommandLine;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NutsCommandLineUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public class DefaultNutsApplicationContext
implements NutsApplicationContext {
    private final Class appClass;
    private final NutsPath[] folders = new NutsPath[NutsStoreLocation.values().length];
    private final NutsPath[] sharedFolders = new NutsPath[NutsStoreLocation.values().length];
    private final NutsCommandAutoComplete autoComplete;
    private NutsWorkspace workspace;
    private NutsSession session;
    private NutsId appId;
    private long startTimeMillis;
    private String[] args;
    private NutsApplicationMode mode = NutsApplicationMode.RUN;
    private NutsAppStoreLocationResolver storeLocationResolver;
    private NutsVersion appPreviousVersion;
    private String[] modeArgs = new String[0];

    public DefaultNutsApplicationContext(NutsWorkspace workspace, NutsSession session, String[] args, Class appClass, String storeId, long startTimeMillis) {
        NutsId _appId;
        long l = this.startTimeMillis = startTimeMillis <= 0L ? System.currentTimeMillis() : startTimeMillis;
        if (workspace == null && session == null) {
            throw new IllegalArgumentException("missing workpace and/or session");
        }
        if (workspace != null) {
            if (session == null) {
                this.session = workspace.createSession();
            } else {
                NutsWorkspaceUtils.checkSession(workspace, session);
                this.session = session.copy();
            }
            this.workspace = this.session.getWorkspace();
        } else {
            this.session = session;
            this.workspace = session.getWorkspace();
        }
        session = this.session;
        int wordIndex = -1;
        if (args.length > 0 && args[0].startsWith("--nuts-exec-mode=")) {
            NutsCommandLine execModeCommand = NutsCommandLine.of((String)args[0].substring(args[0].indexOf(61) + 1), (NutsSession)session);
            if (execModeCommand.hasNext()) {
                NutsArgument a = execModeCommand.next();
                switch (a.getKey().getString()) {
                    case "auto-complete": {
                        this.mode = NutsApplicationMode.AUTO_COMPLETE;
                        if (execModeCommand.hasNext()) {
                            wordIndex = execModeCommand.next().toElement().getInt();
                        }
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    case "install": {
                        this.mode = NutsApplicationMode.INSTALL;
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    case "uninstall": {
                        this.mode = NutsApplicationMode.UNINSTALL;
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    case "update": {
                        this.mode = NutsApplicationMode.UPDATE;
                        if (execModeCommand.hasNext()) {
                            this.appPreviousVersion = NutsVersion.of((String)execModeCommand.next().getString(), (NutsSession)session);
                        }
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    default: {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"Unsupported nuts-exec-mode : %s", (Object[])new Object[]{args[0]}), 205);
                    }
                }
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if ((_appId = (NutsId)NutsApplications.getSharedMap().get("nuts.embedded.application.id")) == null) {
            _appId = NutsIdResolver.of((NutsSession)session).resolveId(appClass);
        }
        if (_appId == null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid Nuts Application (%s). Id cannot be resolved", (Object[])new Object[]{appClass.getName()}), 203);
        }
        this.args = args;
        this.appId = _appId;
        this.appClass = appClass;
        this.session.setAppId(this.appId);
        NutsWorkspaceLocationManager locations = session.locations();
        for (NutsStoreLocation folder : NutsStoreLocation.values()) {
            this.setFolder(folder, locations.getStoreLocation(this.appId, folder));
            this.setSharedFolder(folder, locations.getStoreLocation(this.appId.builder().setVersion("SHARED").build(), folder));
        }
        if (this.mode == NutsApplicationMode.AUTO_COMPLETE) {
            if (wordIndex < 0) {
                wordIndex = args.length;
            }
            this.autoComplete = new AppCommandAutoComplete(this.session, args, wordIndex, this.getSession().out());
        } else {
            this.autoComplete = null;
        }
    }

    public NutsApplicationMode getMode() {
        return this.mode;
    }

    public String[] getModeArguments() {
        return this.modeArgs;
    }

    public NutsCommandAutoComplete getAutoComplete() {
        return this.autoComplete;
    }

    public final NutsApplicationContext configure(boolean skipUnsupported, String ... args) {
        NutsId appId = this.getAppId();
        String appName = appId == null ? "app" : appId.getArtifactId();
        return (NutsApplicationContext)NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, args, appName);
    }

    public void configureLast(NutsCommandLine commandLine) {
        if (!this.configureFirst(commandLine)) {
            commandLine.unexpectedArgument();
        }
    }

    public void printHelp() {
        String h = NutsWorkspaceExt.of(this.getWorkspace()).resolveDefaultHelp(this.getAppClass(), this.session);
        if (h == null) {
            h = "Help is ```error missing```.";
        }
        this.getSession().out().println(h);
        this.getSession().out().flush();
    }

    public Class getAppClass() {
        return this.appClass;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsSession createSession() {
        return this.getSession().getWorkspace().createSession();
    }

    public NutsApplicationContext setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.workspace, session);
        return this;
    }

    public NutsPath getAppsFolder() {
        return this.getFolder(NutsStoreLocation.APPS);
    }

    public NutsPath getConfigFolder() {
        return this.getFolder(NutsStoreLocation.CONFIG);
    }

    public NutsPath getLogFolder() {
        return this.getFolder(NutsStoreLocation.LOG);
    }

    public NutsPath getTempFolder() {
        return this.getFolder(NutsStoreLocation.TEMP);
    }

    public NutsPath getVarFolder() {
        return this.getFolder(NutsStoreLocation.VAR);
    }

    public NutsPath getLibFolder() {
        return this.getFolder(NutsStoreLocation.LIB);
    }

    public NutsPath getRunFolder() {
        return this.getFolder(NutsStoreLocation.RUN);
    }

    public NutsPath getCacheFolder() {
        return this.getFolder(NutsStoreLocation.CACHE);
    }

    public NutsPath getVersionFolder(NutsStoreLocation location, String version) {
        NutsPath r;
        if (version == null || version.isEmpty() || version.equalsIgnoreCase("current") || version.equals(this.getAppId().getVersion().getValue())) {
            return this.getFolder(location);
        }
        NutsId newId = this.getAppId().builder().setVersion(version).build();
        if (this.storeLocationResolver != null && (r = this.storeLocationResolver.getStoreLocation(newId, location)) != null) {
            return r;
        }
        return this.session.locations().getStoreLocation(newId, location);
    }

    public NutsPath getSharedAppsFolder() {
        return this.getSharedFolder(NutsStoreLocation.APPS);
    }

    public NutsPath getSharedConfigFolder() {
        return this.getSharedFolder(NutsStoreLocation.CONFIG);
    }

    public NutsPath getSharedLogFolder() {
        return this.getSharedFolder(NutsStoreLocation.LOG);
    }

    public NutsPath getSharedTempFolder() {
        return this.getSharedFolder(NutsStoreLocation.TEMP);
    }

    public NutsPath getSharedVarFolder() {
        return this.getSharedFolder(NutsStoreLocation.VAR);
    }

    public NutsPath getSharedLibFolder() {
        return this.getSharedFolder(NutsStoreLocation.LIB);
    }

    public NutsPath getSharedRunFolder() {
        return this.getSharedFolder(NutsStoreLocation.RUN);
    }

    public NutsPath getSharedFolder(NutsStoreLocation location) {
        return this.sharedFolders[location.ordinal()];
    }

    public NutsId getAppId() {
        return this.appId;
    }

    public NutsVersion getAppVersion() {
        return this.appId == null ? null : this.appId.getVersion();
    }

    public String[] getArguments() {
        return this.args;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public NutsVersion getAppPreviousVersion() {
        return this.appPreviousVersion;
    }

    public NutsCommandLine getCommandLine() {
        return NutsCommandLine.of((String[])this.getArguments(), (NutsSession)this.getSession()).setCommandName(this.getAppId().getArtifactId()).setAutoComplete(this.getAutoComplete());
    }

    public void processCommandLine(NutsAppCmdProcessor commandLineProcessor) {
        NutsCommandLine cmd = this.getCommandLine();
        commandLineProcessor.onCmdInitParsing(cmd, (NutsApplicationContext)this);
        while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            boolean consumed = a.isOption() ? commandLineProcessor.onCmdNextOption(a, cmd, (NutsApplicationContext)this) : commandLineProcessor.onCmdNextNonOption(a, cmd, (NutsApplicationContext)this);
            if (consumed) {
                NutsArgument next = cmd.peek();
                if (next != a) continue;
                throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"%s must consume the option: %s", (Object[])new Object[]{a.isOption() ? "nextOption" : "nextNonOption", a}));
            }
            if (this.configureFirst(cmd)) continue;
            cmd.unexpectedArgument();
        }
        commandLineProcessor.onCmdFinishParsing(cmd, (NutsApplicationContext)this);
        if (this.isExecMode()) {
            commandLineProcessor.onCmdExec(cmd, (NutsApplicationContext)this);
        } else if (this.getAutoComplete() != null) {
            commandLineProcessor.onCmdAutoComplete(this.getAutoComplete(), (NutsApplicationContext)this);
        }
    }

    public NutsPath getFolder(NutsStoreLocation location) {
        return this.folders[location.ordinal()];
    }

    public boolean isExecMode() {
        return this.getAutoComplete() == null;
    }

    public NutsAppStoreLocationResolver getStoreLocationResolver() {
        return this.storeLocationResolver;
    }

    public NutsApplicationContext setAppVersionStoreLocationSupplier(NutsAppStoreLocationResolver appVersionStoreLocationSupplier) {
        this.storeLocationResolver = appVersionStoreLocationSupplier;
        return this;
    }

    public NutsApplicationContext setMode(NutsApplicationMode mode) {
        this.mode = mode;
        return this;
    }

    public NutsApplicationContext setModeArgs(String[] modeArgs) {
        this.modeArgs = modeArgs;
        return this;
    }

    public final boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, commandLine);
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "-?": 
            case "-h": 
            case "--help": {
                cmd.skip();
                if (!enabled) break;
                if (cmd.isExecMode()) {
                    this.printHelp();
                }
                cmd.skipAll();
                throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"help", (Object[])new Object[0]), 0);
            }
            case "--skip-event": {
                switch (this.getMode()) {
                    case INSTALL: 
                    case UNINSTALL: 
                    case UPDATE: {
                        if (!enabled) break;
                        cmd.skip();
                        throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"skip-event", (Object[])new Object[0]), 0);
                    }
                }
                return true;
            }
            case "--version": {
                cmd.skip();
                if (enabled) {
                    if (cmd.isExecMode()) {
                        this.getSession().out().printf("%s%n", new Object[]{NutsIdResolver.of((NutsSession)this.session).resolveId(this.getClass()).getVersion().toString()});
                        cmd.skipAll();
                    }
                    throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"version", (Object[])new Object[0]), 0);
                }
                return true;
            }
            default: {
                if (this.getSession() == null || !this.getSession().configureFirst(cmd)) break;
                return true;
            }
        }
        return false;
    }

    public NutsApplicationContext setWorkspace(NutsWorkspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public NutsApplicationContext setFolder(NutsStoreLocation location, NutsPath folder) {
        this.folders[location.ordinal()] = folder;
        return this;
    }

    public NutsApplicationContext setSharedFolder(NutsStoreLocation location, NutsPath folder) {
        this.sharedFolders[location.ordinal()] = folder;
        return this;
    }

    public NutsApplicationContext setAppId(NutsId appId) {
        this.appId = appId;
        return this;
    }

    public NutsApplicationContext setArguments(String[] args) {
        this.args = args;
        return this;
    }

    public NutsApplicationContext setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
        return this;
    }

    public NutsApplicationContext setAppPreviousVersion(NutsVersion previousVersion) {
        this.appPreviousVersion = previousVersion;
        return this;
    }

    private static class AppCommandAutoComplete
    extends NutsCommandAutoCompleteBase {
        private final ArrayList<String> words;
        private final NutsPrintStream out0;
        private final NutsSession session;
        private final int wordIndex;

        public AppCommandAutoComplete(NutsSession session, String[] args, int wordIndex, NutsPrintStream out0) {
            this.session = session;
            this.words = new ArrayList<String>(Arrays.asList(args));
            this.wordIndex = wordIndex;
            this.out0 = out0;
        }

        public NutsSession getSession() {
            return this.session;
        }

        public String getLine() {
            return new DefaultNutsCommandLine(this.getSession()).setArguments(this.getWords()).toString();
        }

        public List<String> getWords() {
            return this.words;
        }

        public int getCurrentWordIndex() {
            return this.wordIndex;
        }

        protected NutsArgumentCandidate addCandidatesImpl(NutsArgumentCandidate value) {
            NutsArgumentCandidate c = super.addCandidatesImpl(value);
            String v = value.getValue();
            if (v == null) {
                throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"candidate cannot be null", (Object[])new Object[0]), 2);
            }
            String d = value.getDisplay();
            if (Objects.equals(v, d) || d == null) {
                this.out0.printf("%s%n", new Object[]{"```error Candidate```: " + NutsCommandLineUtils.escapeArgument(v)});
            } else {
                this.out0.printf("%s%n", new Object[]{"```error Candidate```: " + NutsCommandLineUtils.escapeArgument(v) + " " + NutsCommandLineUtils.escapeArgument(d)});
            }
            return c;
        }
    }
}

