/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.remote;

import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.standalone.workspace.AbstractNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.xtra.ntalk.NTalkClient;

public abstract class RemoteNutsWorkspace
extends AbstractNutsWorkspace {
    public NutsElement createCall(String commandName, NutsElement body, NutsSession session) {
        Throwable throwable = null;
        try (NTalkClient cli = new NTalkClient();){
            NutsElements e = NutsElements.of((NutsSession)session).json();
            NutsObjectElement q = e.ofObject().set("cmd", commandName).set("body", body).build();
            NutsString json = e.setValue((Object)q).format();
            String wsURL = session.boot().getBootOptions().getWorkspace();
            byte[] result = cli.request("nuts/ws:" + wsURL, json.toString().getBytes());
            NutsObjectElement resultObject = (NutsObjectElement)e.parse(result, NutsObjectElement.class);
            NutsElements prv = NutsElements.of((NutsSession)session);
            boolean success = resultObject.get((NutsElement)prv.ofString("success")).asPrimitive().getBoolean();
            if (success) {
                NutsElement nutsElement = resultObject.get((NutsElement)prv.ofString("body"));
                return nutsElement;
            }
            try {
                throw new NutsException(session, NutsMessage.cstyle((String)"unable to call %s", (Object[])new Object[]{NutsTexts.of((NutsSession)session).ofStyled(commandName, NutsTextStyle.primary1())}));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public NutsElement createCall(String commandName, String callId, NutsElement body, NutsSession session) {
        NutsElements e = NutsElements.of((NutsSession)session);
        return e.ofObject().set("cmd", (NutsElement)e.ofString(commandName)).set("id", (NutsElement)e.ofString(callId)).set("body", body).build();
    }

    public <T> T remoteCall(NutsElement call, Class<T> expectedType) {
        throw new NutsUnsupportedOperationException(null, NutsMessage.cstyle((String)"not yet supported remoteCall", (Object[])new Object[0]));
    }
}

