/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.optional.jansi;

import java.util.List;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import org.fusesource.jansi.AnsiConsole;

public class OptionalJansi {
    public static boolean isAvailable() {
        if (NutsOsFamily.getCurrent() == NutsOsFamily.WINDOWS) {
            try {
                Class.forName("org.fusesource.jansi.io.AnsiOutputStream");
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static NutsBootTerminal resolveStdFd(NutsSession session, List<String> flags) {
        boolean tty = flags.contains("tty");
        if (OptionalJansi.isAvailable()) {
            flags.add("jansi");
            if (System.console() != null) {
                AnsiConsole.systemInstall();
                flags.add("ansi");
                return new NutsBootTerminal(System.in, System.out, System.err, flags.toArray(new String[0]));
            }
            if (tty) {
                flags.add("ansi");
            } else {
                flags.add("raw");
            }
            return new NutsBootTerminal(System.in, System.out, System.err, flags.toArray(new String[0]));
        }
        return null;
    }
}

