/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.util;

import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;

public class SettingsRepoUtils {
    public static void showRepo(NutsApplicationContext context, NutsRepository repository, String prefix) {
        boolean enabled = repository.config().isEnabled();
        String disabledString = enabled ? "" : " <DISABLED>";
        NutsPrintStream out = context.getSession().out();
        out.print(prefix);
        NutsTextManager factory = context.getWorkspace().text();
        if (enabled) {
            out.print((NutsString)factory.forStyled(repository.getName() + disabledString, NutsTextStyle.primary2()));
        } else {
            out.print("```error " + repository.getName() + disabledString + "```");
        }
        out.print(" : " + repository.getRepositoryType() + " " + repository.config().getLocation(false));
        out.println();
    }

    public static void showRepoTree(NutsApplicationContext context, NutsRepository repository, String prefix) {
        SettingsRepoUtils.showRepo(context, repository, prefix);
        String prefix1 = prefix + "  ";
        if (repository.config().isSupportedMirroring()) {
            for (NutsRepository c : repository.config().getMirrors()) {
                SettingsRepoUtils.showRepoTree(context, c, prefix1);
            }
        }
    }
}

