/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix.AnyNixNdi;

public class NdiUtils {
    public static boolean isPathFolder(String p) {
        if (p == null) {
            return false;
        }
        return p.equals(".") || p.equals("..") || p.endsWith("/") || p.endsWith("\\");
    }

    public static boolean isPath(String p) {
        if (p == null) {
            return false;
        }
        return p.equals(".") || p.equals("..") || p.contains("/") || p.contains("\\");
    }

    public static Path sysWhich(String commandName) {
        Path[] p = NdiUtils.sysWhichAll(commandName);
        if (p.length > 0) {
            return p[0];
        }
        return null;
    }

    public static Path[] sysWhichAll(String commandName) {
        if (commandName == null || commandName.isEmpty()) {
            return new Path[0];
        }
        ArrayList<Path> all = new ArrayList<Path>();
        String p = System.getenv("PATH");
        if (p != null) {
            for (String s : p.split(File.pathSeparator)) {
                try {
                    Path c;
                    if (s.trim().isEmpty() || !Files.isRegularFile(c = Paths.get(s, commandName), new LinkOption[0]) || !Files.isExecutable(c)) continue;
                    all.add(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new Path[0]);
    }

    public static boolean setExecutable(Path path) {
        PosixFileAttributeView p;
        if (Files.exists(path, new LinkOption[0]) && !Files.isExecutable(path) && (p = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            try {
                HashSet<PosixFilePermission> old = new HashSet<PosixFilePermission>(p.readAttributes().permissions());
                old.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(path, old);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return true;
        }
        return false;
    }

    public static String generateScriptAsString(String resourcePath, Function<String, String> mapper) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(b));
        NdiUtils.generateScript(resourcePath, w, mapper);
        try {
            w.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return b.toString();
    }

    public static void generateScript(String resourcePath, BufferedWriter w, Function<String, String> mapper) {
        try {
            String lineSeparator = System.getProperty("line.separator");
            BufferedReader br = new BufferedReader(new InputStreamReader(AnyNixNdi.class.getResource(resourcePath).openStream()));
            String line = null;
            Pattern PATTERN = Pattern.compile("[$][$](?<name>([^$]+))[$][$]");
            while ((line = br.readLine()) != null) {
                Matcher matcher = PATTERN.matcher(line);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String name = matcher.group("name");
                    String x = mapper.apply(name);
                    if (x == null) {
                        x = "$$" + name + "$$";
                    }
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(x));
                }
                matcher.appendTail(sb);
                BufferedReader br2 = new BufferedReader(new StringReader(sb.toString()));
                String line2 = null;
                while ((line2 = br2.readLine()) != null) {
                    w.write(line2);
                    w.write(lineSeparator);
                }
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String betterPath(String path1) {
        String home = System.getProperty("user.home");
        if (path1.startsWith(home + "/") || path1.startsWith(home + "\\")) {
            return "~" + path1.substring(home.length());
        }
        return path1;
    }

    public static String replaceFilePrefixes(String path, Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String v = NdiUtils.replaceFilePrefix(path, e.getKey(), e.getValue());
            if (v.equals(path)) continue;
            return v;
        }
        return path;
    }

    public static String replaceFilePrefix(String path, String prefix, String replacement) {
        String path1 = path;
        String fs = File.separator;
        if (!prefix.endsWith(fs)) {
            prefix = prefix + fs;
        }
        if (!path1.endsWith(fs)) {
            path1 = prefix + fs;
        }
        if (path1.equals(prefix)) {
            if (replacement == null) {
                return "";
            }
            return replacement;
        }
        if (path.startsWith(prefix)) {
            if (replacement == null || replacement.equals("")) {
                return path1.substring(prefix.length());
            }
            return replacement + fs + path1.substring(prefix.length());
        }
        return path;
    }

    public static String longestCommonParent(String path1, String path2) {
        int latestSlash = -1;
        int len = Math.min(path1.length(), path2.length());
        for (int i = 0; i < len && path1.charAt(i) == path2.charAt(i); ++i) {
            if (path1.charAt(i) != '/') continue;
            latestSlash = i;
        }
        if (latestSlash <= 0) {
            return "";
        }
        return path1.substring(0, latestSlash + 1);
    }

    public static byte[] loadFile(Path out) {
        if (Files.isRegularFile(out, new LinkOption[0])) {
            try {
                return Files.readAllBytes(out);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static PathInfo.Status tryWriteStatus(byte[] content, Path out, NutsSession session) {
        return NdiUtils.tryWrite(content, out, DoWhenExist.IGNORE, DoWhenNotExists.IGNORE, session);
    }

    public static PathInfo.Status tryWrite(byte[] content, Path out, NutsSession session) {
        return NdiUtils.tryWrite(content, out, DoWhenExist.ASK, DoWhenNotExists.CREATE, session);
    }

    public static PathInfo.Status tryWrite(byte[] content, Path out, DoWhenExist doWhenExist, DoWhenNotExists doWhenNotExist, NutsSession session) {
        if (doWhenExist == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"missing doWhenExist"));
        }
        if (doWhenNotExist == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"missing doWhenNotExist"));
        }
        byte[] old = NdiUtils.loadFile(out = out.toAbsolutePath().normalize());
        if (old == null) {
            switch (doWhenNotExist) {
                case IGNORE: {
                    return PathInfo.Status.DISCARDED;
                }
                case CREATE: {
                    try {
                        if (out.getParent() != null) {
                            Files.createDirectories(out.getParent(), new FileAttribute[0]);
                        }
                        Files.write(out, content, new OpenOption[0]);
                        if (session.isPlainTrace()) {
                            session.out().printf("create file %s%n", new Object[]{session.getWorkspace().io().path(out)});
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return PathInfo.Status.CREATED;
                }
                case ASK: {
                    if (session.getTerminal().ask().resetLine().setDefaultValue((Object)true).setSession(session).forBoolean("create %s ?", new Object[]{session.getWorkspace().text().forStyled(NdiUtils.betterPath(out.toString()), NutsTextStyle.path())}).getBooleanValue().booleanValue()) {
                        try {
                            if (out.getParent() != null) {
                                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                            }
                            Files.write(out, content, new OpenOption[0]);
                            if (session.isPlainTrace()) {
                                session.out().printf("create file %s%n", new Object[]{session.getWorkspace().io().path(out)});
                            }
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        return PathInfo.Status.CREATED;
                    }
                    return PathInfo.Status.DISCARDED;
                }
            }
            throw new NutsUnsupportedEnumException(session, (Enum)doWhenNotExist);
        }
        if (Arrays.equals(old, content)) {
            return PathInfo.Status.DISCARDED;
        }
        switch (doWhenExist) {
            case IGNORE: {
                return PathInfo.Status.DISCARDED;
            }
            case OVERRIDE: {
                try {
                    Files.write(out, content, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (session.isPlainTrace()) {
                    session.out().printf("update file %s%n", new Object[]{session.getWorkspace().io().path(out)});
                }
                return PathInfo.Status.OVERRIDDEN;
            }
            case ASK: {
                if (session.getTerminal().ask().resetLine().setDefaultValue((Object)true).setSession(session).forBoolean("override %s ?", new Object[]{session.getWorkspace().text().forStyled(NdiUtils.betterPath(out.toString()), NutsTextStyle.path())}).getBooleanValue().booleanValue()) {
                    try {
                        try {
                            Files.write(out, content, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        Files.write(out, content, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    if (session.isPlainTrace()) {
                        session.out().printf("update file %s%n", new Object[]{session.getWorkspace().io().path(out)});
                    }
                    return PathInfo.Status.OVERRIDDEN;
                }
                return PathInfo.Status.DISCARDED;
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)doWhenExist);
    }

    public static enum DoWhenNotExists {
        IGNORE,
        CREATE,
        ASK;

    }

    public static enum DoWhenExist {
        IGNORE,
        OVERRIDE,
        ASK;

    }
}

