/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfoType;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.FreeDesktopEntry;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.AbstractFreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.util.NdiUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnixFreeDesktopEntryWriter
extends AbstractFreeDesktopEntryWriter {
    private final NutsSession session;
    private final Path desktopPath;

    public UnixFreeDesktopEntryWriter(NutsSession session, Path desktopPath) {
        this.session = session;
        this.desktopPath = desktopPath;
    }

    @Override
    public PathInfo[] writeShortcut(FreeDesktopEntry descriptor, Path path, boolean doOverride, NutsId id) {
        path = Paths.get(this.ensureName(path == null ? null : path.toString(), descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]);
        PathInfo.Status s = this.tryWrite(descriptor, path);
        return new PathInfo[]{new PathInfo(PathInfoType.DESKTOP_SHORTCUT, id, path, s)};
    }

    @Override
    public PathInfo[] writeDesktop(FreeDesktopEntry descriptor, String fileName, boolean doOverride, NutsId id) {
        fileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]).getFileName().toString();
        File q = this.desktopPath.resolve(fileName).toFile();
        return this.writeShortcut(descriptor, q.toPath(), doOverride, id);
    }

    @Override
    public PathInfo[] writeMenu(FreeDesktopEntry descriptor, String fileName, boolean doOverride, NutsId id) {
        String menuFileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "menu"), new String[0]).getFileName().toString();
        String desktopFileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]).getFileName().toString();
        ArrayList<PathInfo> all = new ArrayList<PathInfo>();
        FreeDesktopEntry.Group root = descriptor.getOrCreateDesktopEntry();
        File folder4shortcuts = new File(System.getProperty("user.home") + "/.local/share/applications");
        folder4shortcuts.mkdirs();
        File shortcutFile = new File(folder4shortcuts, desktopFileName);
        all.add(new PathInfo(PathInfoType.DESKTOP_MENU, id, shortcutFile.toPath(), this.tryWrite(descriptor, shortcutFile)));
        ArrayList<String> categories = new ArrayList<String>(root.getCategories());
        if (categories.isEmpty()) {
            categories.add("/");
        }
        File folder4menus = new File(System.getProperty("user.home") + "/.config/menus/applications-merged");
        folder4menus.mkdirs();
        for (String menuPath : categories) {
            String[] part = (String[])Arrays.stream((menuPath == null ? "" : menuPath).split("/")).filter(x -> !x.isEmpty()).toArray(String[]::new);
            if (part.length == 0) {
                part = new String[]{"Applications"};
            } else if (!part[0].equals("Applications")) {
                ArrayList<String> li = new ArrayList<String>();
                li.add("Applications");
                li.addAll(Arrays.asList(part));
                part = li.toArray(new String[0]);
            }
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document dom = builder.newDocument();
                dom.appendChild(this.createMenuXmlElement(part, desktopFileName, dom));
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                tr.transform(new DOMSource(dom), new StreamResult(b));
                File menuFile = new File(folder4menus, menuFileName);
                all.add(new PathInfo(PathInfoType.DESKTOP_MENU, id, menuFile.toPath(), NdiUtils.tryWrite(b.toByteArray(), menuFile.toPath(), this.session)));
            }
            catch (ParserConfigurationException | TransformerException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (all.stream().anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED)) {
            this.updateDesktopMenus();
        }
        return all.toArray(new PathInfo[0]);
    }

    private void updateDesktopMenus() {
        String outStr;
        Path a = NdiUtils.sysWhich("kbuildsycoca5");
        if (a != null) {
            outStr = this.session.getWorkspace().exec().setCommand(new String[]{a.toString()}).setExecutionType(NutsExecutionType.SYSTEM).setRedirectErrorStream(true).grabOutputString().run().getOutputString().trim();
            if (this.session.isPlainTrace() && !outStr.isEmpty()) {
                this.session.out().println(outStr);
            }
        }
        if ((a = NdiUtils.sysWhich("update-desktop-database")) != null) {
            outStr = this.session.getWorkspace().exec().setCommand(new String[]{a.toString(), System.getProperty("user.home") + "/.local/share/applications"}).setExecutionType(NutsExecutionType.SYSTEM).setRedirectErrorStream(true).grabOutputString().run().getOutputString().trim();
            if (this.session.isPlainTrace() && !outStr.isEmpty()) {
                this.session.out().println(outStr);
            }
        }
        if ((a = NdiUtils.sysWhich("xdg-desktop-menu")) != null) {
            outStr = this.session.getWorkspace().exec().setCommand(new String[]{a.toString(), "forceupdate"}).setExecutionType(NutsExecutionType.SYSTEM).setRedirectErrorStream(true).grabOutputString().run().getOutputString().trim();
            if (this.session.isPlainTrace() && !outStr.isEmpty()) {
                this.session.out().println(outStr);
            }
        }
    }

    private String getDesktopEnvironment() {
        return System.getenv("XDG_SESSION_DESKTOP");
    }

    private Element createMenuXmlElement(String[] a, String name, Document dom) {
        if (a.length == 1) {
            Element menu = dom.createElement("Menu");
            Element d = dom.createElement("Name");
            d.setTextContent(a[0]);
            Element f = dom.createElement("Filename");
            f.setTextContent(name);
            Element i = dom.createElement("Include");
            i.appendChild(f);
            menu.appendChild(d);
            menu.appendChild(i);
            return menu;
        }
        Element menu = dom.createElement("Menu");
        Element d = dom.createElement("Name");
        d.setTextContent(a[0]);
        menu.appendChild(d);
        menu.appendChild(this.createMenuXmlElement(Arrays.copyOfRange(a, 1, a.length), name, dom));
        return menu;
    }

    public void write(FreeDesktopEntry file, Path out) {
        try (PrintStream p = new PrintStream(Files.newOutputStream(out, new OpenOption[0]));){
            this.write(file, p);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public PathInfo.Status tryWrite(FreeDesktopEntry file, Path out) {
        return NdiUtils.tryWrite(this.writeAsString(file).getBytes(), out, this.session);
    }

    public PathInfo.Status tryWrite(FreeDesktopEntry file, File out) {
        return this.tryWrite(file, out.toPath());
    }

    public String writeAsString(FreeDesktopEntry file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        this.write(file, out);
        out.flush();
        return bos.toString();
    }

    public void write(FreeDesktopEntry file, File out) {
        try (PrintStream p = new PrintStream(out);){
            this.write(file, p);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void write(FreeDesktopEntry file, NutsPrintStream out) {
        this.write(file, out.asPrintStream());
    }

    public void write(FreeDesktopEntry file, PrintStream out) {
        out.println("#!/usr/bin/env xdg-open");
        for (FreeDesktopEntry.Group group : file.getGroups()) {
            out.println();
            String gn = group.getGroupName();
            if (gn == null || gn.trim().length() == 0) {
                throw new IllegalArgumentException("invalid group name");
            }
            FreeDesktopEntry.Type t = group.getType();
            if (t == null) {
                throw new IllegalArgumentException("missing type");
            }
            out.println("[" + gn.trim() + "]");
            for (Map.Entry<String, Object> e : group.toMap().entrySet()) {
                Object value = e.getValue();
                String key = e.getKey();
                if (value instanceof FreeDesktopEntry.Type) {
                    String v = value.toString().toLowerCase();
                    v = Character.toUpperCase(v.charAt(0)) + v.substring(1);
                    out.println(key + "=" + v);
                    continue;
                }
                if (value instanceof Boolean || value instanceof String) {
                    out.println(key + "=" + value);
                    continue;
                }
                if (value instanceof List) {
                    char sep = ';';
                    out.println(key + "=" + ((List)value).stream().map(x -> {
                        StringBuilder sb = new StringBuilder();
                        for (char c : x.toCharArray()) {
                            if (c == sep || c == '\\') {
                                sb.append('\\');
                            }
                            sb.append(c);
                        }
                        return sb.toString();
                    }).collect(Collectors.joining("" + sep)));
                    continue;
                }
                throw new IllegalArgumentException("unsupported value type for " + key);
            }
        }
    }
}

