/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfoType;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.AbstractScriptBuilder;

public class SimpleScriptBuilder
extends AbstractScriptBuilder {
    private BaseSystemNdi sndi;
    private List<String> lines = new ArrayList<String>();

    public SimpleScriptBuilder(PathInfoType type, NutsId anyId, BaseSystemNdi sndi, NutsSession session) {
        super(type, anyId, session);
        this.sndi = sndi;
    }

    public SimpleScriptBuilder printCall(String line, String ... args) {
        return this.println(this.sndi.getCallScriptCommand(line, args));
    }

    public SimpleScriptBuilder printSet(String var, String value) {
        return this.println(this.sndi.getSetVarCommand(var, value));
    }

    public SimpleScriptBuilder printSetStatic(String var, String value) {
        return this.println(this.sndi.getSetVarStaticCommand(var, value));
    }

    public SimpleScriptBuilder printComment(String line) {
        for (String s : this._split(line)) {
            this.println(this.sndi.toCommentLine(s));
        }
        return this;
    }

    private List<String> _split(String line) {
        ArrayList<String> a = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(line));
        try {
            String c;
            while ((c = br.readLine()) != null) {
                a.add(c);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return a;
    }

    private List<String> currBody() {
        return this.lines;
    }

    public SimpleScriptBuilder println(String line) {
        this.currBody().addAll(this._split(line));
        return this;
    }

    @Override
    public String buildString() {
        return String.join((CharSequence)this.sndi.newlineString(), this.lines);
    }

    @Override
    public SimpleScriptBuilder setPath(Path path) {
        return (SimpleScriptBuilder)super.setPath(path);
    }

    @Override
    public SimpleScriptBuilder setPath(String preferredName) {
        return (SimpleScriptBuilder)super.setPath(preferredName);
    }
}

