/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfoType;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.AbstractScriptBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.util.NdiUtils;

public class FromTemplateScriptBuilder
extends AbstractScriptBuilder {
    private final BaseSystemNdi sndi;
    private String templateName;
    private final Map<String, List<String>> bodyMap = new LinkedHashMap<String, List<String>>();
    private String currBody = "BODY";
    private Function<String, String> mapper;
    private final NdiScriptOptions options;

    public FromTemplateScriptBuilder(String templateName, PathInfoType type, NutsId anyId, BaseSystemNdi sndi, NdiScriptOptions options, NutsSession session) {
        super(type, anyId, session);
        this.sndi = sndi;
        this.options = options;
        this.templateName = templateName;
    }

    public FromTemplateScriptBuilder printCall(String line, String ... args) {
        return this.println(this.sndi.getCallScriptCommand(line, args));
    }

    public FromTemplateScriptBuilder printSet(String var, String value) {
        return this.println(this.sndi.getSetVarCommand(var, value));
    }

    public FromTemplateScriptBuilder printSetStatic(String var, String value) {
        return this.println(this.sndi.getSetVarStaticCommand(var, value));
    }

    public FromTemplateScriptBuilder printComment(String line) {
        for (String s : this._split(line)) {
            this.println(this.sndi.toCommentLine(s));
        }
        return this;
    }

    private List<String> _split(String line) {
        ArrayList<String> a = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(line));
        try {
            String c;
            while ((c = br.readLine()) != null) {
                a.add(c);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return a;
    }

    private List<String> currBody() {
        return this.bodyMap.computeIfAbsent(this.currBody, v -> new ArrayList());
    }

    public FromTemplateScriptBuilder withBody(String b) {
        if (b == null || b.isEmpty()) {
            b = "BODY";
        }
        this.currBody = b;
        return this;
    }

    public FromTemplateScriptBuilder println(String line) {
        this.currBody().addAll(this._split(line));
        return this;
    }

    public Function<String, String> getMapper() {
        return this.mapper;
    }

    public FromTemplateScriptBuilder setMapper(Function<String, String> mapper) {
        this.mapper = mapper;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public FromTemplateScriptBuilder setTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    @Override
    public String buildString() {
        try {
            NutsDefinition anyIdDef = (NutsDefinition)this.getSession().getWorkspace().search().addId(this.getAnyId()).setLatest(true).getResultDefinitions().singleton();
            final NutsId anyId = anyIdDef.getId();
            StringWriter bos = new StringWriter();
            try (BufferedWriter w = new BufferedWriter(bos);){
                NdiUtils.generateScript("/net/thevpc/nuts/runtime/settings/" + this.sndi.getTemplateName(this.templateName), w, new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        String v;
                        String string = v = FromTemplateScriptBuilder.this.mapper == null ? null : (String)FromTemplateScriptBuilder.this.mapper.apply(s);
                        if (v != null) {
                            return v;
                        }
                        switch (s) {
                            case "NUTS_ID": {
                                return anyId.getLongName();
                            }
                            case "GENERATOR": {
                                return FromTemplateScriptBuilder.this.getSession().getWorkspace().getRuntimeId().getLongName();
                            }
                            case "SCRIPT_NUTS": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsStart(FromTemplateScriptBuilder.this.options).path().toString();
                            }
                            case "SCRIPT_NUTS_TERM_INIT": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsTermInit(FromTemplateScriptBuilder.this.options).path().toString();
                            }
                            case "SCRIPT_NUTS_TERM": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsTerm(FromTemplateScriptBuilder.this.options).path().toString();
                            }
                            case "SCRIPT_NUTS_INIT": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsInit(FromTemplateScriptBuilder.this.options).path().toString();
                            }
                            case "SCRIPT_NUTS_ENV": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsEnv(FromTemplateScriptBuilder.this.options).path().toString();
                            }
                            case "NUTS_JAR": {
                                return FromTemplateScriptBuilder.this.options.resolveNutsApiJarPath().toString();
                            }
                            case "BIN_FOLDER": {
                                return FromTemplateScriptBuilder.this.options.resolveBinFolder().toString();
                            }
                            case "INC_FOLDER": {
                                return FromTemplateScriptBuilder.this.options.resolveIncFolder().toString();
                            }
                            case "NUTS_API_VERSION": {
                                return FromTemplateScriptBuilder.this.options.getNutsApiVersion().toString();
                            }
                            case "NUTS_API_ID": {
                                return FromTemplateScriptBuilder.this.options.resolveNutsApiId().toString();
                            }
                        }
                        List q = (List)FromTemplateScriptBuilder.this.bodyMap.get(s);
                        if (q != null) {
                            return String.join((CharSequence)FromTemplateScriptBuilder.this.sndi.newlineString(), q);
                        }
                        return s;
                    }
                });
            }
            return bos.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public FromTemplateScriptBuilder setPath(Path path) {
        return (FromTemplateScriptBuilder)super.setPath(path);
    }

    @Override
    public FromTemplateScriptBuilder setPath(String preferredName) {
        return (FromTemplateScriptBuilder)super.setPath(preferredName);
    }
}

