/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi;

import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.optional.mslink.OptionalMsLinkHelper;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.SystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix.LinuxNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix.MacosNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix.UnixNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.util.NdiUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.win.WindowsNdi;

public class NutsSettingsNdiSubCommand
extends AbstractNutsSettingsSubCommand {
    public static SystemNdi createNdi(NutsSession session) {
        BaseSystemNdi ndi = null;
        switch (session.getWorkspace().env().getOsFamily()) {
            case LINUX: {
                ndi = new LinuxNdi(session);
                break;
            }
            case UNIX: {
                ndi = new UnixNdi(session);
                break;
            }
            case MACOS: {
                ndi = new MacosNdi(session);
                break;
            }
            case WINDOWS: {
                if (!OptionalMsLinkHelper.isSupported()) break;
                ndi = new WindowsNdi(session);
            }
        }
        return ndi;
    }

    public void runAddLauncher(NutsCommandLine commandLine, NutsSession session) {
        NdiScriptOptions options = new NdiScriptOptions();
        options.setSession(session.copy());
        ArrayList<String> idsToInstall = new ArrayList<String>();
        NutsWorkspace ws = session.getWorkspace();
        boolean missingAnyArgument = true;
        boolean ignoreUnsupportedOs = false;
        commandLine.setCommandName("settings add launcher");
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextBoolean(new String[]{"-t", "--fetch"});
            if (a != null) {
                options.setFetch(a.getBooleanValue());
                continue;
            }
            a = commandLine.nextString(new String[]{"-d", "--workdir"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setWorkingDirectory(a.getStringValue());
                continue;
            }
            a = commandLine.nextString(new String[]{"--icon"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setIcon(a.getStringValue());
                continue;
            }
            a = commandLine.next(new String[]{"--menu"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setCreateMenuShortcut(this.parseCond(a));
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-category"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setMenuCategory(a.getStringValue());
                if (options.getLauncher().getMenuCategory() == null || options.getLauncher().getMenuCategory().isEmpty() || options.getLauncher().getCreateMenuShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateMenuShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--desktop"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setCreateDesktopShortcut(this.parseCond(a));
                continue;
            }
            a = commandLine.nextString(new String[]{"--desktop-name"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setShortcutName(a.getStringValue());
                if (options.getLauncher().getCreateDesktopShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateDesktopShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-name"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setShortcutName(a.getStringValue());
                if (options.getLauncher().getCreateDesktopShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateMenuShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextString(new String[]{"--shortcut-name"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setShortcutName(a.getStringValue());
                if (options.getLauncher().getCreateCustomShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateCustomShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextString(new String[]{"--shortcut-path"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setCustomShortcutPath(a.getStringValue());
                if (options.getLauncher().getCreateCustomShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateCustomShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"-x", "--external", "--spawn"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--spawn");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"-b", "--embedded"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--embedded");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--terminal"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().setOpenTerminal(a.getBooleanValue());
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"-e", "--env"});
            if (a != null) {
                options.setIncludeEnv(a.getBooleanValue());
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--system"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--system");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--current-user"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--current-user");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--as-root"});
            if (a != null) {
                if (!a.isEnabled() || !a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--as-root");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--sudo"});
            if (a != null) {
                if (!a.isEnabled() || !a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--sudo");
                continue;
            }
            a = commandLine.nextString(new String[]{"--run-as"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                options.getLauncher().getNutsOptions().add("--run-as=" + a.getStringValue());
                continue;
            }
            a = commandLine.nextString(new String[]{"-X", "--exec-options"});
            if (a != null) {
                options.getLauncher().getNutsOptions().add("--exec-options=" + a.getStringValue());
                continue;
            }
            a = commandLine.nextString(new String[]{"-i", "--installed"});
            if (a != null) {
                session.setConfirm(NutsConfirmationMode.YES);
                for (NutsId resultId : ws.search().setInstallStatus(ws.filters().installStatus().byInstalled(true)).getResultIds()) {
                    idsToInstall.add(resultId.getLongName());
                    missingAnyArgument = false;
                }
                continue;
            }
            a = commandLine.nextString(new String[]{"-c", "--companions"});
            if (a != null) {
                session.setConfirm(NutsConfirmationMode.YES);
                for (NutsId companion : ws.getCompanionIds(session)) {
                    idsToInstall.add(((NutsId)ws.search().addId(companion).setLatest(true).getResultIds().required()).getLongName());
                    missingAnyArgument = false;
                }
                continue;
            }
            a = commandLine.nextString(new String[]{"--switch"});
            if (a != null) {
                Boolean booleanValue = a.getBooleanValue(null);
                if (booleanValue == null) continue;
                options.getLauncher().setSystemWideConfig(booleanValue);
                continue;
            }
            a = commandLine.nextString(new String[]{"--ignore-unsupported-os"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                ignoreUnsupportedOs = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().getStringKey().equals("-w") || commandLine.peek().getStringKey().equals("--workspace")) {
                a = commandLine.nextString(new String[0]);
                if (!a.isEnabled()) continue;
                options.getLauncher().setSwitchWorkspaceLocation(a.getStringValue());
                continue;
            }
            if (commandLine.peek().getStringKey().equals("-n") || commandLine.peek().getStringKey().equals("--name")) {
                a = commandLine.nextString(new String[0]);
                if (!a.isEnabled()) continue;
                options.getLauncher().setCustomScriptPath(a.getStringValue());
                continue;
            }
            if (commandLine.peek().isOption()) {
                session.configureLast(commandLine);
                continue;
            }
            idsToInstall.add(commandLine.next().getString());
            missingAnyArgument = false;
        }
        if (missingAnyArgument) {
            commandLine.required();
        }
        if (commandLine.isExecMode()) {
            SystemNdi ndi = NutsSettingsNdiSubCommand.createNdi(session);
            if (ndi == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"platform not supported : %s", (Object[])new Object[]{ws.env().getOs()}), 2);
            }
            if (!idsToInstall.isEmpty()) {
                this.printResults(session, ndi.addScript(options, idsToInstall.toArray(new String[0])));
            }
        }
    }

    private NutsSupportCondition parseCond(NutsArgument a) {
        String s;
        switch (s = a.getStringValue("")) {
            case "supported": {
                return NutsSupportCondition.SUPPORTED;
            }
            case "never": {
                return NutsSupportCondition.NEVER;
            }
            case "always": {
                return NutsSupportCondition.ALWAYS;
            }
            case "preferred": 
            case "": {
                return NutsSupportCondition.PREFERRED;
            }
        }
        if (a.getBooleanValue()) {
            return NutsSupportCondition.PREFERRED;
        }
        return NutsSupportCondition.NEVER;
    }

    public void runRemoveLauncher(NutsCommandLine commandLine, NutsSession session) {
        ArrayList<String> idsToUninstall = new ArrayList<String>();
        boolean forceAll = false;
        NutsWorkspace ws = session.getWorkspace();
        boolean missingAnyArgument = true;
        boolean ignoreUnsupportedOs = false;
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextString(new String[]{"--ignore-unsupported-os"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                ignoreUnsupportedOs = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().isOption()) {
                session.configureLast(commandLine);
                continue;
            }
            idsToUninstall.add(commandLine.next().getString());
            missingAnyArgument = false;
        }
        if (missingAnyArgument) {
            commandLine.required();
        }
        Path workspaceLocation = Paths.get(ws.locations().getWorkspaceLocation(), new String[0]);
        if (commandLine.isExecMode()) {
            SystemNdi ndi;
            if (forceAll) {
                session.setConfirm(NutsConfirmationMode.YES);
            }
            if ((ndi = NutsSettingsNdiSubCommand.createNdi(session)) == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"platform not supported : %s", (Object[])new Object[]{ws.env().getOs()}), 2);
            }
            boolean subTrace = session.isTrace();
            if (!session.isPlainTrace()) {
                subTrace = false;
            }
            if (!idsToUninstall.isEmpty()) {
                for (String id : idsToUninstall) {
                    try {
                        ndi.removeNutsScript(id, null, session.copy().setTrace(Boolean.valueOf(subTrace)));
                    }
                    catch (UncheckedIOException e) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to run script %s : %s", (Object[])new Object[]{id, e}), (Throwable)e);
                    }
                }
            }
        }
    }

    public void runSwitch(NutsCommandLine commandLine, NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        String switchWorkspaceLocation = null;
        String switchWorkspaceApi = null;
        boolean ignoreUnsupportedOs = false;
        NutsSupportCondition createDesktop = NutsSupportCondition.NEVER;
        NutsSupportCondition createMenu = NutsSupportCondition.NEVER;
        String menuCategory = null;
        String shortcutName = null;
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextString(new String[]{"--ignore-unsupported-os"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                ignoreUnsupportedOs = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().getStringKey().equals("-w") || commandLine.peek().getStringKey().equals("--workspace")) {
                switchWorkspaceLocation = commandLine.nextString(new String[0]).getStringValue();
                continue;
            }
            if (commandLine.peek().getStringKey().equals("-a") || commandLine.peek().getStringKey().equals("--api")) {
                switchWorkspaceApi = commandLine.nextString(new String[0]).getStringValue();
                continue;
            }
            a = commandLine.next(new String[]{"--menu"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                createMenu = this.parseCond(a);
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-category"});
            if (a != null) {
                if (!a.isEnabled() || (menuCategory = a.getStringValue()) == null || menuCategory.isEmpty() || createMenu != NutsSupportCondition.NEVER) continue;
                createMenu = NutsSupportCondition.PREFERRED;
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-name"});
            if (a != null) {
                if (!a.isEnabled() || (shortcutName = a.getStringValue()) == null || shortcutName.isEmpty() || createMenu != NutsSupportCondition.NEVER) continue;
                createMenu = NutsSupportCondition.PREFERRED;
                continue;
            }
            a = commandLine.nextString(new String[]{"--desktop-name"});
            if (a != null) {
                if (!a.isEnabled() || (shortcutName = a.getStringValue()) == null || shortcutName.isEmpty() || createDesktop != NutsSupportCondition.NEVER) continue;
                createDesktop = NutsSupportCondition.PREFERRED;
                continue;
            }
            a = commandLine.next(new String[]{"--desktop"});
            if (a != null) {
                if (!a.isEnabled()) continue;
                createDesktop = this.parseCond(a);
                continue;
            }
            if (commandLine.peek().isOption()) {
                commandLine.unexpectedArgument();
                continue;
            }
            if (switchWorkspaceLocation == null) {
                switchWorkspaceLocation = commandLine.next().getString();
                continue;
            }
            if (switchWorkspaceApi == null) {
                switchWorkspaceApi = commandLine.next().getString();
                continue;
            }
            if (commandLine.peek().isOption()) {
                session.configureLast(commandLine);
                continue;
            }
            commandLine.unexpectedArgument();
        }
        if (commandLine.isExecMode()) {
            SystemNdi ndi = NutsSettingsNdiSubCommand.createNdi(session);
            if (ndi == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"platform not supported : %s ", (Object[])new Object[]{ws.env().getOs()}), 2);
            }
            if (switchWorkspaceLocation != null || switchWorkspaceApi != null) {
                NdiScriptOptions oo = new NdiScriptOptions().setSession(session);
                oo.getLauncher().setSwitchWorkspaceLocation(switchWorkspaceLocation);
                oo.getLauncher().setCreateDesktopShortcut(createDesktop);
                oo.getLauncher().setMenuCategory(menuCategory);
                oo.getLauncher().setCreateMenuShortcut(createMenu);
                oo.getLauncher().setShortcutName(shortcutName);
                ndi.switchWorkspace(oo);
            }
        }
    }

    private void printResults(NutsSession session, PathInfo[] result) {
        NutsWorkspace ws = session.getWorkspace();
        if (session.isTrace()) {
            result = (PathInfo[])Arrays.stream(result).filter(x -> x.getStatus() != PathInfo.Status.DISCARDED).toArray(PathInfo[]::new);
            if (session.isPlainTrace()) {
                int namesSize = Arrays.stream(result).mapToInt(x -> x.getPath().getFileName().toString().length()).max().orElse(1);
                for (PathInfo ndiScriptInfo : result) {
                    session.out().resetLine().printf("%s script %-" + namesSize + "s for %s at %s%n", new Object[]{ndiScriptInfo.getStatus() == PathInfo.Status.OVERRIDDEN ? ws.text().forStyled("re-install", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()})) : ws.text().forStyled("install", NutsTextStyle.success()), ws.text().forStyled(ndiScriptInfo.getPath().getFileName().toString(), NutsTextStyle.path()), ndiScriptInfo.getId(), ws.text().forStyled(NdiUtils.betterPath(ndiScriptInfo.getPath().toString()), NutsTextStyle.path())});
                }
            } else {
                session.getWorkspace().formats().object((Object)result).println();
            }
        }
    }

    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"add launcher", "lna"}) != null) {
            this.runAddLauncher(cmdLine, session);
            return true;
        }
        if (cmdLine.next(new String[]{"remove launcher", "lnrm"}) != null) {
            this.runRemoveLauncher(cmdLine, session);
            return true;
        }
        if (cmdLine.next(new String[]{"switch", "lnsw"}) != null) {
            this.runSwitch(cmdLine, session);
            return true;
        }
        return false;
    }
}

