/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FreeDesktopEntry {
    public static final String GROUP_DESKTOP_ENTRY = "Desktop Entry";
    private Map<String, Group> groups = new LinkedHashMap<String, Group>();

    public void add(Group g) {
        if (g.getGroupName() == null) {
            throw new IllegalArgumentException("illegal free desktop group Name");
        }
        this.groups.put(g.getGroupName(), g);
    }

    public Group getOrCreateDesktopEntry() {
        Group q = this.groups.get(GROUP_DESKTOP_ENTRY);
        if (q == null) {
            q = Group.desktopEntry(null, null, System.getProperty("user.home"));
            this.groups.put(GROUP_DESKTOP_ENTRY, q);
        }
        if (q.getType() == null) {
            q.setType(Type.APPLICATION);
        }
        return q;
    }

    public Group getOrCreateGroup(String name) {
        return this.groups.computeIfAbsent(name, k -> new Group(name));
    }

    public List<Group> getGroups() {
        return new ArrayList<Group>(this.groups.values());
    }

    public static class Group {
        private final String groupName;
        private String version;
        private Type type;
        private String name;
        private String genericName;
        private String comment;
        private String tryExec;
        private String exec;
        private String icon;
        private String path;
        private boolean noDisplay;
        private boolean hidden;
        private boolean terminal;
        private boolean dbusActivatable;
        private List<String> actions = new ArrayList<String>();
        private List<String> mimeType = new ArrayList<String>();
        private List<String> categories = new ArrayList<String>();
        private List<String> implementsList = new ArrayList<String>();
        private List<String> keywords = new ArrayList<String>();
        private List<String> onlyShowIn = new ArrayList<String>();
        private List<String> notShowIn = new ArrayList<String>();
        private boolean startNotify;
        private String startupWMClass;
        private String url;
        private boolean prefersNonDefaultGPU;

        public Group(String groupName) {
            this.groupName = groupName;
        }

        public static Group desktopEntry(String name, String exec, String path) {
            return Group.application(FreeDesktopEntry.GROUP_DESKTOP_ENTRY, name, exec, path);
        }

        public static Group application(String entryId, String name, String exec, String path) {
            return new Group(entryId).setType(Type.APPLICATION).setName(name).setExec(exec).setPath(path);
        }

        public static Group link(String entryId, String name, String url) {
            return new Group(entryId).setType(Type.LINK).setName(name).setUrl(url);
        }

        public static Group directory(String entryId, String name, String path) {
            return new Group(entryId).setType(Type.DIRECTORY).setName(name).setPath(path);
        }

        private boolean addString(String k, String v, Map<String, Object> m) {
            if (v != null && v.length() > 0) {
                m.put(k, v);
                return true;
            }
            return false;
        }

        private boolean addBoolean(String k, boolean v, Map<String, Object> m) {
            if (v) {
                m.put(k, v);
                return true;
            }
            return false;
        }

        private boolean addStrings(String k, List<String> v, Map<String, Object> m) {
            if (v != null && v.size() > 0) {
                m.put(k, new ArrayList<String>(v));
                return true;
            }
            return false;
        }

        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            if (this.type != null) {
                m.put("Type", (Object)this.type);
            }
            this.addString("Version", this.version, m);
            this.addString("Name", this.name, m);
            this.addString("GenericName", this.genericName, m);
            this.addString("Comment", this.comment, m);
            this.addString("TryExec", this.tryExec, m);
            this.addString("Exec", this.exec, m);
            this.addString("Icon", this.icon, m);
            this.addString("Path", this.path, m);
            this.addString("URL", this.url, m);
            this.addString("StartupWMClass", this.startupWMClass, m);
            this.addBoolean("NoDisplay", this.noDisplay, m);
            this.addBoolean("Hidden", this.hidden, m);
            this.addBoolean("Terminal", this.terminal, m);
            this.addBoolean("DBusActivatable", this.dbusActivatable, m);
            this.addBoolean("StartNotify", this.startNotify, m);
            this.addBoolean("PrefersNonDefaultGPU", this.prefersNonDefaultGPU, m);
            this.addStrings("Actions", this.actions, m);
            this.addStrings("MimeType", this.mimeType, m);
            this.addStrings("Categories", this.categories, m);
            this.addStrings("ImplementsList", this.implementsList, m);
            this.addStrings("Keywords", this.keywords, m);
            this.addStrings("OnlyShowIn", this.onlyShowIn, m);
            this.addStrings("NotShowIn", this.notShowIn, m);
            this.addStrings("NotShowIn", this.notShowIn, m);
            return m;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getVersion() {
            return this.version;
        }

        public Group setVersion(String version) {
            this.version = version;
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public Group setType(Type type) {
            this.type = type;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Group setName(String name) {
            this.name = name;
            return this;
        }

        public String getGenericName() {
            return this.genericName;
        }

        public Group setGenericName(String genericName) {
            this.genericName = genericName;
            return this;
        }

        public String getComment() {
            return this.comment;
        }

        public Group setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public String getTryExec() {
            return this.tryExec;
        }

        public Group setTryExec(String tryExec) {
            this.tryExec = tryExec;
            return this;
        }

        public String getExec() {
            return this.exec;
        }

        public Group setExec(String exec) {
            this.exec = exec;
            return this;
        }

        public String getIcon() {
            return this.icon;
        }

        public Group setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public Group setPath(String path) {
            this.path = path;
            return this;
        }

        public boolean isNoDisplay() {
            return this.noDisplay;
        }

        public Group setNoDisplay(boolean noDisplay) {
            this.noDisplay = noDisplay;
            return this;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Group setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public Group setTerminal(boolean terminal) {
            this.terminal = terminal;
            return this;
        }

        public boolean isDbusActivatable() {
            return this.dbusActivatable;
        }

        public Group setDbusActivatable(boolean dbusActivatable) {
            this.dbusActivatable = dbusActivatable;
            return this;
        }

        public List<String> getActions() {
            return this.actions;
        }

        public Group setActions(List<String> actions) {
            this.actions = actions;
            return this;
        }

        public List<String> getMimeType() {
            return this.mimeType;
        }

        public Group setMimeType(List<String> mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public Group addCategory(String category) {
            if (category != null && !this.categories.contains(category)) {
                this.categories.add(category);
            }
            return this;
        }

        public Group setCategories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public List<String> getImplementsList() {
            return this.implementsList;
        }

        public Group setImplementsList(List<String> implementsList) {
            this.implementsList = implementsList;
            return this;
        }

        public List<String> getKeywords() {
            return this.keywords;
        }

        public Group setKeywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public List<String> getOnlyShowIn() {
            return this.onlyShowIn;
        }

        public Group setOnlyShowIn(List<String> onlyShowIn) {
            this.onlyShowIn = onlyShowIn;
            return this;
        }

        public List<String> getNotShowIn() {
            return this.notShowIn;
        }

        public Group setNotShowIn(List<String> notShowIn) {
            this.notShowIn = notShowIn;
            return this;
        }

        public boolean isStartNotify() {
            return this.startNotify;
        }

        public Group setStartNotify(boolean startNotify) {
            this.startNotify = startNotify;
            return this;
        }

        public String getStartupWMClass() {
            return this.startupWMClass;
        }

        public Group setStartupWMClass(String startupWMClass) {
            this.startupWMClass = startupWMClass;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public Group setUrl(String url) {
            this.url = url;
            return this;
        }

        public boolean isPrefersNonDefaultGPU() {
            return this.prefersNonDefaultGPU;
        }

        public Group setPrefersNonDefaultGPU(boolean prefersNonDefaultGPU) {
            this.prefersNonDefaultGPU = prefersNonDefaultGPU;
            return this;
        }
    }

    public static enum Type {
        APPLICATION,
        LINK,
        DIRECTORY;

    }
}

