/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands;

import java.util.Arrays;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineManager;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.NutsSettingsUserSubCommand;

public class NutsSettingsRepositorySubCommand
extends AbstractNutsSettingsSubCommand {
    public static RepoInfo repoInfo(NutsRepository x, boolean tree, NutsSession session) {
        return new RepoInfo(x.getName(), x.config().getType(), x.config().getLocation(true), x.config().isEnabled(), tree ? (RepoInfo[])Arrays.stream(x.config().setSession(session).getMirrors()).map(e -> NutsSettingsRepositorySubCommand.repoInfo(e, tree, session)).toArray(RepoInfo[]::new) : null);
    }

    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        NutsCommandLineManager commandLineFormat = session.getWorkspace().commandLine();
        NutsWorkspace ws = session.getWorkspace();
        NutsPrintStream out = session.out();
        if (cmdLine.next(new String[]{"add repo", "ar"}) != null) {
            String location = null;
            String repositoryName = null;
            String repoType = null;
            String parent = null;
            block27: while (cmdLine.hasNext()) {
                NutsArgument a = cmdLine.peek();
                boolean enabled = a.isEnabled();
                switch (a.getStringKey()) {
                    case "-l": 
                    case "--location": {
                        String val = cmdLine.nextString(new String[0]).getStringValue();
                        if (!enabled) continue block27;
                        location = val;
                        continue block27;
                    }
                    case "--name": {
                        String val = cmdLine.nextString(new String[0]).getStringValue();
                        if (!enabled) continue block27;
                        repositoryName = val;
                        continue block27;
                    }
                    case "--type": {
                        String val = cmdLine.nextString(new String[0]).getStringValue();
                        if (!enabled) continue block27;
                        repoType = val;
                        continue block27;
                    }
                    case "--parent": {
                        String val = cmdLine.nextString(new String[0]).getStringValue();
                        if (!enabled) continue block27;
                        parent = val;
                        continue block27;
                    }
                }
                if (session.configureFirst(cmdLine)) continue;
                if (a.isOption()) {
                    cmdLine.unexpectedArgument();
                    continue;
                }
                if (repositoryName == null) {
                    repositoryName = cmdLine.next().getString();
                    continue;
                }
                if (location == null) {
                    location = cmdLine.next().getString();
                    continue;
                }
                cmdLine.unexpectedArgument();
            }
            if (repositoryName == null) {
                cmdLine.required();
            }
            if (cmdLine.isExecMode()) {
                NutsRepository repo = null;
                NutsAddRepositoryOptions o = new NutsAddRepositoryOptions().setName(repositoryName).setLocation(repositoryName).setConfig(location == null ? null : new NutsRepositoryConfig().setName(repositoryName).setLocation(location).setType(repoType));
                if (parent == null) {
                    repo = ws.repos().addRepository(o);
                } else {
                    NutsRepository p = ws.repos().getRepository(parent);
                    repo = p.config().addMirror(o);
                }
                out.printf("repository added successfully%n", new Object[0]);
                session.getWorkspace().config().save();
            }
            cmdLine.setCommandName("config add repo").unexpectedArgument();
            return true;
        }
        if (cmdLine.next(new String[]{"remove repo", "rr"}) != null) {
            String repositoryName = null;
            String parent = null;
            block28: while (cmdLine.hasNext()) {
                NutsArgument a = cmdLine.peek();
                boolean enabled = a.isEnabled();
                switch (a.getStringKey()) {
                    case "--name": {
                        String val = cmdLine.nextString(new String[0]).getStringValue();
                        if (!enabled) continue block28;
                        repositoryName = val;
                        continue block28;
                    }
                    case "--parent": {
                        String val = cmdLine.nextString(new String[0]).getStringValue();
                        if (!enabled) continue block28;
                        parent = val;
                        continue block28;
                    }
                }
                if (session.configureFirst(cmdLine)) continue;
                if (a.isOption()) {
                    cmdLine.unexpectedArgument();
                    continue;
                }
                if (repositoryName != null) {
                    cmdLine.unexpectedArgument();
                    continue;
                }
                repositoryName = cmdLine.next().getString();
            }
            if (repositoryName == null) {
                cmdLine.required();
            }
            if (cmdLine.isExecMode()) {
                if (parent == null) {
                    ws.repos().removeRepository(repositoryName);
                } else {
                    NutsRepository p = ws.repos().getRepository(parent);
                    p.config().removeMirror(repositoryName);
                }
                session.getWorkspace().config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"list repos", "lr"}) != null) {
            cmdLine.setCommandName("config list repos");
            String parent = null;
            while (cmdLine.hasNext()) {
                block30: while (cmdLine.hasNext()) {
                    NutsArgument a = cmdLine.peek();
                    boolean enabled = a.isEnabled();
                    switch (a.getStringKey()) {
                        case "--parent": {
                            String val = cmdLine.nextString(new String[0]).getStringValue();
                            if (!enabled) continue block30;
                            parent = val;
                            continue block30;
                        }
                    }
                    if (session.configureFirst(cmdLine)) continue;
                    if (a.isOption()) {
                        cmdLine.unexpectedArgument();
                        continue;
                    }
                    if (parent != null) {
                        cmdLine.unexpectedArgument();
                        continue;
                    }
                    parent = cmdLine.next().getString();
                }
            }
            if (cmdLine.isExecMode()) {
                NutsRepository[] r = parent == null ? ws.repos().getRepositories() : ws.repos().getRepository(parent).config().getMirrors();
                session.getWorkspace().formats().object((Object)Arrays.stream(ws.repos().getRepositories()).map(x -> NutsSettingsRepositorySubCommand.repoInfo(x, session.getOutputFormat() != NutsContentType.TABLE && session.getOutputFormat() != NutsContentType.PLAIN, session)).toArray()).println(out);
            }
            return true;
        }
        if (cmdLine.next(new String[]{"enable repo", "er"}) != null) {
            this.enableRepo(cmdLine, autoSave, session, ws, true);
            return true;
        }
        if (cmdLine.next(new String[]{"disable repo", "er"}) != null) {
            this.enableRepo(cmdLine, autoSave, session, ws, true);
            return true;
        }
        if (cmdLine.next(new String[]{"edit repo", "er"}) != null) {
            String repoId = cmdLine.required().nextNonOption(commandLineFormat.createName("RepositoryName")).getString();
            if (cmdLine.next(new String[]{"add repo", "ar"}) != null) {
                String repositoryName = cmdLine.required().nextNonOption(commandLineFormat.createName("NewRepositoryName")).getString();
                String location = cmdLine.required().nextNonOption(commandLineFormat.createName("folder")).getString();
                String repoType = cmdLine.nextNonOption(commandLineFormat.createName("repository-type")).getString();
                NutsRepository editedRepo = ws.repos().getRepository(repoId);
                NutsRepository repo = editedRepo.config().addMirror(new NutsAddRepositoryOptions().setName(repositoryName).setLocation(repositoryName).setConfig(new NutsRepositoryConfig().setName(repositoryName).setLocation(location).setType(repoType)));
                session.getWorkspace().config().save();
            } else if (cmdLine.next(new String[]{"remove repo", "rr"}) != null) {
                String location = cmdLine.required().nextNonOption(commandLineFormat.createName("RepositoryName")).getString();
                NutsRepository editedRepo = ws.repos().getRepository(repoId);
                editedRepo.config().removeMirror(location);
                session.getWorkspace().config().save();
            } else if (cmdLine.next(new String[]{"enable", "br"}) != null) {
                NutsRepository editedRepo = ws.repos().getRepository(repoId);
                editedRepo.config().setEnabled(true);
                session.getWorkspace().config().save();
            } else if (cmdLine.next(new String[]{"disable", "dr"}) != null) {
                NutsRepository editedRepo = ws.repos().getRepository(repoId);
                editedRepo.config().setEnabled(true);
                session.getWorkspace().config().save();
            } else if (cmdLine.next(new String[]{"list repos", "lr"}) != null) {
                NutsRepository editedRepo = ws.repos().getRepository(repoId);
                NutsRepository[] linkRepositories = editedRepo.config().setSession(session).isSupportedMirroring() ? editedRepo.config().setSession(session).getMirrors() : new NutsRepository[]{};
                out.printf("%s sub repositories.%n", new Object[]{linkRepositories.length});
                NutsTableFormat t = ws.formats().table();
                NutsMutableTableModel m = t.createModel();
                t.setValue((Object)m);
                m.addHeaderCells(new Object[]{"Id", "Enabled", "Type", "Location"});
                while (cmdLine.hasNext()) {
                    if (t.configureFirst(cmdLine)) continue;
                    cmdLine.setCommandName("config edit repo").unexpectedArgument();
                }
                for (NutsRepository repository : linkRepositories) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = ws.text().forStyled(repository.getName(), NutsTextStyle.primary4());
                    objectArray[1] = repository.config().isEnabled() ? (repository.isEnabled() ? ws.text().forStyled("ENABLED", NutsTextStyle.success()) : ws.text().forStyled("<RT-DISABLED>", NutsTextStyle.error())) : ws.text().forStyled("<DISABLED>", NutsTextStyle.error());
                    objectArray[2] = repository.getRepositoryType();
                    objectArray[3] = repository.config().getLocation(false);
                    m.addRow(objectArray);
                }
                out.printf(t.toString(), new Object[0]);
            } else if (cmdLine.next(new String[]{"-h", "-?", "--help"}) != null) {
                out.printf("edit repository %s add repo ...%n", new Object[]{repoId});
                out.printf("edit repository %s remove repo ...%n", new Object[]{repoId});
                out.printf("edit repository %s list repos ...%n", new Object[]{repoId});
            } else {
                NutsRepository editedRepo = ws.repos().getRepository(repoId);
                if (!NutsSettingsUserSubCommand.exec(editedRepo, cmdLine, autoSave, session)) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"config edit repo: Unsupported command %s", (Object[])new Object[]{cmdLine}));
                }
            }
            return true;
        }
        return false;
    }

    private void enableRepo(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session, NutsWorkspace ws, boolean enableRepo) {
        String repositoryName = null;
        block6: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            boolean enabled = a.isEnabled();
            switch (a.getStringKey()) {
                case "--name": {
                    String val = cmdLine.nextString(new String[0]).getStringValue();
                    if (!enabled) continue block6;
                    repositoryName = val;
                    continue block6;
                }
            }
            if (session.configureFirst(cmdLine)) continue;
            if (a.isOption()) {
                cmdLine.unexpectedArgument();
                continue;
            }
            if (repositoryName == null) {
                repositoryName = cmdLine.next().getString();
                continue;
            }
            cmdLine.unexpectedArgument();
        }
        if (repositoryName == null) {
            cmdLine.required();
        }
        if (cmdLine.isExecMode()) {
            NutsRepository editedRepo = ws.repos().getRepository(repositoryName);
            editedRepo.config().setEnabled(enableRepo);
            session.getWorkspace().config().save();
        }
    }

    public static class RepoInfo {
        String name;
        String type;
        String location;
        boolean enabled;
        RepoInfo[] mirrors;

        public RepoInfo(String name, String type, String location, boolean enabled, RepoInfo[] mirrors) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.enabled = enabled;
            this.mirrors = mirrors;
        }

        public RepoInfo() {
        }

        public RepoInfo[] getMirrors() {
            return this.mirrors;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

