/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;

public class NutsSettingsJavaSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (autoSave == null) {
            autoSave = false;
        }
        NutsWorkspace ws = session.getWorkspace();
        NutsPrintStream out = session.out();
        NutsWorkspaceConfigManager conf = ws.config();
        if (cmdLine.next(new String[]{"add java"}) != null) {
            if (cmdLine.next(new String[]{"--search"}) != null) {
                ArrayList<String> extraLocations = new ArrayList<String>();
                while (cmdLine.hasNext()) {
                    extraLocations.add(cmdLine.next().getString());
                }
                if (extraLocations.isEmpty()) {
                    for (NutsSdkLocation loc : ws.sdks().searchSystem("java")) {
                        ws.sdks().add(loc);
                    }
                } else {
                    for (String extraLocation : extraLocations) {
                        for (NutsSdkLocation loc : ws.sdks().searchSystem("java", extraLocation)) {
                            ws.sdks().add(loc);
                        }
                    }
                }
                cmdLine.setCommandName("config java").unexpectedArgument();
                if (autoSave.booleanValue()) {
                    conf.save(false);
                }
            } else {
                while (cmdLine.hasNext()) {
                    NutsSdkLocation loc = ws.sdks().resolve("java", cmdLine.next().getString(), null);
                    if (loc == null) continue;
                    ws.sdks().add(loc);
                }
                if (autoSave.booleanValue()) {
                    conf.save(false);
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"remove java"}) != null) {
            while (cmdLine.hasNext()) {
                String name = cmdLine.next().getString();
                NutsSdkLocation loc = ws.sdks().findByName("java", name);
                if (loc == null && (loc = ws.sdks().findByPath("java", name)) == null) {
                    loc = ws.sdks().findByVersion("java", name);
                }
                if (loc == null) continue;
                ws.sdks().remove(loc);
            }
            if (autoSave.booleanValue()) {
                conf.save(false);
            }
            return true;
        }
        if (cmdLine.next(new String[]{"list java"}) != null) {
            NutsTableFormat t = session.getWorkspace().formats().table().setVisibleHeader(true);
            NutsMutableTableModel m = t.createModel();
            t.setValue((Object)m);
            m.addHeaderCells(new Object[]{"Name", "Version", "Path"});
            while (cmdLine.hasNext()) {
                if (t.configureFirst(cmdLine)) continue;
                cmdLine.setCommandName("config list java").unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                NutsSdkLocation[] sdks = ws.sdks().find("java", null);
                Arrays.sort(sdks, new Comparator<NutsSdkLocation>(){

                    @Override
                    public int compare(NutsSdkLocation o1, NutsSdkLocation o2) {
                        int x = o1.getName().compareTo(o2.getName());
                        if (x != 0) {
                            return x;
                        }
                        x = o1.getVersion().compareTo(o2.getVersion());
                        if (x != 0) {
                            return x;
                        }
                        x = o1.getPath().compareTo(o2.getPath());
                        if (x != 0) {
                            return x;
                        }
                        return x;
                    }
                });
                for (NutsSdkLocation jloc : sdks) {
                    m.addRow(new Object[]{jloc.getName(), jloc.getVersion(), jloc.getPath()});
                }
                out.print(t.format());
            }
            return true;
        }
        return false;
    }
}

