/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;

public class NutsSettingsDeleteFoldersSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        for (NutsStoreLocation value : NutsStoreLocation.values()) {
            String cmdName = "delete " + value.id();
            cmdLine.setCommandName("settings " + cmdName);
            if (cmdLine.next(new String[]{cmdName}) == null) continue;
            boolean force = false;
            HashSet<NutsStoreLocation> locationsToDelete = new HashSet<NutsStoreLocation>();
            locationsToDelete.add(value);
            while (cmdLine.hasNext()) {
                NutsArgument a = cmdLine.nextBoolean(new String[]{"-y", "--yes"});
                if (a != null) {
                    force = a.getBooleanValue();
                    continue;
                }
                if (!cmdLine.peek().isOption()) {
                    String s = cmdLine.peek().toString();
                    try {
                        locationsToDelete.add(NutsStoreLocation.valueOf((String)s.toUpperCase()));
                    }
                    catch (Exception ex) {
                        cmdLine.unexpectedArgument();
                    }
                    continue;
                }
                cmdLine.unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                for (NutsStoreLocation folder : locationsToDelete) {
                    this.deleteWorkspaceFolder(session, folder, force);
                }
            }
            return true;
        }
        return false;
    }

    private void deleteWorkspaceFolder(NutsSession session, NutsStoreLocation folder, boolean force) {
        String sstoreLocation = session.getWorkspace().locations().getStoreLocation(folder);
        if (sstoreLocation != null) {
            NutsTextManager factory = session.getWorkspace().text();
            Path storeLocation = Paths.get(sstoreLocation, new String[0]);
            if (Files.exists(storeLocation, new LinkOption[0])) {
                session.out().printf("```error deleting``` %s for workspace %s folder %s ...%n", new Object[]{factory.forStyled(folder.id(), NutsTextStyle.primary1()), factory.forStyled(session.getWorkspace().getName(), NutsTextStyle.primary1()), factory.forStyled(storeLocation.toString(), NutsTextStyle.path())});
                if (force || session.getTerminal().ask().resetLine().forBoolean("force delete?", new Object[0]).setDefaultValue((Object)false).setSession(session).getBooleanValue().booleanValue()) {
                    try {
                        Files.delete(storeLocation);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        }
        for (NutsRepository repository : session.getWorkspace().repos().getRepositories()) {
            this.deleteRepoFolder(repository, session, folder, force);
        }
    }

    private void deleteRepoFolder(NutsRepository repository, NutsSession session, NutsStoreLocation folder, boolean force) {
        String sstoreLocation = session.getWorkspace().locations().getStoreLocation(folder);
        if (sstoreLocation != null) {
            Path storeLocation = Paths.get(sstoreLocation, new String[0]);
            NutsTextManager factory = session.getWorkspace().text();
            if (Files.exists(storeLocation, new LinkOption[0])) {
                session.out().printf("```error deleting``` %s for repository %s folder %s ...%n", new Object[]{factory.forStyled(folder.id(), NutsTextStyle.primary1()), factory.forStyled(repository.getName(), NutsTextStyle.primary1()), factory.forStyled(storeLocation.toString(), NutsTextStyle.path())});
                if (force || session.getTerminal().ask().resetLine().forBoolean("Force Delete?", new Object[0]).setDefaultValue((Object)false).setSession(session).getBooleanValue().booleanValue()) {
                    try {
                        Files.delete(storeLocation);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        }
        if (repository.config().isSupportedMirroring()) {
            for (NutsRepository subRepository : repository.config().getMirrors()) {
                NutsSettingsDeleteFoldersSubCommand.deleteRepoCache(subRepository, session, force);
            }
        }
    }

    private void deleteCache(NutsSession session, boolean force) {
        String sstoreLocation = session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.CACHE);
        if (sstoreLocation != null) {
            Path storeLocation = Paths.get(sstoreLocation, new String[0]);
            if (Files.exists(storeLocation, new LinkOption[0])) {
                try {
                    Files.delete(storeLocation);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            for (NutsRepository repository : session.getWorkspace().repos().getRepositories()) {
                NutsSettingsDeleteFoldersSubCommand.deleteRepoCache(repository, session, force);
            }
        }
    }

    private static void deleteRepoCache(NutsRepository repository, NutsSession session, boolean force) {
        Path s = Paths.get(repository.config().getStoreLocation(NutsStoreLocation.CACHE), new String[0]);
        if (s != null && Files.exists(s, new LinkOption[0])) {
            session.out().printf("```error deleting``` %s folder %s ...%n", new Object[]{session.getWorkspace().text().forStyled("cache", NutsTextStyle.primary1()), s});
            if (force || session.getTerminal().ask().resetLine().forBoolean("force delete?", new Object[0]).setDefaultValue((Object)false).setSession(session).getBooleanValue().booleanValue()) {
                try {
                    Files.delete(s);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
        if (repository.config().isSupportedMirroring()) {
            for (NutsRepository mirror : repository.config().getMirrors()) {
                NutsSettingsDeleteFoldersSubCommand.deleteRepoCache(mirror, session, force);
            }
        }
    }
}

