/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultInternalNutsExecutableCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.NutsSettingsSubCommand;

public class DefaultNutsSettingsInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    private List<NutsSettingsSubCommand> subCommands;

    public DefaultNutsSettingsInternalExecutable(String[] args, NutsSession session) {
        super("fetch", args, session);
    }

    @Override
    public void execute() {
        NutsArgument a;
        Boolean autoSave = true;
        NutsCommandLine cmd = this.getSession().getWorkspace().commandLine().create(this.args);
        boolean empty = true;
        while ((a = cmd.peek()) != null) {
            boolean enabled = a.isEnabled();
            if (a.isOption() && (a.getStringKey().equals("-?") || a.getStringKey().equals("-h") || a.getStringKey().equals("-help"))) {
                cmd.skip();
                if (!enabled) break;
                if (cmd.isExecMode()) {
                    this.showDefaultHelp();
                }
                cmd.skipAll();
                throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"help", (Object[])new Object[0]), 0);
            }
            NutsSettingsSubCommand selectedSubCommand = null;
            for (NutsSettingsSubCommand subCommand : this.getSubCommands()) {
                if (!subCommand.exec(cmd, autoSave, this.getSession())) continue;
                selectedSubCommand = subCommand;
                empty = false;
                break;
            }
            if (selectedSubCommand != null) {
                if (!cmd.isExecMode()) {
                    return;
                }
                if (!cmd.hasNext()) break;
                NutsPrintStream out = this.getSession().err();
                out.printf("unexpected %s%n", new Object[]{cmd.peek()});
                out.printf("type for more help : nuts settings -h%n", new Object[0]);
                throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"unexpected %s", (Object[])new Object[]{cmd.peek()}), 1);
            }
            this.getSession().configureLast(cmd);
            if (cmd.hasNext()) continue;
        }
        if (empty) {
            NutsPrintStream out = this.getSession().err();
            out.printf("missing settings command%n", new Object[0]);
            out.printf("type for more help : nuts settings -h%n", new Object[0]);
            throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"missing settings command", (Object[])new Object[0]), 1);
        }
    }

    public List<NutsSettingsSubCommand> getSubCommands() {
        if (this.subCommands == null) {
            this.subCommands = new ArrayList<NutsSettingsSubCommand>(this.getSession().getWorkspace().extensions().createAllSupported(NutsSettingsSubCommand.class, (Object)this));
        }
        return this.subCommands;
    }
}

