/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCommand;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public abstract class NutsWorkspaceCommandBase<T extends NutsWorkspaceCommand>
implements NutsWorkspaceCommand {
    protected NutsWorkspace ws;
    protected NutsSession session;
    private final String commandName;
    private NutsLogger LOG;

    public NutsWorkspaceCommandBase(NutsWorkspace ws, String commandName) {
        this.ws = ws;
        this.commandName = commandName;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.getWorkspace().log().setSession(session).of(this.getClass());
        }
        return this.LOG;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.getSession());
    }

    public String getCommandName() {
        return this.commandName;
    }

    protected T copyFromWorkspaceCommandBase(NutsWorkspaceCommandBase other) {
        if (other != null) {
            this.setSession(other.getSession());
        }
        return (T)this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public T setSession(NutsSession session) {
        this.session = session;
        return (T)this;
    }

    public T copySession() {
        NutsSession s = this.getSession();
        if (s != null) {
            s = s.copy();
        }
        return this.setSession(s);
    }

    protected void invalidateResult() {
    }

    protected NutsWorkspace getWorkspace() {
        return this.ws;
    }

    protected void setWs(NutsWorkspace ws) {
        this.ws = ws;
        this.invalidateResult();
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        this.checkSession();
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        return this.getSession().configureFirst(cmdLine);
    }

    public T configure(boolean skipUnsupported, String ... args) {
        this.checkSession();
        return (T)((NutsWorkspaceCommand)NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, args, this.getCommandName()));
    }

    public boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        this.checkSession();
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, commandLine);
    }
}

