/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutableInformation;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultInternalNutsExecutableCommand;

public class DefaultNutsWhichInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    private final NutsExecCommand execCommand;

    public DefaultNutsWhichInternalExecutable(String[] args, NutsSession session, NutsExecCommand execCommand) {
        super("which", args, session);
        this.execCommand = execCommand;
    }

    @Override
    public void execute() {
        if (CoreNutsUtils.isIncludesHelpOption(this.args)) {
            this.showDefaultHelp();
            return;
        }
        ArrayList<String> commands = new ArrayList<String>();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsCommandLine commandLine = ws.commandLine().create(this.args);
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.peek();
            if (a.isOption()) {
                switch (a.getStringKey()) {
                    case "--help": {
                        commandLine.skipAll();
                        this.showDefaultHelp();
                        return;
                    }
                }
                this.getSession().configureLast(commandLine);
                continue;
            }
            commandLine.skip();
            commands.add(a.toString());
            commands.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
        }
        if (commands.isEmpty()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"which: missing commands", (Object[])new Object[0]));
        }
        NutsTextManager factory = ws.text();
        for (String arg : this.args) {
            NutsElementFormat e;
            NutsPrintStream out = this.getSession().out();
            try {
                NutsExecutableInformation p = this.execCommand.copy().setSession(this.getSession()).clearCommand().configure(false, new String[]{arg}).which();
                e = this.getSession().getWorkspace().elem();
                switch (p.getType()) {
                    case SYSTEM: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %s%n", new Object[]{factory.forStyled(arg, NutsTextStyle.primary4()), factory.forStyled("system command", NutsTextStyle.primary6()), p.getDescription()});
                            break;
                        }
                        this.getSession().eout().add((NutsElement)e.forObject().set("name", arg).set("type", "system-command").set("description", p.getDescription()).build());
                        break;
                    }
                    case ALIAS: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s (owner %s ) : %s%n", new Object[]{factory.forStyled(arg, NutsTextStyle.primary4()), factory.forStyled("nuts alias", NutsTextStyle.primary6()), p.getId(), ws.commandLine().create(ws.commands().findCommand(p.getName()).getCommand())});
                            break;
                        }
                        this.getSession().eout().add((NutsElement)e.forObject().set("name", arg).set("type", "alias").set("description", p.getDescription()).set("id", p.getId().toString()).build());
                        break;
                    }
                    case ARTIFACT: {
                        if (p.getId() == null) {
                            NutsId nid = this.getSession().getWorkspace().id().parser().setLenient(true).parse(arg);
                            if (nid != null) {
                                throw new NutsNotFoundException(this.getSession(), nid);
                            }
                            throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"artifact not found: %s%s", (Object[])new Object[]{arg == null ? "<null>" : arg}));
                        }
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %s%n", new Object[]{factory.forStyled(arg, NutsTextStyle.primary4()), factory.forStyled("artifact", NutsTextStyle.primary6()), p.getId()});
                            break;
                        }
                        this.getSession().eout().add((NutsElement)e.forObject().set("name", arg).set("type", "artifact").set("id", p.getId().toString()).set("description", p.getDescription()).build());
                        break;
                    }
                    case INTERNAL: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %n", new Object[]{factory.forStyled("internal command", NutsTextStyle.primary6()), factory.forStyled(arg, NutsTextStyle.primary4())});
                            break;
                        }
                        this.getSession().eout().add((NutsElement)e.forObject().set("name", arg).set("type", "internal-command").set("description", p.getDescription()).build());
                    }
                }
            }
            catch (NutsNotFoundException ex) {
                if (this.getSession().isPlainOut()) {
                    out.printf("%s : %s%n", new Object[]{factory.forStyled(arg, NutsTextStyle.primary4()), factory.forStyled("not found", NutsTextStyle.error())});
                    continue;
                }
                e = this.getSession().getWorkspace().elem();
                this.getSession().eout().add((NutsElement)e.forObject().set("name", arg).set("type", "not-found").build());
            }
        }
    }
}

