/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultInternalNutsExecutableCommand;

public class DefaultNutsWelcomeInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    public DefaultNutsWelcomeInternalExecutable(String[] args, NutsSession session) {
        super("welcome", args, session);
    }

    @Override
    public void execute() {
        if (CoreNutsUtils.isIncludesHelpOption(this.args)) {
            this.showDefaultHelp();
            return;
        }
        NutsSession session = this.getSession();
        NutsWorkspace ws = session.getWorkspace();
        NutsCommandLine commandLine = ws.commandLine().create(this.args);
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.peek();
            if (a.isOption()) {
                switch (a.getStringKey()) {
                    case "--help": {
                        commandLine.skipAll();
                        this.showDefaultHelp();
                        return;
                    }
                }
                this.getSession().configureLast(commandLine);
                continue;
            }
            this.getSession().configureLast(commandLine);
        }
        if (!session.isBot() && session.isPlainOut()) {
            session.out().resetLine().println(NutsWorkspaceExt.of(ws).getWelcomeText(session));
        } else {
            LinkedHashMap<String, String> welcome = new LinkedHashMap<String, String>();
            welcome.put("message", "Welcome to nuts. Yeah, it is working...");
            welcome.put("name", (String)ws.text().forStyled("nuts", NutsTextStyle.primary((int)1)));
            welcome.put("long-name", "Network Updatable Things Services");
            welcome.put("description", "The Free and Open Source Package Manager for Java (TM) and other Things ...");
            welcome.put("url", (String)ws.io().path("http://github.com/thevpc/nuts"));
            welcome.put("author", "thevpc");
            welcome.put("api-id", (String)ws.getApiId().builder().setVersion("").build());
            welcome.put("api-version", (String)ws.getApiVersion());
            welcome.put("runtime-id", (String)ws.getRuntimeId().builder().setVersion("").build());
            welcome.put("runtime-version", (String)ws.getRuntimeId().getVersion());
            welcome.put("workspace", (String)ws.io().path(ws.locations().getWorkspaceLocation()));
            welcome.put("hash-name", (String)ws.io().path(ws.getHashName()));
            if (session.isPlainOut()) {
                session = session.copy().setOutputFormat(NutsContentType.PROPS);
            }
            session.out().resetLine();
            session.getWorkspace().formats().object(welcome).println();
        }
    }
}

