/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnexpectedException;
import net.thevpc.nuts.NutsUpdateCommand;
import net.thevpc.nuts.NutsUpdateResult;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceUpdateResult;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.commands.ws.DefaultNutsUpdateResult;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.repos.NutsInstalledRepository;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspaceUpdateResult;
import net.thevpc.nuts.runtime.standalone.NutsExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsUpdateCommand;

public class DefaultNutsUpdateCommand
extends AbstractNutsUpdateCommand {
    private Comparator<NutsId> LATEST_VERSION_FIRST = (x, y) -> -x.getVersion().compareTo(y.getVersion());
    private Comparator<NutsId> DEFAULT_THEN_LATEST_VERSION_FIRST = (x, y) -> {
        int yi;
        NutsInstalledRepository rr = NutsWorkspaceExt.of(this.ws).getInstalledRepository();
        int xi = rr.isDefaultVersion((NutsId)x, this.session) ? 0 : 1;
        int v = Integer.compare(xi, yi = rr.isDefaultVersion((NutsId)y, this.session) ? 0 : 1);
        if (v != 0) {
            return v;
        }
        return -x.getVersion().compareTo(y.getVersion());
    };
    private boolean checkFixes = false;
    private List<FixAction> resultFixes = null;

    public DefaultNutsUpdateCommand(NutsWorkspace ws) {
        super(ws);
    }

    @Override
    public int getResultCount() {
        return this.getResult().getUpdatesCount();
    }

    @Override
    public NutsWorkspaceUpdateResult getResult() {
        this.checkSession();
        if (this.result == null) {
            this.checkUpdates();
        }
        if (this.result == null) {
            throw new NutsUnexpectedException(this.getSession());
        }
        return this.result;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "--check-fixes": {
                cmdLine.skip();
                if (enabled) {
                    this.checkFixes = true;
                }
                return true;
            }
        }
        return super.configureFirst(cmdLine);
    }

    public NutsUpdateCommand update() {
        this.applyResult(this.getResult());
        return this;
    }

    public NutsUpdateCommand checkUpdates() {
        NutsUpdateResult updated;
        NutsVersion bootVersion0;
        if (this.checkFixes) {
            this.checkFixes();
            this.traceFixes();
        }
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        Instant now = this.expireTime == null ? Instant.now() : this.expireTime;
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        NutsSession session = NutsWorkspaceUtils.of(this.getSession()).validateSession(this.getSession());
        LinkedHashMap<String, NutsUpdateResult> allUpdates = new LinkedHashMap<String, NutsUpdateResult>();
        LinkedHashMap<String, NutsUpdateResult> extUpdates = new LinkedHashMap<String, NutsUpdateResult>();
        HashMap<String, NutsUpdateResult> regularUpdates = new HashMap<String, NutsUpdateResult>();
        NutsUpdateResult apiUpdate = null;
        NutsVersion bootVersion = bootVersion0 = ws.getApiVersion();
        if (this.getApiVersion() != null && !this.getApiVersion().isBlank()) {
            bootVersion = this.getApiVersion();
        }
        if (this.isApi() || this.getApiVersion() != null && !this.getApiVersion().isBlank()) {
            apiUpdate = this.checkCoreUpdate(ws.id().parser().parse("net.thevpc.nuts:nuts"), this.getApiVersion(), session, Type.API, now);
            if (apiUpdate.isUpdateAvailable()) {
                bootVersion = apiUpdate.getAvailable().getId().getVersion();
                allUpdates.put("net.thevpc.nuts:nuts", apiUpdate);
            } else {
                bootVersion = bootVersion0;
            }
        }
        NutsUpdateResult runtimeUpdate = null;
        if (this.isRuntime() && dws.requiresRuntimeExtension(session) && (runtimeUpdate = this.checkCoreUpdate(ws.id().parser().parse(ws.getRuntimeId().getShortName()), apiUpdate != null && apiUpdate.getAvailable().getId() != null ? apiUpdate.getAvailable().getId().getVersion() : bootVersion, session, Type.RUNTIME, now)).isUpdateAvailable()) {
            allUpdates.put(runtimeUpdate.getId().getShortName(), runtimeUpdate);
        }
        if (this.isExtensions()) {
            for (NutsId d : this.getExtensionsToUpdate()) {
                updated = this.checkRegularUpdate(d, Type.EXTENSION, bootVersion, now, this.expireTime != null);
                allUpdates.put(updated.getId().getShortName(), updated);
                extUpdates.put(updated.getId().getShortName(), updated);
            }
        }
        if (this.isCompanions()) {
            for (NutsId d : this.getCompanionsToUpdate()) {
                updated = this.checkRegularUpdate(d, Type.COMPANION, bootVersion, now, this.expireTime != null);
                allUpdates.put(updated.getId().getShortName(), updated);
                regularUpdates.put(updated.getId().getShortName(), updated);
            }
        }
        for (NutsId id : this.getRegularIds()) {
            updated = this.checkRegularUpdate(id, Type.REGULAR, null, now, this.expireTime != null);
            allUpdates.put(updated.getAvailable().getId().getShortName(), updated);
            regularUpdates.put(updated.getId().getShortName(), updated);
        }
        NutsId[] lockedIds = this.getLockedIds();
        if (lockedIds.length > 0) {
            for (NutsId d : new HashSet<NutsId>(Arrays.asList(lockedIds))) {
                NutsDependency dd = ws.dependency().parser().parseDependency(d.toString());
                if (!regularUpdates.containsKey(dd.getSimpleName())) continue;
                NutsUpdateResult updated2 = (NutsUpdateResult)regularUpdates.get(dd.getSimpleName());
                if (dd.getVersion().filter().acceptVersion(updated2.getId().getVersion(), session)) continue;
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"%s unsatisfied  : %s", (Object[])new Object[]{dd, updated2.getId().getVersion()}));
            }
        }
        this.result = new DefaultNutsWorkspaceUpdateResult(apiUpdate, runtimeUpdate, extUpdates.values().toArray(new NutsUpdateResult[0]), regularUpdates.values().toArray(new NutsUpdateResult[0]));
        this.traceUpdates(this.result);
        return this;
    }

    private Set<NutsId> getExtensionsToUpdate() {
        HashSet<NutsId> ext = new HashSet<NutsId>();
        for (NutsId extension : this.getSession().getWorkspace().extensions().getConfigExtensions()) {
            ext.add(extension.getShortNameId());
        }
        if (this.updateExtensions) {
            return ext;
        }
        HashSet<NutsId> ext2 = new HashSet<NutsId>();
        for (NutsId id : this.ids) {
            if (id.getShortName().equals("net.thevpc.nuts:nuts") || id.getShortName().equals(this.ws.getRuntimeId().getShortName()) || !ext.contains(id.getShortNameId())) continue;
            ext2.add(id.getShortNameId());
        }
        return ext2;
    }

    private Set<NutsId> getCompanionsToUpdate() {
        HashSet<NutsId> ext = new HashSet<NutsId>();
        for (NutsId extension : this.ws.getCompanionIds(this.session)) {
            ext.add(extension.getShortNameId());
        }
        return ext;
    }

    private Set<NutsId> getRegularIds() {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        HashSet<String> extensions = new HashSet<String>();
        for (NutsId object : this.getSession().getWorkspace().extensions().getConfigExtensions()) {
            extensions.add(object.getShortName());
        }
        HashSet<NutsId> baseRegulars = new HashSet<NutsId>(this.ids);
        if (this.isInstalled()) {
            baseRegulars.addAll(ws.search().setSession(CoreNutsUtils.silent(this.getSession())).setInstallStatus(ws.filters().installStatus().byInstalled(true)).getResultIds().stream().map(NutsId::getShortNameId).collect(Collectors.toList()));
            NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
            NutsInstalledRepository ir = dws.getInstalledRepository();
            for (NutsInstallInformation y : IteratorUtils.toList(ir.searchInstallInformation(this.session))) {
                if (y == null || !y.getInstallStatus().isInstalled() || y.getId() == null) continue;
                baseRegulars.add(y.getId().builder().setVersion("").build());
            }
        }
        HashSet<NutsId> regulars = new HashSet<NutsId>();
        for (NutsId id : baseRegulars) {
            if (id.getShortName().equals("net.thevpc.nuts:nuts") || id.getShortName().equals(ws.getRuntimeId().getShortName()) || extensions.contains(id.getShortName())) continue;
            regulars.add(id);
        }
        return regulars;
    }

    public NutsUpdateCommand checkFixes() {
        this.resultFixes = null;
        this.checkSession();
        final NutsWorkspace ws = this.getSession().getWorkspace();
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        NutsInstalledRepository ir = dws.getInstalledRepository();
        NutsSession session = NutsWorkspaceUtils.of(this.getSession()).validateSession(this.getSession());
        this.resultFixes = IteratorUtils.toList(IteratorUtils.convertNonNull(ir.searchInstallInformation(session), new Function<NutsInstallInformation, FixAction>(){

            @Override
            public FixAction apply(NutsInstallInformation nutsInstallInformation) {
                NutsId id = (NutsId)ws.search().setInstallStatus(ws.filters().installStatus().byInstalled(true)).addId(nutsInstallInformation.getId()).getResultIds().first();
                if (id == null) {
                    return new FixAction(nutsInstallInformation.getId(), "MissingInstallation"){

                        @Override
                        public void fix(NutsSession session) {
                            session.getWorkspace().install().addId(this.getId()).run();
                        }
                    };
                }
                return null;
            }
        }, "CheckFixes"));
        return this;
    }

    protected void traceFixes() {
        if (this.resultFixes != null) {
            NutsPrintStream out = this.getSession().out();
            for (FixAction n : this.resultFixes) {
                out.printf("[```error FIX```] %s %s %n", new Object[]{n.getId(), n.getProblemKey()});
            }
        }
    }

    protected void traceUpdates(NutsWorkspaceUpdateResult result) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (this.getSession().isPlainTrace()) {
            NutsPrintStream out = this.getSession().out();
            NutsUpdateResult[] updates = result.getAllUpdates();
            if (updates.length == 0) {
                out.printf("All packages are %s. You are running latest version%s.%n", new Object[]{ws.text().forStyled("up-to-date", NutsTextStyle.success()), result.getAllResults().length > 1 ? "s" : ""});
            } else {
                out.printf("Workspace has %s package%s to update.%n", new Object[]{ws.text().forStyled("" + updates.length, NutsTextStyle.primary1()), updates.length > 1 ? "s" : ""});
                int widthCol1 = 2;
                int widthCol2 = 2;
                for (NutsUpdateResult update : updates) {
                    widthCol1 = Math.max(widthCol1, update.getAvailable().getId().getShortName().length());
                    widthCol2 = Math.max(widthCol2, update.getLocal().getId().getVersion().toString().length());
                }
                NutsTextManager factory = ws.text();
                for (NutsUpdateResult update : updates) {
                    if (update.isUpdateVersionAvailable()) {
                        out.printf("%s  : %s => %s%n", new Object[]{factory.forStyled(CoreStringUtils.alignLeft(update.getLocal().getId().getVersion().toString(), widthCol2), NutsTextStyle.primary6()), CoreStringUtils.alignLeft(update.getAvailable().getId().getShortName(), widthCol1), factory.forPlain(update.getAvailable().getId().getVersion().toString())});
                        continue;
                    }
                    if (!update.isUpdateStatusAvailable()) continue;
                    out.printf("%s  : %s => %s%n", new Object[]{factory.forStyled(CoreStringUtils.alignLeft(update.getLocal().getId().getVersion().toString(), widthCol2), NutsTextStyle.primary6()), CoreStringUtils.alignLeft(update.getAvailable().getId().getShortName(), widthCol1), factory.forStyled("set as default", NutsTextStyle.primary4())});
                }
            }
        }
    }

    private NutsFetchCommand latestOnlineDependencies(NutsFetchCommand se) {
        se.setDependencies(true);
        if (this.scopes.isEmpty()) {
            se.addScope(NutsDependencyScopePattern.RUN);
        } else {
            se.addScopes(this.scopes.toArray(new NutsDependencyScope[0]));
        }
        se.setOptional(this.isOptional() ? null : Boolean.valueOf(false)).setSession(se.getSession().copy().setFetchStrategy(NutsFetchStrategy.ONLINE));
        return se;
    }

    protected NutsUpdateResult checkRegularUpdate(NutsId id, Type type, NutsVersion targetApiVersion, Instant now, boolean updateEvenIfExisting) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsSession session = this.getSession();
        NutsVersion version = id.getVersion();
        if (!updateEvenIfExisting && version.isSingleValue()) {
            updateEvenIfExisting = session.getTerminal().ask().resetLine().setDefaultValue((Object)true).setSession(session).forBoolean("version is too restrictive. Do you intend to force update of %s ?", new Object[]{id}).getBooleanValue();
        }
        DefaultNutsUpdateResult r = new DefaultNutsUpdateResult();
        r.setId(id.getShortNameId());
        boolean shouldUpdateDefault = false;
        NutsDefinition d0 = (NutsDefinition)ws.search().addId(id).setSession(session).setInstallStatus(ws.filters().installStatus().byDeployed(true)).setOptional(Boolean.valueOf(false)).setFailFast(false).sort(this.DEFAULT_THEN_LATEST_VERSION_FIRST).getResultDefinitions().first();
        if (d0 == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"%s is not yet installed for it to be updated.", (Object[])new Object[]{id}));
        }
        if (!d0.getInstallInformation().isDefaultVersion()) {
            shouldUpdateDefault = true;
        }
        NutsSession newAnywhereSession = session.copy().setFetchStrategy(NutsFetchStrategy.ANYWHERE);
        if (updateEvenIfExisting) {
            newAnywhereSession.setExpireTime(now);
        }
        NutsSearchCommand sc = ws.search().addId(d0.getId().getShortNameId()).setSession(newAnywhereSession).setFailFast(false).setLatest(true).addLockedIds(this.getLockedIds()).addRepositoryFilter(ws.filters().repository().installedRepo().neg()).setDependencies(true).setOptional(this.isOptional() ? null : Boolean.valueOf(false));
        if (type == Type.EXTENSION) {
            sc.setExtension(true);
        } else if (type == Type.COMPANION) {
            sc.setCompanion(true);
        }
        if (targetApiVersion != null) {
            sc.setTargetApiVersion(targetApiVersion);
        }
        if (this.scopes.isEmpty()) {
            sc.addScope(NutsDependencyScopePattern.RUN);
        } else {
            sc.addScopes(this.scopes.toArray(new NutsDependencyScope[0]));
        }
        NutsDefinition d1 = (NutsDefinition)sc.getResultDefinitions().first();
        r.setLocal(d0);
        r.setAvailable(d1);
        if (d1 == null) {
            r.setAvailable(d0);
        } else {
            NutsVersion v0 = d0.getId().getVersion();
            NutsVersion v1 = d1.getId().getVersion();
            if (v1.compareTo(v0) <= 0) {
                if (updateEvenIfExisting) {
                    r.setUpdateForced(true);
                }
                if (shouldUpdateDefault) {
                    r.setUpdateStatusAvailable(true);
                }
            } else {
                r.setUpdateVersionAvailable(true);
            }
        }
        return r;
    }

    private NutsFetchCommand fetch0() {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        return ws.fetch().setContent(true).setEffective(true);
    }

    private void applyFixes() {
        if (this.resultFixes != null) {
            NutsSession session = this.getSession();
            NutsPrintStream out = session.out();
            for (FixAction n : this.resultFixes) {
                n.fix(session);
                out.printf("[```error FIX```] unable to %s %s %n", new Object[]{n.getId(), n.getProblemKey()});
            }
        }
    }

    private void applyResult(NutsWorkspaceUpdateResult result) {
        NutsId finalRuntimeId;
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        this.applyFixes();
        NutsUpdateResult apiUpdate = result.getApi();
        NutsUpdateResult runtimeUpdate = result.getRuntime();
        if (result.getUpdatesCount() == 0) {
            return;
        }
        NutsWorkspaceUtils.of(this.getSession()).checkReadOnly();
        boolean requireSave = false;
        NutsSession validWorkspaceSession = this.getSession();
        NutsPrintStream out = validWorkspaceSession.out();
        boolean accept = (Boolean)this.getSession().getWorkspace().term().getTerminal().ask().resetLine().forBoolean("would you like to apply updates?", new Object[0]).setDefaultValue((Object)true).setSession(validWorkspaceSession).getValue();
        if (validWorkspaceSession.isAsk() && !accept) {
            throw new NutsUserCancelException(this.getSession());
        }
        NutsWorkspaceConfigManagerExt wcfg = NutsWorkspaceConfigManagerExt.of(ws.config());
        boolean apiUpdateAvailable = apiUpdate != null && apiUpdate.getAvailable() != null && !apiUpdate.isUpdateApplied();
        boolean runtimeUpdateAvailable = runtimeUpdate != null && runtimeUpdate.getAvailable() != null && !runtimeUpdate.isUpdateApplied();
        boolean apiUpdateApplicable = apiUpdateAvailable && !apiUpdate.isUpdateApplied();
        boolean runtimeUpdateApplicable = runtimeUpdateAvailable && !runtimeUpdate.isUpdateApplied();
        NutsId finalApiId = apiUpdateAvailable ? apiUpdate.getAvailable().getId() : ws.getApiId();
        NutsId nutsId = finalRuntimeId = runtimeUpdateApplicable ? runtimeUpdate.getAvailable().getId() : ws.getRuntimeId();
        if (apiUpdateApplicable || runtimeUpdateApplicable) {
            wcfg.getModel().prepareBootApi(finalApiId, finalRuntimeId, true, validWorkspaceSession);
        }
        if (apiUpdateApplicable) {
            ((DefaultNutsUpdateResult)apiUpdate).setUpdateApplied(true);
            this.traceSingleUpdate(apiUpdate);
        }
        if (runtimeUpdateApplicable) {
            wcfg.getModel().prepareBootRuntime(finalRuntimeId, true, validWorkspaceSession);
        }
        if (runtimeUpdateApplicable) {
            ((DefaultNutsUpdateResult)runtimeUpdate).setUpdateApplied(true);
            this.traceSingleUpdate(runtimeUpdate);
        }
        for (NutsUpdateResult extension : result.getExtensions()) {
            NutsId finalExtensionId = extension.getAvailable() == null ? extension.getLocal().getId() : extension.getAvailable().getId();
            wcfg.getModel().prepareBootExtension(finalExtensionId, true, validWorkspaceSession);
        }
        NutsExtensionListHelper h = new NutsExtensionListHelper(wcfg.getModel().getStoredConfigBoot().getExtensions()).save();
        for (NutsUpdateResult extension : result.getExtensions()) {
            if (extension.isUpdateApplied()) continue;
            if (extension.getAvailable() != null) {
                h.add(extension.getAvailable().getId());
                if (h.hasChanged()) {
                    NutsWorkspaceExt.of(ws).deployBoot(validWorkspaceSession, extension.getAvailable().getId(), true);
                }
            }
            ((DefaultNutsUpdateResult)extension).setUpdateApplied(true);
            this.traceSingleUpdate(extension);
        }
        for (NutsUpdateResult component : result.getArtifacts()) {
            this.applyRegularUpdate((DefaultNutsUpdateResult)component);
        }
        if (ws.config().setSession(validWorkspaceSession).save(requireSave)) {
            if (this._LOG(this.session).isLoggable(Level.INFO)) {
                this._LOGOP(this.session).level(Level.INFO).verb(NutsLogVerb.WARNING).log("workspace is updated. Nuts should be restarted for changes to take effect.", new Object[0]);
            }
            if (apiUpdate != null && apiUpdate.isUpdateAvailable() && !apiUpdate.isUpdateApplied() && validWorkspaceSession.isPlainTrace()) {
                out.println("workspace is updated. Nuts should be restarted for changes to take effect.");
            }
        }
    }

    private void traceSingleUpdate(NutsUpdateResult r) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsId id = r.getId();
        NutsDefinition d0 = r.getLocal();
        NutsDefinition d1 = r.getAvailable();
        NutsId simpleId = d0 != null ? d0.getId().getShortNameId() : (d1 != null ? d1.getId().getShortNameId() : id.getShortNameId());
        NutsPrintStream out = this.getSession().out();
        NutsTextManager factory = ws.text();
        if (r.isUpdateApplied() && r.isUpdateForced()) {
            if (d0 == null) {
                out.resetLine().printf("%s is %s to latest version %s%n", new Object[]{simpleId, factory.forStyled("updated", NutsTextStyle.primary3()), d1 == null ? null : d1.getId().getVersion()});
            } else if (d1 != null) {
                NutsVersion v0 = d0.getId().getVersion();
                NutsVersion v1 = d1.getId().getVersion();
                if (v1.compareTo(v0) <= 0) {
                    if (v1.compareTo(v0) == 0) {
                        out.resetLine().printf("%s is %s to %s %n", new Object[]{simpleId, factory.forStyled("forced", NutsTextStyle.primary3()), d0.getId().getVersion()});
                    } else {
                        out.resetLine().printf("%s is %s from %s to older version %s%n", new Object[]{simpleId, factory.forStyled("forced", NutsTextStyle.primary3()), d0.getId().getVersion(), d1.getId().getVersion()});
                    }
                } else {
                    out.resetLine().printf("%s is %s from %s to latest version %s%n", new Object[]{simpleId, factory.forStyled("updated", NutsTextStyle.primary3()), d0.getId().getVersion(), d1.getId().getVersion()});
                }
            }
        }
    }

    public NutsUpdateResult checkCoreUpdate(NutsId id, NutsVersion bootApiVersion, NutsSession session, Type type, Instant now) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        session = NutsWorkspaceUtils.of(session).validateSilentSession(session);
        NutsId oldId = null;
        NutsDefinition oldFile = null;
        NutsDefinition newFile = null;
        NutsId newId = null;
        switch (type) {
            case API: {
                NutsVersion v;
                oldId = ws.config().stored().getApiId();
                NutsId confId = ws.config().stored().getApiId();
                if (confId != null) {
                    oldId = confId;
                }
                if ((v = bootApiVersion) == null || v.isBlank()) {
                    v = this.getSession().getWorkspace().version().parse("LATEST");
                }
                try {
                    oldFile = this.fetch0().setId(oldId).setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).getResultDefinition();
                }
                catch (NutsNotFoundException nutsNotFoundException) {
                    // empty catch block
                }
                try {
                    newId = (NutsId)ws.search().setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ANYWHERE)).addId("net.thevpc.nuts:nuts#" + v).setLatest(true).getResultIds().first();
                    newFile = newId == null ? null : this.latestOnlineDependencies(this.fetch0()).setFailFast(false).setSession(session).setId(newId).getResultDefinition();
                }
                catch (NutsNotFoundException ex) {
                    this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("error : {0}", new Object[]{ex});
                }
                break;
            }
            case RUNTIME: {
                oldId = ws.getRuntimeId();
                NutsId confId = ws.config().stored().getRuntimeId();
                if (confId != null) {
                    oldId = confId;
                }
                if (oldId != null) {
                    try {
                        oldFile = this.fetch0().setId(oldId).setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).getResultDefinition();
                    }
                    catch (NutsNotFoundException ex) {
                        this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("error : {0}", new Object[]{ex});
                    }
                }
                try {
                    NutsSearchCommand se = ws.search().addId(oldFile != null ? oldFile.getId().builder().setVersion("").build().toString() : "net.thevpc.nuts:nuts-runtime").setRuntime(true).setTargetApiVersion(bootApiVersion).addLockedIds(this.getLockedIds()).setLatest(true).setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ANYWHERE)).sort(this.LATEST_VERSION_FIRST);
                    newId = (NutsId)se.getResultIds().first();
                    newFile = newId == null ? null : this.latestOnlineDependencies(this.fetch0().setId(newId)).setSession(session).setFailFast(false).getResultDefinition();
                }
                catch (NutsNotFoundException ex) {
                    this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("error : {0}", new Object[]{ex});
                }
                break;
            }
        }
        NutsId cnewId = this.toCanonicalForm(newId);
        NutsId coldId = this.toCanonicalForm(oldId);
        DefaultNutsUpdateResult defaultNutsUpdateResult = new DefaultNutsUpdateResult(id, oldFile, newFile, newFile == null ? null : (NutsId[])newFile.getDependencies().stream().map(NutsDependency::toId).toArray(NutsId[]::new), false);
        if (cnewId != null && newFile != null && coldId != null && cnewId.getVersion().compareTo(coldId.getVersion()) > 0) {
            defaultNutsUpdateResult.setUpdateVersionAvailable(true);
        }
        return defaultNutsUpdateResult;
    }

    private NutsId toCanonicalForm(NutsId id) {
        String oldValue;
        if (id != null && (oldValue = (String)(id = id.builder().setRepository(null).build()).getProperties().get("face")) != null && oldValue.trim().isEmpty()) {
            id = id.builder().setProperty("face", null).build();
        }
        return id;
    }

    private void applyRegularUpdate(DefaultNutsUpdateResult r) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (r.isUpdateApplied()) {
            return;
        }
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        NutsSession session = this.getSession();
        NutsPrintStream out = session.out();
        NutsDefinition d0 = r.getLocal();
        NutsDefinition d1 = r.getAvailable();
        if (d0 == null) {
            this.getSession().getWorkspace().security().checkAllowed("update", "update");
            dws.updateImpl(d1, new String[0], null, session, true);
            r.setUpdateApplied(true);
        } else if (d1 != null) {
            NutsVersion v0 = d0.getId().getVersion();
            NutsVersion v1 = d1.getId().getVersion();
            if (v1.compareTo(v0) <= 0) {
                if (r.isUpdateForced()) {
                    this.getSession().getWorkspace().security().checkAllowed("update", "update");
                    dws.updateImpl(d1, new String[0], null, session, true);
                    r.setUpdateApplied(true);
                    r.setUpdateForced(true);
                } else {
                    dws.getInstalledRepository().setDefaultVersion(d1.getId(), session);
                }
            } else {
                this.getSession().getWorkspace().security().checkAllowed("update", "update");
                dws.updateImpl(d1, new String[0], null, session, true);
                r.setUpdateApplied(true);
            }
        }
        this.traceSingleUpdate(r);
    }

    private static abstract class FixAction {
        private NutsId id;
        private String problemKey;

        public FixAction(NutsId id, String problemKey) {
            this.id = id;
            this.problemKey = problemKey;
        }

        public NutsId getId() {
            return this.id;
        }

        public String getProblemKey() {
            return this.problemKey;
        }

        public abstract void fix(NutsSession var1);

        public String toString() {
            return "FixAction{id=" + this.id + ", problemKey='" + this.problemKey + '\'' + '}';
        }
    }

    public static enum Type {
        API,
        RUNTIME,
        REGULAR,
        EXTENSION,
        COMPANION;

    }
}

