/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsExecutableCommand;

public class DefaultNutsSystemExecutable
extends AbstractNutsExecutableCommand {
    String[] cmd;
    String[] executorOptions;
    NutsSession traceSession;
    NutsSession execSession;
    NutsExecCommand execCommand;
    private boolean showCommand = false;
    private final boolean inheritSystemIO;

    public DefaultNutsSystemExecutable(String[] cmd, String[] executorOptions, NutsSession traceSession, NutsSession execSession, NutsExecCommand execCommand) {
        super(cmd[0], execSession.getWorkspace().commandLine().create(cmd).toString(), NutsExecutableType.SYSTEM);
        this.inheritSystemIO = execCommand.isInheritSystemIO();
        this.cmd = cmd;
        this.execCommand = execCommand;
        this.executorOptions = executorOptions == null ? new String[]{} : executorOptions;
        this.traceSession = traceSession;
        this.execSession = execSession;
        NutsCommandLine cmdLine = execSession.getWorkspace().commandLine().create(this.executorOptions);
        block6: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            switch (a.getStringKey()) {
                case "--show-command": {
                    this.showCommand = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block6;
                }
            }
            cmdLine.skip();
        }
    }

    public NutsId getId() {
        return null;
    }

    private ProcessExecHelper resolveExecHelper() {
        HashMap<String, String> e2 = null;
        Map env1 = this.execCommand.getEnv();
        if (env1 != null) {
            e2 = new HashMap<String, String>(env1);
        }
        return ProcessExecHelper.ofArgs(this.execCommand.getCommand(), e2, CoreIOUtils.toPath(this.execCommand.getDirectory()), this.traceSession.getTerminal(), this.execSession.getTerminal(), this.showCommand, true, this.execCommand.getSleepMillis(), this.inheritSystemIO, false, null, null, this.execCommand.getRunAs(), this.traceSession);
    }

    @Override
    public void execute() {
        this.resolveExecHelper().exec();
    }

    @Override
    public void dryExecute() {
        this.resolveExecHelper().dryExec();
    }

    @Override
    public String getHelpText() {
        switch (this.execSession.getWorkspace().env().getOsFamily()) {
            case WINDOWS: {
                return "No help available. Try " + this.getName() + " /help";
            }
        }
        return "No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'";
    }

    public String toString() {
        return this.execCommand.getRunAs() + "_CMD " + this.execSession.getWorkspace().commandLine().create(this.cmd).toString();
    }
}

