/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.NutsInstallStatusIdFilter;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.commands.repo.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.NutsPatternIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterOr;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsSearch;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsSearchCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsFetchCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsInstallStatuses;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsRepositoryAndFetchMode;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsSearchCommand
extends AbstractNutsSearchCommand {
    public DefaultNutsSearchCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsSearchCommand copy() {
        DefaultNutsSearchCommand b = new DefaultNutsSearchCommand(this.ws);
        b.copyFrom(this);
        return b;
    }

    private NutsRepositoryFilter createRepositoryFilter(NutsInstallStatusFilter status, NutsIdFilter _idFilter, NutsSession session) {
        boolean searchInInstalled = true;
        boolean searchInOtherRepositories = true;
        if (status != null && Arrays.stream(NutsInstallStatuses.ALL_DEPLOYED).noneMatch(x -> status.acceptInstallStatus(x, session))) {
            searchInInstalled = false;
        }
        if (status != null && Arrays.stream(NutsInstallStatuses.ALL_UNDEPLOYED).noneMatch(x -> status.acceptInstallStatus(x, session))) {
            searchInOtherRepositories = false;
        }
        ArrayList<Object> otherFilters = new ArrayList<Object>();
        if (_idFilter != null && _idFilter.getFilterOp() == NutsFilterOp.AND) {
            searchInOtherRepositories = true;
            for (NutsFilter subFilter : _idFilter.getSubFilters()) {
                if (subFilter instanceof NutsInstallStatusIdFilter) {
                    NutsInstallStatusFilter status2 = ((NutsInstallStatusIdFilter)subFilter).getInstallStatus();
                    if (searchInInstalled && status != null && Arrays.stream(NutsInstallStatuses.ALL_DEPLOYED).noneMatch(x -> status2.acceptInstallStatus(x, session))) {
                        searchInInstalled = false;
                    }
                    if (searchInOtherRepositories && status != null && Arrays.stream(NutsInstallStatuses.ALL_UNDEPLOYED).noneMatch(x -> status2.acceptInstallStatus(x, session))) {
                        searchInOtherRepositories = false;
                    }
                }
                if (!(subFilter instanceof NutsRepositoryFilter)) continue;
                otherFilters.add((NutsRepositoryFilter)subFilter);
            }
        }
        if (!searchInInstalled && searchInOtherRepositories) {
            otherFilters.add(session.getWorkspace().filters().repository().installedRepo().neg());
        } else if (searchInInstalled && !searchInOtherRepositories) {
            otherFilters.add(session.getWorkspace().filters().repository().installedRepo());
        } else if (!searchInInstalled && !searchInOtherRepositories) {
            otherFilters.add(session.getWorkspace().filters().repository().never());
        }
        if (otherFilters.isEmpty()) {
            return null;
        }
        NutsRepositoryFilter r = (NutsRepositoryFilter)otherFilters.get(0);
        for (int i = 1; i < otherFilters.size(); ++i) {
            r = r.and((NutsRepositoryFilter)otherFilters.get(i));
        }
        return r;
    }

    public NutsFetchCommand toFetch() {
        this.checkSession();
        NutsFetchCommand t = ((NutsFetchCommand)new DefaultNutsFetchCommand(this.ws).copyFromDefaultNutsQueryBaseOptions(this)).setSession(this.getSession());
        if (this.getDisplayOptions().isRequireDefinition()) {
            t.setContent(true);
        }
        DefaultNutsSearch bs = this.build();
        t.setRepositoryFilter(bs.getRepositoryFilter());
        return t;
    }

    private DefaultNutsSearch build() {
        NutsRepositoryFilter extraRepositoryFilter;
        NutsPatternIdFilter f;
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        HashSet<String> someIds = new HashSet<String>();
        for (NutsId id : this.getIds()) {
            someIds.add(id.toString());
        }
        if (this.getIds().length == 0 && this.isCompanion()) {
            someIds.addAll(ws.getCompanionIds(this.session).stream().map(NutsId::getShortName).collect(Collectors.toList()));
        }
        if (this.getIds().length == 0 && this.isRuntime()) {
            someIds.add("net.thevpc.nuts:nuts-runtime");
        }
        HashSet<String> goodIds = new HashSet<String>();
        HashSet<String> wildcardIds = new HashSet<String>();
        for (String someId : someIds) {
            if (NutsPatternIdFilter.containsWildcad(someId)) {
                wildcardIds.add(someId);
                continue;
            }
            goodIds.add(someId);
        }
        Object idFilter0 = this.getIdFilter();
        if (idFilter0 instanceof NutsPatternIdFilter && !(f = (NutsPatternIdFilter)idFilter0).isWildcard()) {
            goodIds.add(f.getId().toString());
            idFilter0 = null;
        }
        if (idFilter0 instanceof NutsIdFilterOr) {
            ArrayList<NutsIdFilter> oo = new ArrayList<NutsIdFilter>(Arrays.asList(((NutsIdFilterOr)idFilter0).getChildren()));
            boolean someChange = false;
            Iterator it = oo.iterator();
            while (it.hasNext()) {
                String[] f2;
                NutsIdFilter curr = (NutsIdFilter)it.next();
                if (!(curr instanceof NutsPatternIdFilter) || (f2 = (String[])curr).isWildcard()) continue;
                goodIds.add(f2.getId().toString());
                it.remove();
                someChange = true;
            }
            if (someChange) {
                idFilter0 = oo.isEmpty() ? null : (NutsIdFilter)ws.id().filter().any((NutsFilter[])oo.toArray(new NutsIdFilter[0]));
            }
        }
        NutsDescriptorFilter _descriptorFilter = (NutsDescriptorFilter)ws.descriptor().filter().always();
        NutsIdFilter _idFilter = (NutsIdFilter)ws.id().filter().always();
        NutsDependencyFilter depFilter = (NutsDependencyFilter)ws.dependency().filter().always();
        NutsRepositoryFilter rfilter = (NutsRepositoryFilter)ws.repos().filter().always();
        for (String j : this.getScripts()) {
            if (NutsUtilStrings.isBlank((CharSequence)j)) continue;
            if (CoreStringUtils.containsTopWord(j, "descriptor")) {
                _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byExpression(j));
                continue;
            }
            if (CoreStringUtils.containsTopWord(j, "dependency")) {
                depFilter = depFilter.and(ws.dependency().filter().byExpression(j));
                continue;
            }
            _idFilter = _idFilter.and(ws.id().filter().byExpression(j));
        }
        NutsDescriptorFilter packs = ws.descriptor().filter().byPackaging(this.getPackaging());
        NutsDescriptorFilter archs = ws.descriptor().filter().byArch(this.getArch());
        _descriptorFilter = _descriptorFilter.and(packs).and(archs);
        NutsRepositoryFilter _repositoryFilter = rfilter.and(this.getRepositoryFilter());
        _descriptorFilter = _descriptorFilter.and(this.getDescriptorFilter());
        _idFilter = _idFilter.and(idFilter0);
        if (this.getInstallStatus() != null) {
            _idFilter = _idFilter.and(ws.id().filter().byInstallStatus(this.getInstallStatus()));
        }
        if (this.getDefaultVersions() != null) {
            _idFilter = _idFilter.and(ws.id().filter().byDefaultVersion(this.getDefaultVersions()));
        }
        if (this.execType != null) {
            switch (this.execType) {
                case "lib": {
                    _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byApp(Boolean.valueOf(false))).and(ws.descriptor().filter().byExec(Boolean.valueOf(false)));
                    break;
                }
                case "exec": {
                    _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byExec(Boolean.valueOf(true)));
                    break;
                }
                case "app": {
                    _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byApp(Boolean.valueOf(true)));
                    break;
                }
                case "extension": {
                    _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byExtension(this.targetApiVersion));
                    break;
                }
                case "runtime": {
                    _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byRuntime(this.targetApiVersion));
                    break;
                }
                case "companions": {
                    _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byCompanion(this.targetApiVersion));
                }
            }
        } else if (this.targetApiVersion != null) {
            _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byApiVersion(this.targetApiVersion));
        }
        if (!this.lockedIds.isEmpty()) {
            _descriptorFilter = _descriptorFilter.and(ws.descriptor().filter().byLockedIds((String[])this.lockedIds.stream().map(NutsId::getFullName).toArray(String[]::new)));
        }
        if (!wildcardIds.isEmpty()) {
            _idFilter = _idFilter.and(ws.id().filter().byName(wildcardIds.toArray(new String[0])));
        }
        if ((extraRepositoryFilter = this.createRepositoryFilter(this.installStatus, _idFilter, this.getSession())) != null) {
            _repositoryFilter = _repositoryFilter.and(extraRepositoryFilter);
        }
        return new DefaultNutsSearch(goodIds.toArray(new String[0]), _repositoryFilter, _idFilter, _descriptorFilter, this.getSession());
    }

    @Override
    public Iterator<NutsId> getResultIdIteratorBase(Boolean forceInlineDependencies) {
        boolean inlineDependencies = forceInlineDependencies == null ? this.isInlineDependencies() : forceInlineDependencies.booleanValue();
        DefaultNutsSearch search = this.build();
        ArrayList allResults = new ArrayList();
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsSession session = search.getSession();
        NutsWorkspaceUtils.checkSession(ws, session);
        NutsIdFilter sIdFilter = search.getIdFilter();
        NutsRepositoryFilter sRepositoryFilter = search.getRepositoryFilter();
        NutsDescriptorFilter sDescriptorFilter = search.getDescriptorFilter();
        String[] regularIds = search.getRegularIds();
        NutsFetchStrategy fetchMode = NutsWorkspaceHelper.validate(session.getFetchStrategy());
        HashSet<NutsRepository> consideredRepos = new HashSet<NutsRepository>();
        NutsWorkspaceUtils wu = NutsWorkspaceUtils.of(session);
        if (regularIds.length > 0) {
            for (String id : regularIds) {
                Object aImport2;
                NutsId nutsId2 = ws.id().parser().parse(id);
                if (nutsId2 == null) continue;
                ArrayList<Object> nutsId22 = new ArrayList<Object>();
                if (NutsUtilStrings.isBlank((CharSequence)nutsId2.getGroupId())) {
                    if (nutsId2.getArtifactId().equals("nuts")) {
                        nutsId22.add(nutsId2.builder().setGroupId("net.thevpc.nuts").build());
                    } else {
                        List installedIds = Collections.emptyList();
                        if (!nutsId2.getArtifactId().contains("*")) {
                            NutsRepositorySPI repoSPI = wu.repoSPI(NutsWorkspaceExt.of(this.getWorkspace()).getInstalledRepository());
                            Iterator it = repoSPI.search().setFetchMode(NutsFetchMode.LOCAL).setFilter(ws.filters().id().byName(new String[]{nutsId2.builder().setGroupId("*").build().toString()})).setSession(this.getSession()).getResult();
                            installedIds = IteratorUtils.toList(it);
                        }
                        if (!installedIds.isEmpty()) {
                            nutsId22.addAll(installedIds);
                        } else {
                            for (Object aImport2 : ws.imports().getAll()) {
                                nutsId22.add(nutsId2.builder().setGroupId((String)aImport2).build());
                                nutsId22.add(nutsId2.builder().setGroupId((String)aImport2 + "." + nutsId2.getArtifactId()).build());
                            }
                        }
                    }
                } else {
                    nutsId22.add(nutsId2);
                }
                ArrayList coalesce = new ArrayList();
                NutsSession finalSession = session;
                aImport2 = nutsId22.iterator();
                while (aImport2.hasNext()) {
                    NutsId nutsId1 = (NutsId)aImport2.next();
                    ArrayList idLookup = new ArrayList();
                    NutsIdFilter idFilter2 = (NutsIdFilter)ws.filters().all(new NutsFilter[]{sIdFilter, ws.id().filter().byName(new String[]{nutsId1.getFullName()})});
                    NutsIdFilter filter = CoreNutsUtils.simplify(CoreFilterUtils.idFilterOf(nutsId1.getProperties(), idFilter2, sDescriptorFilter, ws));
                    List<NutsRepositoryAndFetchMode> repositoryAndFetchModes = wu.filterRepositoryAndFetchModes(NutsRepositorySupportedAction.SEARCH, nutsId1, sRepositoryFilter, fetchMode, session);
                    for (NutsRepositoryAndFetchMode repoAndMode : repositoryAndFetchModes) {
                        consideredRepos.add(repoAndMode.getRepository());
                        NutsRepositorySPI repoSPI = wu.repoSPI(repoAndMode.getRepository());
                        idLookup.add(IteratorBuilder.ofLazyNamed("searchVersions(" + repoAndMode.getRepository().getName() + "," + repoAndMode.getFetchMode() + "," + sRepositoryFilter + "," + finalSession + ")", () -> repoSPI.searchVersions().setId(nutsId1).setFilter(filter).setSession(finalSession).setFetchMode(repoAndMode.getFetchMode()).getResult()).safeIgnore().iterator());
                    }
                    coalesce.add(fetchMode.isStopFast() ? IteratorUtils.coalesce(idLookup) : IteratorUtils.concat(idLookup));
                }
                if (nutsId2.getGroupId() == null) {
                    NutsSearchCommand search2 = ws.search().setSession(session).setRepositoryFilter(search.getRepositoryFilter()).setDescriptorFilter(search.getDescriptorFilter());
                    search2.setIdFilter(ws.id().filter().byName(new String[]{nutsId2.builder().setGroupId("*").build().toString()}).and(search.getIdFilter()));
                    Iterator extraResult = search2.getResultIds().iterator();
                    if (fetchMode.isStopFast()) {
                        coalesce.add(extraResult);
                        allResults.add(IteratorUtils.coalesce(coalesce));
                        continue;
                    }
                    allResults.add(IteratorUtils.coalesce(Arrays.asList(IteratorUtils.concat(coalesce), extraResult)));
                    continue;
                }
                allResults.add(fetchMode.isStopFast() ? IteratorUtils.coalesce(coalesce) : IteratorUtils.concat(coalesce));
            }
        } else {
            NutsIdFilter filter = CoreNutsUtils.simplify(CoreFilterUtils.idFilterOf(null, sIdFilter, sDescriptorFilter, ws));
            ArrayList all = new ArrayList();
            for (NutsRepositoryAndFetchMode repoAndMode : wu.filterRepositoryAndFetchModes(NutsRepositorySupportedAction.SEARCH, null, sRepositoryFilter, fetchMode, session)) {
                consideredRepos.add(repoAndMode.getRepository());
                NutsSession finalSession1 = session;
                all.add(IteratorBuilder.ofLazyNamed("search(" + repoAndMode.getRepository().getName() + "," + repoAndMode.getFetchMode() + "," + sRepositoryFilter + "," + session + ")", () -> wu.repoSPI(repoAndMode.getRepository()).search().setFilter(filter).setSession(finalSession1).setFetchMode(repoAndMode.getFetchMode()).getResult()).safeIgnore().iterator());
            }
            allResults.add(fetchMode.isStopFast() ? IteratorUtils.coalesce(all) : IteratorUtils.concat(all));
        }
        Iterator<Object> baseIterator = IteratorUtils.concat(allResults);
        if (inlineDependencies) {
            if (this.isLatest() || this.isDistinct()) {
                if (!this.isLatest() && this.isDistinct()) {
                    baseIterator = IteratorBuilder.of(baseIterator).distinct(nutsId -> nutsId.getLongNameId().toString()).iterator();
                } else if (this.isLatest() && this.isDistinct()) {
                    Iterator<NutsId> curr = baseIterator;
                    baseIterator = IteratorUtils.supplier(() -> {
                        LinkedHashMap<String, NutsId> visited = new LinkedHashMap<String, NutsId>();
                        while (curr.hasNext()) {
                            NutsId nutsId = (NutsId)curr.next();
                            String k = nutsId.getShortName();
                            NutsId old = (NutsId)visited.get(k);
                            if (old != null && !old.getVersion().isBlank() && old.getVersion().compareTo(nutsId.getVersion()) >= 0) continue;
                            visited.put(k, nutsId);
                        }
                        return visited.values().iterator();
                    }, "latestAndDistinct");
                } else if (this.isLatest() && !this.isDistinct()) {
                    Iterator<Object> curr = baseIterator;
                    baseIterator = IteratorUtils.supplier(() -> {
                        LinkedHashMap<String, ArrayList<NutsId>> visited = new LinkedHashMap<String, ArrayList<NutsId>>();
                        while (curr.hasNext()) {
                            NutsId old;
                            NutsId nutsId = (NutsId)curr.next();
                            String k = nutsId.getShortName();
                            List oldList = (List)visited.get(k);
                            NutsId nutsId2 = old = oldList == null ? null : (NutsId)oldList.get(0);
                            if (old == null || old.getVersion().isBlank() || old.getVersion().compareTo(nutsId.getVersion()) < 0) {
                                visited.put(k, new ArrayList<NutsId>(Arrays.asList(nutsId)));
                                continue;
                            }
                            if (old.getVersion().compareTo(nutsId.getVersion()) != 0) continue;
                            oldList.add(nutsId);
                        }
                        return IteratorUtils.name("latestAndDuplicate", IteratorUtils.flatCollection(visited.values().iterator()));
                    }, "latestAndDuplicate");
                }
            }
            Iterator<NutsId> curr = baseIterator;
            baseIterator = IteratorUtils.flatMap(curr, x -> IteratorUtils.convert(this.toFetch().setId(x).setContent(false).setDependencies(true).getResultDefinition().getDependencies().mergedDependencies().iterator(), y -> y.toId(), "dependencyToId"));
        }
        if (this.isLatest() || this.isDistinct()) {
            if (!this.isLatest() && this.isDistinct()) {
                baseIterator = IteratorBuilder.of(baseIterator).distinct(nutsId -> nutsId.getLongNameId().toString()).iterator();
            } else if (this.isLatest() && this.isDistinct()) {
                Iterator<NutsId> curr = baseIterator;
                baseIterator = IteratorUtils.supplier(() -> {
                    LinkedHashMap<String, NutsId> visited = new LinkedHashMap<String, NutsId>();
                    while (curr.hasNext()) {
                        NutsId nutsId = (NutsId)curr.next();
                        String k = nutsId.getShortName();
                        NutsId old = (NutsId)visited.get(k);
                        if (old != null && !old.getVersion().isBlank() && old.getVersion().compareTo(nutsId.getVersion()) >= 0) continue;
                        visited.put(k, nutsId);
                    }
                    return visited.values().iterator();
                }, "latestAndDistinct");
            } else if (this.isLatest() && !this.isDistinct()) {
                Iterator<Object> curr = baseIterator;
                baseIterator = IteratorUtils.supplier(() -> {
                    LinkedHashMap<String, ArrayList<NutsId>> visited = new LinkedHashMap<String, ArrayList<NutsId>>();
                    while (curr.hasNext()) {
                        NutsId old;
                        NutsId nutsId = (NutsId)curr.next();
                        String k = nutsId.getShortName();
                        List oldList = (List)visited.get(k);
                        NutsId nutsId2 = old = oldList == null ? null : (NutsId)oldList.get(0);
                        if (old == null || old.getVersion().isBlank() || old.getVersion().compareTo(nutsId.getVersion()) < 0) {
                            visited.put(k, new ArrayList<NutsId>(Arrays.asList(nutsId)));
                            continue;
                        }
                        if (old.getVersion().compareTo(nutsId.getVersion()) != 0) continue;
                        oldList.add(nutsId);
                    }
                    return IteratorUtils.name("latestAndDuplicate", IteratorUtils.flatCollection(visited.values().iterator()));
                }, "latestAndDuplicate");
            }
        }
        if (this.isSorted()) {
            baseIterator = IteratorUtils.sort(baseIterator, this.comparator, false);
        }
        return baseIterator;
    }
}

