/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutableInformation;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultInternalNutsExecutableCommand;

public class DefaultNutsHelpInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    private final NutsLogger LOG;

    public DefaultNutsHelpInternalExecutable(String[] args, NutsSession session) {
        super("help", args, session);
        this.LOG = session.getWorkspace().log().of(DefaultNutsHelpInternalExecutable.class);
    }

    @Override
    public void execute() {
        if (CoreNutsUtils.isIncludesHelpOption(this.args)) {
            this.showDefaultHelp();
            return;
        }
        ArrayList<String> helpFor = new ArrayList<String>();
        NutsCommandLine cmdLine = this.getSession().getWorkspace().commandLine().create(this.args);
        NutsContentType outputFormat = NutsContentType.PLAIN;
        boolean helpColors = false;
        block12: while (cmdLine.hasNext()) {
            NutsContentType of = CoreNutsUtils.readOptionOutputFormat(cmdLine);
            if (of != null) {
                outputFormat = of;
                continue;
            }
            NutsArgument a = cmdLine.peek();
            if (a.isOption()) {
                switch (a.getStringKey()) {
                    case "--colors": 
                    case "--ntf": {
                        NutsArgument c = cmdLine.nextBoolean(new String[0]);
                        if (!c.isEnabled()) continue block12;
                        helpColors = c.getBooleanValue();
                        break;
                    }
                    default: {
                        this.getSession().configureLast(cmdLine);
                        break;
                    }
                }
                continue;
            }
            cmdLine.skip();
            helpFor.add(a.getString());
            helpFor.addAll(Arrays.asList(cmdLine.toStringArray()));
            cmdLine.skipAll();
        }
        if (helpColors) {
            NutsTextManager txt = this.getSession().getWorkspace().text();
            NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/ntf-help.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
            this.getSession().getTerminal().out().print(n == null ? "no help found for " + this.name : n.toString());
        }
        switch (outputFormat) {
            case PLAIN: {
                NutsPrintStream fout = this.getSession().out();
                if (!helpColors && helpFor.isEmpty()) {
                    fout.println(NutsWorkspaceExt.of(this.getSession().getWorkspace()).getHelpText(this.getSession()));
                    fout.flush();
                }
                for (String arg : helpFor) {
                    NutsExecutableInformation w = null;
                    if (arg.equals("help")) {
                        fout.println(arg + " :");
                        this.showDefaultHelp();
                        fout.flush();
                        continue;
                    }
                    try {
                        w = this.getSession().getWorkspace().exec().addCommand(new String[]{arg}).which();
                    }
                    catch (Exception ex) {
                        this.LOG.with().session(this.getSession()).level(Level.FINE).error((Throwable)ex).log("failed to execute : {0}", new Object[]{arg});
                    }
                    if (w != null) {
                        fout.println(arg + " :");
                        fout.println(w.getHelpText());
                        fout.flush();
                        continue;
                    }
                    this.getSession().getTerminal().err().println(arg + " : Not found");
                }
                break;
            }
            default: {
                throw new NutsUnsupportedOperationException(this.getSession(), NutsMessage.cstyle((String)"unsupported format %s", (Object[])new Object[]{outputFormat}));
            }
        }
    }
}

