/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDeployCommand;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.bundles.io.ZipOptions;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsDeployCommand;

public class DefaultNutsDeployCommand
extends AbstractNutsDeployCommand {
    public DefaultNutsDeployCommand(NutsWorkspace ws) {
        super(ws);
    }

    private static CharacterizedDeployFile characterizeForDeploy(NutsWorkspace ws, NutsInput contentFile, NutsFetchCommand options, String[] parseOptions, NutsSession session) {
        CharacterizedDeployFile c;
        block12: {
            if (parseOptions == null) {
                parseOptions = new String[]{};
            }
            NutsWorkspaceUtils.checkSession(ws, session);
            c = new CharacterizedDeployFile();
            try {
                c.baseFile = CoreIOUtils.toPathInputSource(contentFile, c.temps, session);
                c.contentFile = contentFile;
                Path fileSource = c.contentFile.getFilePath();
                if (!Files.exists(fileSource, new LinkOption[0])) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"file does not exists %s", (Object[])new Object[]{fileSource}));
                }
                if (c.descriptor == null && c.baseFile.isURL()) {
                    try {
                        c.descriptor = ws.descriptor().parser().setSession(session).parse(ws.io().input().of(c.baseFile.getURL().toString() + "." + "nuts.json").open());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Files.isDirectory(fileSource, new LinkOption[0])) {
                    if (c.descriptor == null) {
                        Path ext = fileSource.resolve("nuts.json");
                        c.descriptor = Files.exists(ext, new LinkOption[0]) ? ws.descriptor().parser().setSession(session).parse(ext) : CoreIOUtils.resolveNutsDescriptorFromFileContent(c.contentFile, parseOptions, session);
                    }
                    if (c.descriptor == null) break block12;
                    if ("zip".equals(c.descriptor.getPackaging())) {
                        Path zipFilePath = Paths.get(ws.io().expandPath(fileSource.toString() + ".zip"), new String[0]);
                        ZipUtils.zip(ws, fileSource.toString(), new ZipOptions(), zipFilePath.toString());
                        c.contentFile = ws.io().input().setMultiRead(true).of(zipFilePath);
                        c.addTemp(zipFilePath);
                        break block12;
                    }
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid Nut Folder source. expected 'zip' ext in descriptor", (Object[])new Object[0]));
                }
                if (Files.isRegularFile(fileSource, new LinkOption[0])) {
                    if (c.descriptor == null) {
                        File ext = new File(ws.io().expandPath(fileSource.toString() + "." + "nuts.json"));
                        c.descriptor = ext.exists() ? ws.descriptor().parser().setSession(session).parse(ext) : CoreIOUtils.resolveNutsDescriptorFromFileContent(c.contentFile, parseOptions, session);
                    }
                    break block12;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"path does not denote a valid file or folder %s", (Object[])new Object[]{c.contentFile}));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return c;
    }

    public NutsDeployCommand run() {
        this.checkSession();
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (this.getContent() != null || this.getDescriptor() != null || this.getSha1() != null || this.getDescSha1() != null) {
            this.runDeployFile();
        }
        if (this.ids.size() > 0) {
            for (NutsId nutsId : ws.search().setSession(CoreNutsUtils.silent(this.getSession())).addIds(this.ids.toArray(new NutsId[0])).setLatest(true).setRepository(this.fromRepository).getResultIds()) {
                NutsDefinition fetched = ws.fetch().setContent(true).setId(nutsId).setSession(this.getSession()).getResultDefinition();
                if (fetched.getPath() == null) continue;
                this.runDeployFile(fetched.getPath(), fetched.getDescriptor(), null);
            }
        }
        if (this.result == null || this.result.isEmpty()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"missing package to deploy"));
        }
        if (this.getSession().isTrace()) {
            this.getSession().getWorkspace().formats().object((Object)this.result).println();
        }
        return this;
    }

    private NutsDeployCommand runDeployFile() {
        return this.runDeployFile(this.getContent(), this.getDescriptor(), this.getDescSha1());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NutsDeployCommand runDeployFile(Object content, Object descriptor0, String descSHA1) {
        block36: {
            this.checkSession();
            ws = this.getSession().getWorkspace();
            dws = NutsWorkspaceExt.of(ws);
            wu = NutsWorkspaceUtils.of(this.session);
            wu.checkReadOnly();
            tempFile = null;
            contentSource = ws.io().input().setMultiRead(true).setTypeName("artifact binaries").of(content);
            descriptor = this.buildDescriptor(descriptor0, descSHA1);
            characterizedFile = null;
            contentFile2 = null;
            try {
                block35: {
                    validWorkspaceSession = this.getSession();
                    if (descriptor == null) {
                        p = ws.fetch().setSession(validWorkspaceSession.copy().setTransitive(Boolean.valueOf(true)));
                        characterizedFile = DefaultNutsDeployCommand.characterizeForDeploy(ws, contentSource, p, this.getParseOptions(), validWorkspaceSession);
                        if (characterizedFile.descriptor == null) {
                            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing descriptor", (Object[])new Object[0]));
                        }
                        descriptor = characterizedFile.descriptor;
                    }
                    name = ws.locations().getDefaultIdFilename(descriptor.getId().builder().setFaceDescriptor().build());
                    tempFile = Paths.get(ws.io().tmp().setSession(this.session).createTempFile(name), new String[0]);
                    ws.io().copy().setSession(validWorkspaceSession).from(contentSource.open()).to(tempFile).setSafe(true).run();
                    contentFile0 = contentFile2 = tempFile;
                    repository = this.getTargetRepository();
                    wu.checkReadOnly();
                    contentFile = contentFile0;
                    tempFile2 = null;
                    try {
                        block38: {
                            block37: {
                                if (!Files.isDirectory(contentFile, new LinkOption[0])) break block37;
                                descFile = contentFile.resolve("nuts.json");
                                if (Files.exists(descFile, new LinkOption[0])) {
                                    var19_19 = ws.descriptor().parser().setSession(this.session).parse(descFile);
                                } else {
                                    var19_20 = CoreIOUtils.resolveNutsDescriptorFromFileContent(ws.io().input().setMultiRead(true).of(contentFile), this.getParseOptions(), validWorkspaceSession);
                                }
                                if (descriptor == null) {
                                    descriptor = var19_21;
                                } else if (var19_21 != null && !var19_21.equals(descriptor)) {
                                    ws.descriptor().formatter(descriptor).print(descFile);
                                }
                                if (descriptor != null) {
                                    if ("zip".equals(descriptor.getPackaging()) == false) throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid nuts folder source; expected 'zip' ext in descriptor", (Object[])new Object[0]));
                                    zipFilePath = Paths.get(ws.io().expandPath(contentFile.toString() + ".zip"), new String[0]);
                                    try {
                                        ZipUtils.zip(ws, contentFile.toString(), new ZipOptions(), new String[]{zipFilePath.toString()});
                                    }
                                    catch (IOException ex) {
                                        throw new UncheckedIOException(ex);
                                    }
                                    tempFile2 = contentFile = zipFilePath;
                                }
                                break block38;
                            }
                            if (descriptor == null) {
                                descriptor = CoreIOUtils.resolveNutsDescriptorFromFileContent(ws.io().input().setMultiRead(true).of(contentFile), this.getParseOptions(), validWorkspaceSession);
                            }
                        }
                        if (descriptor == null) {
                            throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"artifact not found at %s", (Object[])new Object[]{contentFile}));
                        }
                        if (NutsUtilStrings.trim((String)(descriptor = descriptor.builder().setId(descriptor.getId().builder().setRepository(null).build()).build()).getId().getVersion().getValue()).endsWith("-CHECKED-OUT")) {
                            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid version %s", (Object[])new Object[]{descriptor.getId().getVersion()}));
                        }
                        effId = dws.resolveEffectiveId(descriptor, validWorkspaceSession);
                        for (String os : descriptor.getOs()) {
                            CorePlatformUtils.checkSupportedOs(ws.id().parser().setLenient(false).parse(os).getShortName());
                        }
                        for (String arch : descriptor.getArch()) {
                            CorePlatformUtils.checkSupportedArch(ws.id().parser().setLenient(false).parse(arch).getShortName());
                        }
                        if (!NutsUtilStrings.isBlank((CharSequence)repository)) ** GOTO lbl-1000
                        var19_24 = null;
                        zipFilePath = wu.filterRepositoriesDeploy(effId, var19_24).iterator();
                        if (zipFilePath.hasNext()) {
                            repo = zipFilePath.next();
                            effId = ws.config().createContentFaceId(effId.builder().setProperties("").build(), descriptor);
                            repoSPI = wu.repoSPI(repo);
                            repoSPI.deploy().setSession(validWorkspaceSession).setId(effId).setContent(contentFile).setDescriptor(descriptor).run();
                            this.addResult(effId);
                            var23_36 = this;
                            if (tempFile2 == null) break block35;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var25_38) {
                        if (tempFile2 == null) throw var25_38;
                        try {
                            Files.delete(tempFile2);
                            throw var25_38;
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    }
                    try {
                        Files.delete(tempFile2);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                if (characterizedFile != null) {
                    characterizedFile.close();
                }
                if (tempFile == null) return var23_36;
            }
            catch (Throwable var27_40) {
                if (characterizedFile != null) {
                    characterizedFile.close();
                }
                if (tempFile == null) throw var27_40;
                CoreIOUtils.delete(this.getSession(), tempFile);
                throw var27_40;
            }
            CoreIOUtils.delete(this.getSession(), tempFile);
            return var23_36;
lbl-1000:
            // 1 sources

            {
                var19_25 = this.getSession().getWorkspace().repos().getRepository(repository);
                if (var19_25 == null) {
                    throw new NutsRepositoryNotFoundException(this.getSession(), repository);
                }
                if (!var19_25.config().isEnabled()) {
                    throw new NutsRepositoryNotFoundException(this.getSession(), "Repository " + repository + " is disabled.");
                }
                effId = ws.config().createContentFaceId(effId.builder().setProperties("").build(), descriptor);
                repoSPI = wu.repoSPI(var19_25);
                repoSPI.deploy().setSession(validWorkspaceSession).setId(effId).setContent(contentFile).setDescriptor(descriptor).run();
                this.addResult(effId);
                var21_33 = this;
                if (tempFile2 == null) break block36;
            }
            try {
                Files.delete(tempFile2);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        if (characterizedFile != null) {
            characterizedFile.close();
        }
        if (tempFile == null) return var21_33;
        CoreIOUtils.delete(this.getSession(), tempFile);
        return var21_33;
lbl-1000:
        // 1 sources

        {
            throw new NutsRepositoryNotFoundException(this.getSession(), repository);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NutsDescriptor buildDescriptor(Object descriptor, String descSHA1) {
        Throwable throwable;
        InputStream is;
        if (descriptor == null) {
            return null;
        }
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsDescriptor mdescriptor = null;
        if (descriptor instanceof NutsDescriptor) {
            mdescriptor = (NutsDescriptor)descriptor;
            if (descSHA1 == null) return mdescriptor;
            if (ws.io().hash().sha1().setSource(mdescriptor).computeString().equalsIgnoreCase(descSHA1)) return mdescriptor;
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content Hash", (Object[])new Object[0]));
        }
        if (!CoreIOUtils.isValidInputStreamSource(descriptor.getClass())) {
            throw new NutsException(this.getSession(), NutsMessage.cstyle((String)"unexpected type %s", (Object[])new Object[]{descriptor.getClass().getName()}));
        }
        NutsInput inputStreamSource = ws.io().input().setMultiRead(true).setTypeName("artifact descriptor").of(descriptor);
        if (descSHA1 != null) {
            inputStreamSource = ws.io().input().setMultiRead(true).of(inputStreamSource);
            try {
                is = inputStreamSource.open();
                throwable = null;
                try {
                    if (!ws.io().hash().sha1().setSource(is).computeString().equalsIgnoreCase(descSHA1)) {
                        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content Hash", (Object[])new Object[0]));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        try {
            is = inputStreamSource.open();
            throwable = null;
            try {
                NutsDescriptor nutsDescriptor = ws.descriptor().parser().setSession(this.session).parse(is);
                return nutsDescriptor;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public NutsDeployCommand addIds(String ... values) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (values != null) {
            for (String s : values) {
                if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                this.ids.add(ws.id().parser().parse(s));
            }
        }
        return this;
    }

    @Override
    public NutsDeployCommand addIds(NutsId ... value) {
        if (value != null) {
            for (NutsId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    @Override
    public NutsDeployCommand clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NutsDeployCommand addId(NutsId id) {
        if (id != null) {
            this.addId(id.toString());
        }
        return this;
    }

    private static class CharacterizedDeployFile
    implements AutoCloseable {
        public NutsInput baseFile;
        public NutsInput contentFile;
        public List<Path> temps = new ArrayList<Path>();
        public NutsDescriptor descriptor;

        private CharacterizedDeployFile() {
        }

        public Path getContentPath() {
            return (Path)this.contentFile.getSource();
        }

        public void addTemp(Path f) {
            this.temps.add(f);
        }

        @Override
        public void close() {
            Iterator<Path> it = this.temps.iterator();
            while (it.hasNext()) {
                Path temp = it.next();
                try {
                    Files.delete(temp);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                it.remove();
            }
        }
    }
}

