/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.URLBuilder;
import net.thevpc.nuts.runtime.bundles.io.ZipOptions;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsExecutableCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsExecCommand;

public class DefaultNutsArtifactPathExecutable
extends AbstractNutsExecutableCommand {
    private final NutsLogger LOG;
    String cmdName;
    String[] args;
    String[] executorOptions;
    NutsExecutionType executionType;
    NutsRunAs runAs;
    NutsSession traceSession;
    NutsSession execSession;
    DefaultNutsExecCommand execCommand;

    public DefaultNutsArtifactPathExecutable(String cmdName, String[] args, String[] executorOptions, NutsExecutionType executionType, NutsRunAs runAs, NutsSession traceSession, NutsSession execSession, DefaultNutsExecCommand execCommand, boolean inheritSystemIO) {
        super(cmdName, execSession.getWorkspace().commandLine().create(args).toString(), NutsExecutableType.ARTIFACT);
        this.LOG = execSession.getWorkspace().log().of(DefaultNutsArtifactPathExecutable.class);
        this.runAs = runAs;
        this.cmdName = cmdName;
        this.args = args;
        this.executionType = executionType;
        this.traceSession = traceSession;
        this.execSession = execSession;
        this.execCommand = execCommand;
        ArrayList<String> executorOptionsList = new ArrayList<String>();
        for (String option : executorOptions) {
            NutsArgument a = traceSession.getWorkspace().commandLine().createArgument(option);
            if (a.getStringKey().equals("--nuts-auto-install")) {
                if (!a.isKeyValue()) continue;
                continue;
            }
            executorOptionsList.add(option);
        }
        this.executorOptions = executorOptionsList.toArray(new String[0]);
    }

    public NutsId getId() {
        try (CharacterizedExecFile c = DefaultNutsArtifactPathExecutable.characterizeForExec(this.execSession.getWorkspace().io().input().of(this.cmdName), this.traceSession, this.executorOptions);){
            NutsId nutsId = c.descriptor == null ? null : c.descriptor.getId();
            return nutsId;
        }
    }

    @Override
    public void execute() {
        this.executeHelper(false);
    }

    @Override
    public void dryExecute() {
        this.executeHelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeHelper(boolean dry) {
        NutsWorkspace ws = this.execSession.getWorkspace();
        try (CharacterizedExecFile c = DefaultNutsArtifactPathExecutable.characterizeForExec(ws.io().input().of(this.cmdName), this.traceSession, this.executorOptions);){
            if (c.descriptor == null) {
                throw new NutsNotFoundException(this.execSession, null, NutsMessage.cstyle((String)"unable to resolve a valid descriptor for %s", (Object[])new Object[]{this.cmdName}), null);
            }
            String tempFolder = ws.io().tmp().setSession(this.traceSession).createTempFolder("exec-path-");
            NutsId _id = c.descriptor.getId();
            NutsIdType idType = NutsWorkspaceExt.of(ws).resolveNutsIdType(_id, this.traceSession);
            DefaultNutsDefinition nutToRun = new DefaultNutsDefinition(null, null, _id, c.descriptor, (NutsContent)new NutsDefaultContent(this.execSession.getWorkspace().io().path(c.getContentPath()), false, c.temps.size() > 0), DefaultNutsInstallInfo.notInstalled(_id), idType, null, this.traceSession);
            try {
                this.execCommand.ws_execId(nutToRun, this.cmdName, this.args, this.executorOptions, this.execCommand.getEnv(), this.execCommand.getDirectory(), this.execCommand.isFailFast(), true, this.traceSession, this.execSession, this.executionType, this.runAs, dry);
            }
            finally {
                try {
                    CoreIOUtils.delete(this.traceSession, Paths.get(tempFolder, new String[0]));
                }
                catch (UncheckedIOException | NutsIOException e) {
                    this.LOG.with().session(this.traceSession).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("Unable to delete temp folder created for execution : " + tempFolder, new Object[0]);
                }
            }
        }
    }

    public static CharacterizedExecFile characterizeForExec(NutsInput contentFile, NutsSession session, String[] execOptions) {
        CharacterizedExecFile c;
        block32: {
            NutsWorkspace ws = session.getWorkspace();
            String classifier = null;
            c = new CharacterizedExecFile();
            try {
                c.baseFile = contentFile;
                c.contentFile = CoreIOUtils.toPathInputSource(contentFile, c.temps, session);
                Path fileSource = c.contentFile.getFilePath();
                if (!Files.exists(fileSource, new LinkOption[0])) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"file does not exists %s", (Object[])new Object[]{fileSource}));
                }
                if (Files.isDirectory(fileSource, new LinkOption[0])) {
                    Path ext = fileSource.resolve("nuts.json");
                    c.descriptor = Files.exists(ext, new LinkOption[0]) ? ws.descriptor().parser().setSession(session).parse(ext) : CoreIOUtils.resolveNutsDescriptorFromFileContent(c.contentFile, execOptions, session);
                    if (c.descriptor == null) break block32;
                    if ("zip".equals(c.descriptor.getPackaging())) {
                        Path zipFilePath = Paths.get(ws.io().expandPath(fileSource.toString() + ".zip"), new String[0]);
                        ZipUtils.zip(session.getWorkspace(), fileSource.toString(), new ZipOptions(), zipFilePath.toString());
                        c.contentFile = ws.io().input().setMultiRead(true).of(zipFilePath);
                        c.addTemp(zipFilePath);
                        break block32;
                    }
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid nuts folder source. expected 'zip' ext in descriptor", (Object[])new Object[0]));
                }
                if (Files.isRegularFile(fileSource, new LinkOption[0])) {
                    if (c.contentFile.getName().endsWith("nuts.json")) {
                        try (InputStream in = c.contentFile.open();){
                            c.descriptor = ws.descriptor().parser().setSession(session).parse(in);
                        }
                        c.contentFile = null;
                        if (c.baseFile.isURL()) {
                            URLBuilder ub = new URLBuilder(c.baseFile.getURL().toString());
                            try {
                                c.contentFile = CoreIOUtils.toPathInputSource(ws.io().input().of(ub.resolveSibling(ws.locations().getDefaultIdFilename(c.descriptor.getId())).toURL()), c.temps, session);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (c.contentFile == null) {
                            for (NutsIdLocation location0 : c.descriptor.getLocations()) {
                                if (!CoreNutsUtils.acceptClassifier(location0, classifier)) continue;
                                String location = location0.getUrl();
                                if (CoreIOUtils.isPathHttp(location)) {
                                    try {
                                        c.contentFile = CoreIOUtils.toPathInputSource(ws.io().input().of(new URL(location)), c.temps, session);
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    URLBuilder ub = new URLBuilder(c.baseFile.getURL().toString());
                                    try {
                                        c.contentFile = CoreIOUtils.toPathInputSource(ws.io().input().of(ub.resolveSibling(ws.locations().getDefaultIdFilename(c.descriptor.getId())).toURL()), c.temps, session);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (c.contentFile == null) break;
                            }
                        }
                        if (c.contentFile == null) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to locale package for %s", (Object[])new Object[]{c.baseFile}));
                        }
                        break block32;
                    }
                    c.descriptor = CoreIOUtils.resolveNutsDescriptorFromFileContent(c.contentFile, execOptions, session);
                    if (c.descriptor == null) {
                        c.descriptor = ws.descriptor().descriptorBuilder().setId("temp").setPackaging(CoreIOUtils.getFileExtension(contentFile.getName())).build();
                    }
                    break block32;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"path does not denote a valid file or folder %s", (Object[])new Object[]{c.baseFile}));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return c;
    }

    public String toString() {
        return "NUTS " + this.cmdName + " " + this.execSession.getWorkspace().commandLine().create(this.args).toString();
    }

    public static class CharacterizedExecFile
    implements AutoCloseable {
        public NutsInput contentFile;
        public NutsInput baseFile;
        public List<Path> temps = new ArrayList<Path>();
        public NutsDescriptor descriptor;
        public NutsId executor;

        public Path getContentPath() {
            return this.contentFile.getFilePath();
        }

        public void addTemp(Path f) {
            this.temps.add(f);
        }

        @Override
        public void close() {
            Iterator<Path> it = this.temps.iterator();
            while (it.hasNext()) {
                Path temp = it.next();
                try {
                    Files.delete(temp);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                it.remove();
            }
        }
    }
}

