/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayList;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnexpectedException;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsExecutableCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsExecCommand;

public class DefaultNutsArtifactExecutable
extends AbstractNutsExecutableCommand {
    NutsDefinition def;
    String commandName;
    String[] appArgs;
    String[] executorOptions;
    Map<String, String> env;
    String dir;
    boolean failFast;
    NutsSession traceSession;
    NutsSession execSession;
    NutsExecutionType executionType;
    NutsRunAs runAs;
    DefaultNutsExecCommand execCommand;
    boolean autoInstall = true;

    public DefaultNutsArtifactExecutable(NutsDefinition def, String commandName, String[] appArgs, String[] executorOptions, Map<String, String> env, String dir, boolean failFast, NutsSession traceSession, NutsSession execSession, NutsExecutionType executionType, NutsRunAs runAs, DefaultNutsExecCommand execCommand) {
        super(commandName, def.getId().getLongName(), NutsExecutableType.ARTIFACT);
        this.def = def;
        this.runAs = runAs;
        def.getContent();
        def.getDependencies();
        def.getEffectiveDescriptor();
        def.getInstallInformation();
        this.commandName = commandName;
        this.appArgs = appArgs;
        this.env = env;
        this.dir = dir;
        this.failFast = failFast;
        this.traceSession = traceSession;
        this.execSession = execSession;
        this.executionType = executionType;
        this.execCommand = execCommand;
        ArrayList<String> executorOptionsList = new ArrayList<String>();
        for (String option : executorOptions) {
            NutsArgument a = traceSession.getWorkspace().commandLine().createArgument(option);
            if (a.getStringKey().equals("--nuts-auto-install")) {
                if (a.isKeyValue()) {
                    this.autoInstall = a.isNegated() != a.getBooleanValue();
                    continue;
                }
                this.autoInstall = true;
                continue;
            }
            executorOptionsList.add(option);
        }
        this.executorOptions = executorOptionsList.toArray(new String[0]);
    }

    public NutsId getId() {
        return this.def.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        NutsInstallStatus installStatus = this.def.getInstallInformation().getInstallStatus();
        if (!installStatus.isInstalled()) {
            if (!this.autoInstall) throw new NutsUnexpectedException(this.execSession, NutsMessage.cstyle((String)"you must install %s to be able to run it", (Object[])new Object[]{this.def.getId()}));
            this.traceSession.getWorkspace().install().setSession(this.traceSession).addId(this.def.getId()).run();
            NutsInstallStatus st = this.traceSession.getWorkspace().fetch().setSession(this.traceSession).setId(this.def.getId()).getResultDefinition().getInstallInformation().getInstallStatus();
            if (!st.isInstalled()) {
                throw new NutsUnexpectedException(this.execSession, NutsMessage.cstyle((String)"auto installation of %s failed", (Object[])new Object[]{this.def.getId()}));
            }
        } else if (installStatus.isObsolete()) {
            this.traceSession.getWorkspace().install().setSession(this.traceSession).addId(this.def.getId()).run();
        }
        this.execCommand.ws_execId(this.def, this.commandName, this.appArgs, this.executorOptions, this.env, this.dir, this.failFast, false, this.traceSession, this.execSession, this.executionType, this.runAs, false);
    }

    @Override
    public void dryExecute() {
        if (this.autoInstall && !this.def.getInstallInformation().getInstallStatus().isInstalled()) {
            this.execSession.getWorkspace().security().checkAllowed("auto-install", this.commandName);
            NutsPrintStream out = this.execSession.out();
            out.printf("[dry] ==install== %s%n", new Object[]{this.def.getId().getLongName()});
        }
        this.execCommand.ws_execId(this.def, this.commandName, this.appArgs, this.executorOptions, this.env, this.dir, this.failFast, false, this.traceSession, this.execSession, this.executionType, this.runAs, true);
    }

    public String toString() {
        return "NUTS " + this.getId().toString() + " " + this.execSession.getWorkspace().commandLine().create(this.appArgs).toString();
    }
}

