/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsExecutableCommand;

public abstract class DefaultInternalNutsExecutableCommand
extends AbstractNutsExecutableCommand {
    protected String[] args;
    private NutsSession session;

    public DefaultInternalNutsExecutableCommand(String name, String[] args, NutsSession session) {
        super(name, name, NutsExecutableType.INTERNAL);
        this.args = args;
        this.session = session;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsId getId() {
        return null;
    }

    protected void showDefaultHelp() {
        this.session.out().println(this.getHelpText());
    }

    @Override
    public String getHelpText() {
        NutsTextManager txt = this.getSession().getWorkspace().text();
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/command/" + this.name + ".ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        if (n == null) {
            return "no help found for " + this.name;
        }
        return n.toString();
    }

    @Override
    public void dryExecute() {
        if (CoreNutsUtils.isIncludesHelpOption(this.args)) {
            this.getSession().out().println("[dry] ==show-help==");
            return;
        }
        NutsTextManager text = this.getSession().getWorkspace().text();
        this.getSession().out().printf("[dry] %s%n", new Object[]{text.builder().append((Object)"internal", NutsTextStyle.pale()).append((Object)" ").append((Object)this.getName(), NutsTextStyle.primary5()).append((Object)" ").append((Object)this.getSession().getWorkspace().commandLine().create(this.args))});
    }

    public String toString() {
        return this.getName() + " " + NutsCommandLine.of((String[])this.args, (NutsSession)this.getSession()).toString();
    }
}

