/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsWorkspaceCommandBase;

public abstract class AbstractNutsUpdateUserCommand
extends NutsWorkspaceCommandBase<NutsUpdateUserCommand>
implements NutsUpdateUserCommand {
    protected String login;
    protected String remoteIdentity;
    protected boolean resetPermissions;
    protected boolean resetGroups;
    protected char[] credentials;
    protected char[] oldCredentials;
    protected char[] remoteCredentials;
    protected final Set<String> permissions = new HashSet<String>();
    protected final Set<String> groups = new HashSet<String>();
    protected final Set<String> rm_permissions = new HashSet<String>();
    protected final Set<String> rm_groups = new HashSet<String>();
    protected NutsRepository repo;

    public AbstractNutsUpdateUserCommand(NutsWorkspace ws) {
        super(ws, "update-user");
    }

    public AbstractNutsUpdateUserCommand(NutsRepository repo) {
        super(repo.getWorkspace(), "update-user");
        this.repo = repo;
    }

    public char[] getCredentials() {
        return this.credentials;
    }

    public AbstractNutsUpdateUserCommand credentials(char[] password) {
        return this.setCredentials(password);
    }

    public AbstractNutsUpdateUserCommand setCredentials(char[] password) {
        this.credentials = password;
        return this;
    }

    public char[] getOldCredentials() {
        return this.oldCredentials;
    }

    public AbstractNutsUpdateUserCommand oldCredentials(char[] password) {
        return this.setOldCredentials(password);
    }

    public AbstractNutsUpdateUserCommand setOldCredentials(char[] password) {
        this.oldCredentials = password;
        return this;
    }

    public char[] getRemoteCredentials() {
        return this.remoteCredentials;
    }

    public AbstractNutsUpdateUserCommand remoteCredentials(char[] password) {
        return this.setRemoteCredentials(password);
    }

    public AbstractNutsUpdateUserCommand setRemoteCredentials(char[] password) {
        this.remoteCredentials = password;
        return this;
    }

    public String getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public AbstractNutsUpdateUserCommand remoteIdentity(String remoteIdentity) {
        return this.setRemoteIdentity(remoteIdentity);
    }

    public AbstractNutsUpdateUserCommand setRemoteIdentity(String remoteIdentity) {
        this.remoteIdentity = remoteIdentity;
        return this;
    }

    public AbstractNutsUpdateUserCommand addPermissions(String ... permissions) {
        if (permissions != null) {
            return this.addPermissions(Arrays.asList(permissions));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand removePermissions(String ... permissions) {
        if (permissions != null) {
            return this.removePermissions(Arrays.asList(permissions));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoAddPermissions(String ... permissions) {
        if (permissions != null) {
            return this.undoAddPermissions(Arrays.asList(permissions));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoRemovePermissions(String ... permissions) {
        if (permissions != null) {
            return this.undoRemovePermissions(Arrays.asList(permissions));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand addPermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String right : permissions) {
                if (right == null) continue;
                this.permissions.add(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand removePermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String right : permissions) {
                if (right == null) continue;
                this.rm_permissions.add(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoAddPermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String right : permissions) {
                if (right == null) continue;
                this.permissions.remove(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoRemovePermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String right : permissions) {
                if (right == null) continue;
                this.rm_permissions.remove(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand addGroups(String ... groups) {
        if (groups != null) {
            return this.addGroups(Arrays.asList(groups));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoAddGroups(String ... groups) {
        if (groups != null) {
            return this.undoAddGroups(Arrays.asList(groups));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand removeGroups(String ... groups) {
        if (groups != null) {
            return this.removePermissions(Arrays.asList(groups));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoRemoveGroups(String ... groups) {
        if (groups != null) {
            return this.undoRemoveGroups(Arrays.asList(groups));
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand addGroup(String group) {
        if (group != null) {
            this.groups.add(group);
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand removeGroup(String group) {
        if (group != null) {
            this.rm_groups.add(group);
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand addPermission(String permission) {
        if (permission != null) {
            this.permissions.add(permission);
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoAddPermission(String permissions) {
        if (permissions != null) {
            this.permissions.remove(permissions);
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoAddGroup(String group) {
        if (group != null) {
            this.groups.remove(group);
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand removePermission(String permission) {
        if (permission != null) {
            this.rm_permissions.add(permission);
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand addGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.groups.add(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand removeGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.rm_groups.add(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoAddGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.groups.remove(right);
            }
        }
        return this;
    }

    public AbstractNutsUpdateUserCommand undoRemoveGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.rm_groups.remove(right);
            }
        }
        return this;
    }

    public String[] getAddPermissions() {
        return this.permissions.toArray(new String[0]);
    }

    public String[] getAddGroups() {
        return this.groups.toArray(new String[0]);
    }

    public String[] getRemovePermissions() {
        return this.rm_permissions.toArray(new String[0]);
    }

    public String[] getRemoveGroups() {
        return this.rm_groups.toArray(new String[0]);
    }

    public String getUsername() {
        return this.login;
    }

    public NutsUpdateUserCommand setUsername(String login) {
        this.login = login;
        return this;
    }

    public boolean isResetPermissions() {
        return this.resetPermissions;
    }

    public NutsUpdateUserCommand resetPermissions() {
        return this.resetPermissions(true);
    }

    public NutsUpdateUserCommand resetPermissions(boolean resetPermissions) {
        return this.setResetPermissions(resetPermissions);
    }

    public NutsUpdateUserCommand setResetPermissions(boolean resetPermissions) {
        this.resetPermissions = resetPermissions;
        return this;
    }

    public boolean isResetGroups() {
        return this.resetGroups;
    }

    public NutsUpdateUserCommand resetGroups() {
        return this.resetGroups(true);
    }

    public NutsUpdateUserCommand resetGroups(boolean resetGroups) {
        return this.setResetGroups(resetGroups);
    }

    public NutsUpdateUserCommand setResetGroups(boolean resetGroups) {
        this.resetGroups = resetGroups;
        return this;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        switch (a.getStringKey()) {
            default: 
        }
        return super.configureFirst(cmdLine);
    }
}

