/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsUpdateStatisticsCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsWorkspaceCommandBase;

public abstract class AbstractNutsUpdateStatisticsCommand
extends NutsWorkspaceCommandBase<NutsUpdateStatisticsCommand>
implements NutsUpdateStatisticsCommand {
    private LinkedHashSet<Path> paths = new LinkedHashSet();
    private LinkedHashSet<String> repositrories = new LinkedHashSet();

    public AbstractNutsUpdateStatisticsCommand(NutsWorkspace ws) {
        super(ws, "update-statistics");
    }

    public NutsUpdateStatisticsCommand clearRepos() {
        this.repositrories.clear();
        return this;
    }

    public NutsUpdateStatisticsCommand addRepo(String s) {
        if (s != null) {
            this.repositrories.add(s);
        }
        return this;
    }

    public NutsUpdateStatisticsCommand removeRepo(String s) {
        if (s != null) {
            this.repositrories.remove(s);
        }
        return this;
    }

    public NutsUpdateStatisticsCommand addRepos(String ... all) {
        if (all != null) {
            for (String string : all) {
                this.addRepo(string);
            }
        }
        return this;
    }

    public NutsUpdateStatisticsCommand addRepos(Collection<String> all) {
        if (all != null) {
            for (String string : all) {
                this.addRepo(string);
            }
        }
        return this;
    }

    public String[] getRepositrories() {
        return this.repositrories.toArray(new String[0]);
    }

    public NutsUpdateStatisticsCommand clearPaths() {
        this.paths.clear();
        return this;
    }

    public NutsUpdateStatisticsCommand addPath(Path s) {
        if (s != null) {
            this.paths.add(s);
        }
        return this;
    }

    public NutsUpdateStatisticsCommand removePath(Path s) {
        if (s != null) {
            this.paths.remove(s);
        }
        return this;
    }

    public NutsUpdateStatisticsCommand addPaths(Path ... all) {
        if (all != null) {
            for (Path string : all) {
                this.addPath(string);
            }
        }
        return this;
    }

    public NutsUpdateStatisticsCommand addPaths(Collection<Path> all) {
        if (all != null) {
            for (Path string : all) {
                this.addPath(string);
            }
        }
        return this;
    }

    public Path[] getPaths() {
        return this.paths.toArray(new Path[0]);
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        switch (a.getStringKey()) {
            default: 
        }
        return super.configureFirst(cmdLine);
    }
}

